/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

public class UTFEncoder {
    public static String UTFEncodeXMLString(String instr) {
        if (instr == null) {
            return instr;
        }
        StringBuffer sb = new StringBuffer(instr.length());
        boolean beginquote = false;
        for (int i = 0; i < instr.length(); ++i) {
            char ch = instr.charAt(i);
            if (ch == '\"') {
                sb.append(ch);
                if (beginquote) {
                    beginquote = false;
                    continue;
                }
                beginquote = true;
                continue;
            }
            if (beginquote && (!UTFEncoder.isSafe(ch) || ch == '&' && !UTFEncoder.andSignIsPartOfUTFCode(instr, i))) {
                sb.append("&#" + ch + ";");
                continue;
            }
            sb.append(ch);
        }
        return new String(sb);
    }

    public static String UTFEncode(String instr) {
        if (instr == null) {
            return instr;
        }
        StringBuffer sb = new StringBuffer(instr.length());
        boolean beginquote = false;
        for (int i = 0; i < instr.length(); ++i) {
            char ch = instr.charAt(i);
            if (!UTFEncoder.isSafe(ch) || ch == '&' && !UTFEncoder.andSignIsPartOfUTFCode(instr, i)) {
                sb.append("&#" + ch + ";");
                continue;
            }
            sb.append(ch);
        }
        return new String(sb);
    }

    private static boolean andSignIsPartOfUTFCode(String instr, int i) {
        int j;
        if (instr.length() <= i + 3) {
            return false;
        }
        if (instr.charAt(i + 1) != '#') {
            return false;
        }
        for (j = i + 2; j < instr.length() && instr.charAt(j) <= '9' && instr.charAt(j) >= '0'; ++j) {
        }
        return j != i + 2 && j != instr.length() && instr.charAt(j) == ';';
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '&' || c == '-' || c == '_' || c == '.' || c == '*' || c == '#' || c == ' ' || c == '\t' || c == ';' || c == '$' || c == ',' || c == ']' || c == '[' || c == '\'';
    }
}

