/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Dimension;

public class SparseDefinition
extends BaseObject {
    private Vector m_dimensions = new Vector(0);

    public SparseDefinition() {
    }

    public SparseDefinition(BaseObject baseObject) {
        super(baseObject);
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.toUpperCase();
        if (this.m_schema == null) {
            return this.m_name.toUpperCase() + "." + string.toUpperCase();
        }
        return this.m_schema.toUpperCase() + "." + this.m_name.toUpperCase() + "." + string.toUpperCase();
    }

    public String getParentId() {
        if (this.m_schema == null) {
            return this.m_name.toUpperCase();
        }
        return this.m_schema.toUpperCase() + "." + this.m_name.toUpperCase();
    }

    public String WriteToXML() {
        String string = null;
        string = SparseDefinition.TAB() + this.WriteElementStart("SparseDefinition");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + SparseDefinition.TAB() + this.WriteElementEndTag("SparseDefinition") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        return string;
    }

    public String WriteContentsToXML() {
        ++s_Indent;
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_dimensions.iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)iterator.next();
            if (string == null) {
                string = this.WriteAsIDRef("Dimension", dimension);
                continue;
            }
            string = string + this.WriteAsIDRef("Dimension", dimension);
        }
        --s_Indent;
        return string;
    }

    public void addDimension(Dimension dimension) {
        this.m_dimensions.add(dimension);
    }

    public void addDimensionAfter(Dimension dimension, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Dimension) {
            n = this.m_dimensions.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "DIMENSIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{dimension.getId(), "DIMENSION"});
        }
        this.m_dimensions.add(n + 1, dimension);
    }

    public void addDimensionBefore(Dimension dimension, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Dimension) {
            n = this.m_dimensions.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "DIMENSIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{dimension.getId(), "DIMENSION"});
        }
        this.m_dimensions.add(n, dimension);
    }

    public void addDimensionFirst(Dimension dimension) {
        this.m_dimensions.add(0, dimension);
    }

    public void removeDimension(Dimension dimension) {
        this.m_dimensions.remove(dimension);
    }

    public Vector getDimensions() {
        return this.m_dimensions;
    }

    public String Create(AWConnection aWConnection) {
        try {
            if (this.m_schema == null || this.m_schema.length() == 0) {
                this.m_schema = aWConnection.getUserId();
            }
            String string = this.m_dimensions.size() > 0 ? this.convertMultiLineString(this.m_dimensions) : AWNULL;
            String string2 = aWConnection.executeCommand("call create_sparsedefinition(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + string + "," + AWConnection.CommitMode + ")");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-990000", new Object[]{this.m_commandResultText});
            }
        }
        catch (Exception exception) {
            throw new AWException(exception.getMessage());
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        try {
            String string = aWConnection.getUsageBasedObjectName("EXTENSIONS", null, "ALL_SPARSEDEFS");
            aWConnection.deleteDimensionValue(string, this.getId());
            String string2 = aWConnection.getPhysicalObjectName("SPARSEDEF", this.getName());
            aWConnection.deleteObj(string2);
        }
        catch (Exception exception) {
            throw new AWException(exception.getMessage());
        }
        return "success";
    }

    public String Rename(AWConnection aWConnection, String string) {
        return "success";
    }
}

