/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AggregationDefinition;
import oracle.AWXML.AggregationSolve;
import oracle.AWXML.AllocationSolve;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Cube;
import oracle.AWXML.CubeDimRef;
import oracle.AWXML.CubeMapGroup;
import oracle.AWXML.DerivedMeasureInput;
import oracle.AWXML.ExternalSourceExpression;
import oracle.AWXML.ForecastSolve;
import oracle.AWXML.MeasureFolder;
import oracle.AWXML.MeasureSourceExpression;
import oracle.AWXML.Solve;
import oracle.AWXML.SolveDefinition;
import oracle.AWXML.SolveGroup;

public class Measure
extends BaseObject
implements DerivedMeasureInput {
    private SolveDefinition m_solveDefinition;
    private boolean m_isInternal = false;
    protected String m_dataType = "Decimal";
    private Vector m_cubeDimRef = new Vector(0);
    private Boolean m_useGlobalIndex = new Boolean(false);
    private Boolean m_forceCalc = new Boolean(false);
    private Boolean m_forceOrder = new Boolean(false);
    private String m_sparseType = "STANDARD";
    private String m_autoSolve = "DEFAULT";

    protected Measure() {
    }

    public Measure(BaseObject baseObject) {
        super(baseObject);
    }

    public void setSparseType(String string) {
        this.m_sparseType = string;
    }

    public String getSparseType() {
        return this.m_sparseType;
    }

    public void setDataType(String string) {
        this.m_dataType = string;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public void setAutoSolve(String string) {
        if (!(string.equalsIgnoreCase("AUTO_SOLVE") || string.equalsIgnoreCase("NO_AUTO_SOLVE") || string.equalsIgnoreCase("DEFAULT"))) {
            throw new AWException("AWXML-ERR-NUM-140002", new Object[]{this.getId()});
        }
        this.m_autoSolve = string;
    }

    public String getAutoSolve() {
        return this.m_autoSolve;
    }

    public void addCubeDimRef(CubeDimRef cubeDimRef) {
        if (this.validateDim(cubeDimRef)) {
            this.m_cubeDimRef.add(cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCubeDimRefAfter(CubeDimRef cubeDimRef, BaseObject baseObject) {
        if (!(baseObject instanceof CubeDimRef)) throw new AWException("AWXML-ERR-NUM-900001", new Object[]{cubeDimRef.getId(), "CUBEDIMREF"});
        int n = this.m_cubeDimRef.indexOf(baseObject);
        if (n <= -1) throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "MEASUREDIMENSIONS"});
        if (this.validateDim(cubeDimRef)) {
            this.m_cubeDimRef.add(n + 1, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCubeDimRefBefore(CubeDimRef cubeDimRef, BaseObject baseObject) {
        if (!(baseObject instanceof CubeDimRef)) throw new AWException("AWXML-ERR-NUM-900001", new Object[]{cubeDimRef.getId(), "CUBEDIMREF"});
        int n = this.m_cubeDimRef.indexOf(baseObject);
        if (n <= -1) throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "MEASUREDIMENSIONS"});
        if (this.validateDim(cubeDimRef)) {
            this.m_cubeDimRef.add(n, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    protected void addCubeDimRefFirst(CubeDimRef cubeDimRef) {
        if (this.validateDim(cubeDimRef)) {
            this.m_cubeDimRef.add(0, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    public void removeCubeDimRef(CubeDimRef cubeDimRef) {
        this.m_cubeDimRef.remove(cubeDimRef);
    }

    public Vector getCubeDimRef() {
        return this.m_cubeDimRef;
    }

    public String WriteToXML() {
        String string = null;
        string = Measure.TAB() + this.WriteElementStart("Measure");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Measure.TAB() + this.WriteElementEndTag("Measure") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        if (this.m_dataType != null) {
            string = string == null ? this.WriteAsAttribute("DataType", this.m_dataType) : string + this.WriteAsAttribute("DataType", this.m_dataType);
        }
        string = string == null ? this.WriteAsAttribute("isInternal", new Boolean(this.m_isInternal).toString()) : string + this.WriteAsAttribute("isInternal", new Boolean(this.m_isInternal).toString());
        if (this.m_useGlobalIndex != null) {
            string = string == null ? this.WriteAsAttribute("UseGlobalIndex", this.m_useGlobalIndex.toString()) : string + this.WriteAsAttribute("UseGlobalIndex", this.m_useGlobalIndex.toString());
        }
        if (this.m_forceCalc != null) {
            string = string == null ? this.WriteAsAttribute("ForceCalc", this.m_forceCalc.toString()) : string + this.WriteAsAttribute("ForceCalc", this.m_forceCalc.toString());
        }
        if (this.m_forceOrder != null) {
            string = string == null ? this.WriteAsAttribute("ForceOrder", this.m_forceOrder.toString()) : string + this.WriteAsAttribute("ForceOrder", this.m_forceOrder.toString());
        }
        if (this.m_sparseType != null) {
            string = string == null ? this.WriteAsAttribute("SparseType", this.m_sparseType) : string + this.WriteAsAttribute("SparseType", this.m_sparseType);
        }
        if (this.m_autoSolve != null) {
            string = string == null ? this.WriteAsAttribute("AutoSolve", this.m_autoSolve) : string + this.WriteAsAttribute("AutoSolve", this.m_autoSolve);
        }
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        if (this.m_solveDefinition != null) {
            string = string == null ? this.WriteAsIDRef("solveDefinition", this.m_solveDefinition) : string + this.WriteAsIDRef("solveDefinition", this.m_solveDefinition);
        }
        Iterator iterator = this.m_cubeDimRef.iterator();
        while (iterator.hasNext()) {
            CubeDimRef cubeDimRef = (CubeDimRef)iterator.next();
            if (string == null) {
                string = cubeDimRef.WriteToXML();
                continue;
            }
            string = string + cubeDimRef.WriteToXML();
        }
        return string;
    }

    public void setSolveDefinition(SolveDefinition solveDefinition) {
        if (!(solveDefinition instanceof AggregationDefinition)) {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{solveDefinition.getId(), "Aggregation Definition"});
        }
        this.m_solveDefinition = solveDefinition;
    }

    public SolveDefinition getSolveDefinition() {
        return this.m_solveDefinition;
    }

    public String Create(AWConnection aWConnection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string = null;
        if (this.m_cubeDimRef.size() > 0) {
            object5 = this.m_cubeDimRef.iterator();
            while (object5.hasNext()) {
                object4 = (CubeDimRef)object5.next();
                if (((CubeDimRef)object4).getDimension() == null) {
                    throw new AWException("AWXML-ERR-NUM-100005", new Object[]{((BaseObject)object4).getId()});
                }
                if (this.m_owner != null && this.m_owner instanceof Cube) {
                    object3 = (Cube)this.m_owner;
                    boolean bl = false;
                    object2 = ((Cube)object3).getCubeDimRefs().iterator();
                    while (object2.hasNext()) {
                        object = (CubeDimRef)object2.next();
                        if (((CubeDimRef)object).getDimension() != ((CubeDimRef)object4).getDimension()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new AWException("AWXML-ERR-NUM-140003", new Object[]{((CubeDimRef)object4).getDimension().getId()});
                    }
                }
                if (!((CubeDimRef)object4).isSparse().booleanValue()) continue;
                if (string == null) {
                    string = ((CubeDimRef)object4).getDimension().getId();
                    continue;
                }
                string = string + "\\n" + ((CubeDimRef)object4).getDimension().getId();
            }
            string = "'" + string + "'";
        } else {
            string = "'AW$CUBE_DFLT'";
        }
        object5 = this.m_solveDefinition == null ? this.quoteValue("AW$CUBE_DFLT") : this.quoteValue(this.m_solveDefinition.getId());
        object4 = "'AW$CUBE_DFLT'";
        object3 = "'AW$CUBE_DFLT'";
        String string2 = "false";
        if (this.m_sparseType.equalsIgnoreCase("COMPRESSED")) {
            string2 = "true";
        }
        object2 = "AW$CUBE_DFLT";
        if (this.m_autoSolve.equalsIgnoreCase("AUTO_SOLVE")) {
            object2 = "AUTO_SOLVE";
        }
        if (this.m_autoSolve.equalsIgnoreCase("NO_AUTO_SOLVE")) {
            object2 = "NO";
        }
        if (this.m_autoSolve.equalsIgnoreCase("DEFAULT")) {
            object2 = "AW$CUBE_DFLT";
        }
        object = "GLOBAL";
        if (!this.m_useGlobalIndex.booleanValue()) {
            object = "LOCAL";
        }
        String string3 = aWConnection.executeCommand("call create_measure(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + this.quoteValue(this.m_dataType) + "," + string + "," + (String)object4 + "," + (String)object3 + "," + this.quoteValue((String)object) + "," + (String)object5 + "," + this.quoteValue((String)object2) + "," + this.m_forceCalc.toString() + "," + this.m_forceOrder.toString() + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-140000", new Object[]{this.getId(), this.m_commandResultText});
        }
        AW.getCurAW().ValidateDerivedMeasures(aWConnection);
        return "success";
    }

    public String Alter(AWConnection aWConnection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string = null;
        if (this.m_cubeDimRef.size() > 0) {
            object5 = this.m_cubeDimRef.iterator();
            while (object5.hasNext()) {
                object4 = (CubeDimRef)object5.next();
                if (((CubeDimRef)object4).getDimension() == null) {
                    throw new AWException("AWXML-ERR-NUM-100005", new Object[]{((BaseObject)object4).getId()});
                }
                if (this.m_owner != null && this.m_owner instanceof Cube) {
                    object3 = (Cube)this.m_owner;
                    boolean bl = false;
                    object2 = ((Cube)object3).getCubeDimRefs().iterator();
                    while (object2.hasNext()) {
                        object = (CubeDimRef)object2.next();
                        if (((CubeDimRef)object).getDimension() != ((CubeDimRef)object4).getDimension()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new AWException("AWXML-ERR-NUM-140003", new Object[]{((CubeDimRef)object4).getDimension().getId()});
                    }
                }
                if (!((CubeDimRef)object4).isSparse().booleanValue()) continue;
                if (string == null) {
                    string = ((CubeDimRef)object4).getDimension().getId();
                    continue;
                }
                string = string + "\\n" + ((CubeDimRef)object4).getDimension().getId();
            }
            string = "'" + string + "'";
        } else {
            string = "'AW$CUBE_DFLT'";
        }
        object5 = this.m_solveDefinition == null ? this.quoteValue("AW$CUBE_DFLT") : this.quoteValue(this.m_solveDefinition.getId());
        object4 = "'AW$CUBE_DFLT'";
        object3 = "'AW$CUBE_DFLT'";
        String string2 = "false";
        if (this.m_sparseType.equalsIgnoreCase("COMPRESSED")) {
            string2 = "true";
        }
        object2 = "AW$CUBE_DFLT";
        if (this.m_autoSolve.equalsIgnoreCase("AUTO_SOLVE")) {
            object2 = "AUTO_SOLVE";
        }
        if (this.m_autoSolve.equalsIgnoreCase("NO_AUTO_SOLVE")) {
            object2 = "NO";
        }
        if (this.m_autoSolve.equalsIgnoreCase("DEFAULT")) {
            object2 = "AW$CUBE_DFLT";
        }
        object = "GLOBAL";
        if (!this.m_useGlobalIndex.booleanValue()) {
            object = "LOCAL";
        }
        String string3 = aWConnection.executeCommand("call alter_measure(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + AWNULL + "," + AWNULL + "," + AWNULL + "," + AWNULL + "," + AWNULL + "," + (String)object5 + "," + this.quoteValue((String)object2) + "," + this.m_forceCalc.toString() + "," + this.m_forceOrder.toString() + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-140004", new Object[]{this.getId(), this.m_commandResultText});
        }
        AW.getCurAW().ValidateDerivedMeasures(aWConnection);
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = "success";
        string = aWConnection.executeCommand("call delete_measure(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-140001", new Object[]{this.getId(), this.m_commandResultText});
        }
        if (this.m_owner != null) {
            BaseObject baseObject;
            if (AW.getCurAW() != null) {
                object4 = AW.getCurAW();
                object3 = ((AW)object4).getSolveGroups().iterator();
                while (object3.hasNext()) {
                    object2 = (SolveGroup)object3.next();
                    object = ((SolveGroup)object2).getSolves().iterator();
                    while (object.hasNext()) {
                        baseObject = (Solve)object.next();
                        if (baseObject instanceof AggregationSolve) {
                            if (((AggregationSolve)baseObject).getSource() != null && ((AggregationSolve)baseObject).getSource() == this) {
                                ((AggregationSolve)baseObject).setSource(null);
                            }
                            if (((AggregationSolve)baseObject).getTargets().contains(this)) {
                                ((AggregationSolve)baseObject).removeTarget(this);
                            }
                        }
                        if (baseObject instanceof AllocationSolve) {
                            if (((AllocationSolve)baseObject).getSource() == this) {
                                ((AllocationSolve)baseObject).setSource(null);
                            }
                            if (((AllocationSolve)baseObject).getTarget() == this) {
                                ((AllocationSolve)baseObject).setTarget(null);
                            }
                            if (((AllocationSolve)baseObject).getBase() == this) {
                                ((AllocationSolve)baseObject).setBase(null);
                            }
                        }
                        if (!(baseObject instanceof ForecastSolve)) continue;
                        if (((ForecastSolve)baseObject).getSource() == this) {
                            ((ForecastSolve)baseObject).setSource(null);
                        }
                        if (((ForecastSolve)baseObject).getTarget() != this) continue;
                        ((ForecastSolve)baseObject).setTarget(null);
                    }
                }
            }
            object4 = ((Cube)this.m_owner).getSourceMapGroup().iterator();
            while (object4.hasNext()) {
                object3 = (CubeMapGroup)object4.next();
                object2 = null;
                object = ((CubeMapGroup)object3).getMeasureMaps().iterator();
                while (object.hasNext()) {
                    baseObject = (MeasureSourceExpression)object.next();
                    if (((ExternalSourceExpression)baseObject).getTargetObject() == null || ((ExternalSourceExpression)baseObject).getTargetObject() != this) continue;
                    object2 = baseObject;
                    break;
                }
                if (object2 == null) continue;
                ((CubeMapGroup)object3).removeMeasureMap((MeasureSourceExpression)object2);
            }
            ((Cube)this.m_owner).removeMeasure(this);
        }
        if ((object4 = AW.getCurAW()) != null) {
            object3 = ((AW)object4).getMeasureFolders();
            object2 = ((Vector)object3).iterator();
            while (object2.hasNext()) {
                object = (MeasureFolder)object2.next();
                if (((MeasureFolder)object).getMeasures().indexOf(this) < 0) continue;
                ((MeasureFolder)object).getMeasures().remove(this);
            }
        }
        AW.getCurAW().ValidateDerivedMeasures(aWConnection);
        return string;
    }

    public void setUseGlobalIndex(Boolean bl) {
        this.m_useGlobalIndex = bl;
    }

    public Boolean getUseGlobalIndex() {
        return this.m_useGlobalIndex;
    }

    public void setForceCalc(Boolean bl) {
        this.m_forceCalc = bl;
    }

    public Boolean getForceCalc() {
        return this.m_forceCalc;
    }

    public void setForceOrder(Boolean bl) {
        this.m_forceOrder = bl;
    }

    public Boolean getForceOrder() {
        return this.m_forceOrder;
    }

    public CubeDimRef createCubeDimRef() {
        CubeDimRef cubeDimRef = new CubeDimRef(this);
        this.addCubeDimRef(cubeDimRef);
        return cubeDimRef;
    }

    public CubeDimRef createCubeDimRefAfter(BaseObject baseObject) {
        int n;
        CubeDimRef cubeDimRef = null;
        if (baseObject instanceof CubeDimRef) {
            n = this.m_cubeDimRef.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CUBEDIMENSIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{baseObject.getId(), "CUBEDIMREF"});
        }
        cubeDimRef = new CubeDimRef(this);
        this.m_cubeDimRef.add(n + 1, cubeDimRef);
        return cubeDimRef;
    }

    public CubeDimRef createCubeDimRefBefore(BaseObject baseObject) {
        int n;
        CubeDimRef cubeDimRef = null;
        if (baseObject instanceof CubeDimRef) {
            n = this.m_cubeDimRef.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CUBEDIMENSIONS"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{baseObject.getId(), "CUBEDIMREF"});
        }
        cubeDimRef = new CubeDimRef(this);
        this.m_cubeDimRef.add(n, cubeDimRef);
        return cubeDimRef;
    }

    public CubeDimRef createCubeDimRefFirst(CubeDimRef cubeDimRef) {
        CubeDimRef cubeDimRef2 = new CubeDimRef(this);
        this.m_cubeDimRef.add(0, cubeDimRef2);
        return cubeDimRef2;
    }

    protected boolean validateDim(CubeDimRef cubeDimRef) {
        if (cubeDimRef.getDimension() != null) {
            Iterator iterator = this.m_cubeDimRef.iterator();
            while (iterator.hasNext()) {
                CubeDimRef cubeDimRef2 = (CubeDimRef)iterator.next();
                if (cubeDimRef2.getDimension() == null || cubeDimRef2.getDimension() != cubeDimRef.getDimension()) continue;
                throw new AWException("AWXML-ERR-NUM-100006", new Object[]{this.getId(), cubeDimRef.getId()});
            }
        }
        return true;
    }

    protected void setBIBeansDefinition(String string) {
    }

    public boolean isInternal() {
        return this.m_isInternal;
    }

    public void setIsInternal(boolean bl) {
        this.m_isInternal = bl;
    }

    public void setIsInternal(Boolean bl) {
        this.m_isInternal = bl;
    }
}

