/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeySplines;
import org.jdesktop.animation.timing.interpolation.KeyValues;
import org.jdesktop.animation.timing.interpolation.Spline;

public class PropertyRange {
    private String propertyName;
    private KeyFrames keyFrames;

    public PropertyRange(String string, KeyFrames keyFrames) {
        this.propertyName = string;
        this.keyFrames = keyFrames;
    }

    public static PropertyRange createPropertyRangeInt(String string, int ... nArray) {
        KeyValues keyValues = KeyValues.createKeyValues(nArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeInt(String string, Spline spline, int n, int n2) {
        KeyValues keyValues = KeyValues.createKeyValues(n, n2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeFloat(String string, float ... fArray) {
        KeyValues keyValues = KeyValues.createKeyValues(fArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeFloat(String string, Spline spline, float f, float f2) {
        KeyValues keyValues = KeyValues.createKeyValues(f, f2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeDouble(String string, double ... dArray) {
        KeyValues keyValues = KeyValues.createKeyValues(dArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeDouble(String string, Spline spline, double d, double d2) {
        KeyValues keyValues = KeyValues.createKeyValues(d, d2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangePoint(String string, Point ... pointArray) {
        KeyValues keyValues = KeyValues.createKeyValues(pointArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangePoint(String string, Spline spline, Point point, Point point2) {
        KeyValues keyValues = KeyValues.createKeyValues(point, point2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeDimension(String string, Dimension ... dimensionArray) {
        KeyValues keyValues = KeyValues.createKeyValues(dimensionArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeDimension(String string, Spline spline, Dimension dimension, Dimension dimension2) {
        KeyValues keyValues = KeyValues.createKeyValues(dimension, dimension2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeRectangle(String string, Rectangle ... rectangleArray) {
        KeyValues keyValues = KeyValues.createKeyValues(rectangleArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeRectangle(String string, Spline spline, Rectangle rectangle, Rectangle rectangle2) {
        KeyValues keyValues = KeyValues.createKeyValues(rectangle, rectangle2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeColor(String string, Color ... colorArray) {
        KeyValues keyValues = KeyValues.createKeyValues(colorArray);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(string, keyFrames);
    }

    public static PropertyRange createPropertyRangeColor(String string, Spline spline, Color color, Color color2) {
        KeyValues keyValues = KeyValues.createKeyValues(color, color2);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(spline));
        return new PropertyRange(string, keyFrames);
    }

    String getPropertyName() {
        return this.propertyName;
    }

    void setStartValue(Object object) {
        this.keyFrames.getKeyValues().setStartValue(object);
    }

    void setValue(Object object, Method method, float f) {
        this.keyFrames.setValue(object, method, f);
    }

    Class getType() {
        return this.keyFrames.getType();
    }

    public boolean isToAnimation() {
        return this.keyFrames.getKeyValues().isToAnimation();
    }
}

