/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.DatabaseElementTransferable;
import oracle.dbtools.raptor.controls.FocusCorrector;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.db.DefaultCreateActionProvider;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.schemabrowser.SchemaBrowserResources;
import oracle.dbtools.raptor.schemabrowser.model.ObjectsTask;
import oracle.dbtools.raptor.schemabrowser.model.SBComboBoxModel;
import oracle.dbtools.raptor.schemabrowser.model.SBListModel;
import oracle.dbtools.raptor.schemabrowser.model.SBModel;
import oracle.dbtools.raptor.schemabrowser.model.SBSchema;
import oracle.dbtools.raptor.schemabrowser.model.SBSearchCategory;
import oracle.dbtools.raptor.schemabrowser.model.SBType;
import oracle.dbtools.raptor.schemabrowser.model.SearchableListModel;
import oracle.dbtools.raptor.schemabrowser.model.Task;
import oracle.dbtools.raptor.schemabrowser.model.TypesTask;
import oracle.dbtools.raptor.schemabrowser.view.ObjectRenderer;
import oracle.dbtools.raptor.schemabrowser.view.PanelState;
import oracle.dbtools.raptor.schemabrowser.view.SBViewController;
import oracle.dbtools.raptor.schemabrowser.view.SBWindow;
import oracle.dbtools.raptor.schemabrowser.view.SchemaFilterPanel;
import oracle.dbtools.raptor.schemabrowser.view.TaskHandler;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.Namespace;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.util.ModelUtil;

public class SBGui
extends JPanel
implements ListSelectionListener,
ItemListener,
MouseListener,
ActionListener {
    private static final String SCHEMAS_KEY = "Schemas";
    private static final String TYPES_KEY = "Types";
    private static final String LOADING_STATE = "LOADING";
    private static final String OPEN_STATE = "OBJECTS";
    private static final String CLOSED_STATE = "CLOSED";
    private SBModel m_model;
    private SearchableListModel<DatabaseNode> m_objectsModel = new SearchableListModel();
    private JList m_objects = new JList<DatabaseNode>(this.m_objectsModel);
    private SBComboBoxModel<SBSchema> m_schemaModel = new SBComboBoxModel();
    private JComboBox m_schemaPicker = new JComboBox<SBSchema>(this.m_schemaModel);
    private DropDownMenuButton m_schemaBtn;
    private SearchField m_search = new SearchField();
    private SBComboBoxModel<SBType> m_typeModel = new SBComboBoxModel();
    private JComboBox m_typePicker = new JComboBox<SBType>(this.m_typeModel);
    private DropDownMenuButton m_typeBtn;
    private CardLayout m_contentLayout = new CardLayout();
    private JPanel m_content = new JPanel(this.m_contentLayout);
    private JPanel m_loadingPanel = new JPanel();
    private SBWindow m_view;
    private PanelState m_state = PanelState.CLOSED;
    private WeakReference<Database> m_db;
    private MnemonicSolver m_solver = new MnemonicSolver();
    private IObjectActionListener m_actionListener = new IObjectActionListener(){

        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            String string2 = dBObject.getSchemaName();
            SBSchema sBSchema = SBGui.this.getSelectedSchema();
            SBType sBType = SBGui.this.getSelectedType();
            boolean bl = ModelUtil.areEqual((Object)sBSchema.getShortLabel(), (Object)string2);
            SBSchema sBSchema2 = SBGui.this.m_model.getSchema(string2);
            if (sBSchema2 != null) {
                String string3 = dBObject.getObjectFolderType();
                String string4 = dBObject.getObjectName();
                if (bl && ModelUtil.areEqual((Object)sBType.getTypeName(), (Object)string3)) {
                    sBType.removeObject(string4);
                } else {
                    SBType sBType2 = sBSchema2.getTypeByName(string3, false);
                    if (sBType2 != null) {
                        sBType2.markForRefresh();
                    }
                }
            }
        }

        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            String string2 = dBObject.getSchemaName();
            String string3 = dBObject.getObjectFolderType();
            SBGui.this.refresh(string2, string3);
        }

        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }
    };
    private transient DBObjectProviderListener m_provListener = new DBObjectProviderListener(){

        public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            String string = schema.getName();
            SBSchema sBSchema = SBGui.this.getSelectedSchema();
            SBType sBType = SBGui.this.getSelectedType();
            boolean bl = ModelUtil.areEqual((Object)sBSchema.getShortLabel(), (Object)string);
            SBSchema sBSchema2 = SBGui.this.m_model.getSchema(string);
            if (sBSchema2 != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (SchemaObject schemaObject : collection) {
                    String string2 = schemaObject.getType();
                    String string3 = schemaObject.getName();
                    if (bl && ModelUtil.areEqual((Object)sBType.getTypeName(), (Object)string2)) {
                        arrayList.add(string3);
                        continue;
                    }
                    SBType sBType2 = sBSchema2.getTypeByName(string2, false);
                    if (sBType2 == null) continue;
                    sBType2.markForRefresh();
                }
                if (arrayList.size() > 0) {
                    SBGui.this.loadObjects(sBType, arrayList.toArray(new String[0]));
                }
            }
        }
    };

    public SBGui(SBWindow sBWindow) {
        super(new BorderLayout());
        this.createGUI(sBWindow);
        this.setPanelState(PanelState.CLOSED);
        Connections.getInstance().addConnectionDisconnectListener(new ConnectionDisconnectListener(){

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
                String string = connectionDetails.getQualifiedConnectionName();
                if (ModelUtil.areEqual((Object)string, (Object)SBGui.this.m_model.getConnectionName())) {
                    SBGui.this.setPanelState(PanelState.CLOSED);
                }
            }

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
            }
        });
        Connections.getInstance().addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void connectionOpened(ConnectionEvent connectionEvent) {
                if (ModelUtil.areEqual((Object)connectionEvent.getConnectionName(), (Object)SBGui.this.m_view.getConnectionName())) {
                    SBGui.this.init(connectionEvent.getConnectionName(), SBGui.this.m_model.getCatalog());
                }
            }
        });
        ObjectActionController.addListener((IObjectActionListener)this.m_actionListener);
    }

    private void createGUI(SBWindow sBWindow) {
        this.m_view = sBWindow;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_schemaPicker.setActionCommand(SCHEMAS_KEY);
        this.m_schemaPicker.addActionListener(this);
        this.m_schemaPicker.setRenderer(new ObjectRenderer());
        this.m_schemaPicker.setName(SchemaBrowserResources.getString("SCHEMA_LIST_NAME"));
        this.m_schemaBtn = this.createSchemaMenuButton();
        this.m_typePicker.setActionCommand(TYPES_KEY);
        this.m_typePicker.addActionListener(this);
        this.m_typePicker.setRenderer(new ObjectRenderer());
        this.m_typePicker.setName(SchemaBrowserResources.getString("TYPE_LIST_NAME"));
        this.m_typeBtn = this.createTypeMenuButton();
        this.m_objects.setCellRenderer(new ObjectRenderer());
        this.m_objects.addListSelectionListener(this);
        FocusCorrector.attachFocusCorrector((Component)this.m_objects);
        this.m_objects.addMouseListener(this);
        this.m_objects.setDragEnabled(true);
        this.m_objects.setTransferHandler(new ListTransferHandler());
        this.m_search.addSearchListener(this.m_objectsModel);
        for (SBSearchCategory sBSearchCategory : SBSearchCategory.getCategories()) {
            this.m_search.addCategory((SearchCategory)sBSearchCategory);
        }
        this.m_schemaPicker.setName("schemaPicker");
        this.m_typePicker.setName("typePicker");
        this.m_schemaBtn.setName("schemaBtn");
        this.m_typeBtn.setName("typeBtn");
        this.m_search.setName("search");
        this.m_objects.setName("objects");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.m_schemaPicker, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.m_schemaBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.m_typePicker, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.m_typeBtn, gridBagConstraints);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton((Action)IdeAction.get((int)SBViewController.REOPEN_ID));
        jPanel2.add(jButton);
        this.m_content.add((Component)jPanel2, CLOSED_STATE);
        this.m_content.add((Component)new JScrollPane(this.m_objects), OPEN_STATE);
        this.m_loadingPanel.add(new JLabel(SchemaBrowserResources.getString("MESSAGE_LOADING")));
        this.m_content.add((Component)this.m_loadingPanel, LOADING_STATE);
        this.add((Component)this.m_content, "Center");
        this.add((Component)this.m_search, "South");
    }

    Element[] getSelection() {
        Object[] objectArray = this.m_objects.getSelectedValues();
        Element[] elementArray = new Element[objectArray.length];
        for (int i = objectArray.length - 1; i >= 0; --i) {
            elementArray[i] = (Element)objectArray[i];
        }
        return elementArray;
    }

    SBSchema getSelectedSchema() {
        return (SBSchema)this.m_schemaPicker.getSelectedItem();
    }

    SBType getSelectedType() {
        return (SBType)this.m_typePicker.getSelectedItem();
    }

    String getConnectionName() {
        return this.m_model != null ? this.m_model.getConnectionName() : null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1) {
            if (this.m_model != null) {
                Object object = itemEvent.getSource();
                if (object == this.m_schemaPicker) {
                    SBSchema sBSchema = (SBSchema)itemEvent.getItem();
                    this.loadTypes(sBSchema);
                } else if (object == this.m_typePicker) {
                    SBType sBType = (SBType)itemEvent.getItem();
                    if (sBType != null) {
                        this.loadObjects(sBType, null);
                    }
                } else if (object == this.m_schemaBtn) {
                    this.updateSchemaButtonMenu();
                } else if (object == this.m_typeBtn) {
                    this.updateTypeButtonMenu();
                }
                this.updateActions();
            }
        } else if (n == 2) {
            Object object = itemEvent.getSource();
            if (object == this.m_typeBtn) {
                SBGui.clearButtonMenu(this.m_typeBtn);
            } else if (object == this.m_schemaBtn) {
                SBGui.clearButtonMenu(this.m_schemaBtn);
            }
        }
    }

    private void updateActions() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SBType sBType;
        String string = actionEvent.getActionCommand();
        if (SCHEMAS_KEY.equals(string)) {
            SBSchema sBSchema = (SBSchema)this.m_schemaModel.getSelectedItem();
            this.loadTypes(sBSchema);
        } else if (TYPES_KEY.equals(string) && (sBType = (SBType)this.m_typeModel.getSelectedItem()) != null) {
            this.loadObjects(sBType, null);
        }
        this.updateActions();
    }

    private void loadTypes(final SBSchema sBSchema) {
        final SBType sBType = (SBType)this.m_typePicker.getSelectedItem();
        TypesTask typesTask = new TypesTask(sBSchema, this.m_model.getConnectionName());
        this.setPanelState(PanelState.LOADING);
        this.m_typeModel.clear();
        typesTask.getDescriptor().addListener((IRaptorTaskListener)new TaskHandler<SBType>(this, this.m_typeModel, (Task)typesTask){

            @Override
            protected void postProcess(RaptorTaskEvent raptorTaskEvent, SBListModel<SBType> sBListModel) {
                SBType sBType2 = sBType != null ? sBSchema.getTypeByName(sBType.getTypeName(), false) : (sBListModel.getSize() > 0 ? (SBType)sBListModel.getElementAt(0) : null);
                SBGui.this.m_typePicker.setSelectedItem(sBType2);
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)typesTask);
    }

    private void loadObjects(SBType sBType, String[] stringArray) {
        ObjectsTask objectsTask = new ObjectsTask(sBType, this.m_model.getConnectionName(), stringArray);
        this.setPanelState(PanelState.LOADING);
        objectsTask.getDescriptor().addListener((IRaptorTaskListener)new TaskHandler<DatabaseNode>(this, this.m_objectsModel, (Task)objectsTask){

            @Override
            protected void preProcess(RaptorTaskEvent raptorTaskEvent, SBListModel<DatabaseNode> sBListModel) {
                sBListModel.clear();
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)objectsTask);
    }

    void setPanelState(final PanelState panelState) {
        Object object;
        this.m_state = panelState;
        if (panelState == PanelState.CLOSED && (object = this.getDatabase()) != null) {
            object.removeProviderListener(this.m_provListener);
            this.setDatabase(null);
        }
        object = new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                String string = SBGui.CLOSED_STATE;
                switch (panelState) {
                    case LOADING: {
                        string = SBGui.LOADING_STATE;
                        break;
                    }
                    case OPEN: {
                        bl = true;
                        string = SBGui.OPEN_STATE;
                    }
                }
                SBGui.this.m_contentLayout.show(SBGui.this.m_content, string);
                SBGui.this.m_schemaPicker.setEnabled(bl);
                SBGui.this.m_typePicker.setEnabled(bl);
                SBGui.this.m_search.setEnabled(bl);
                SBGui.this.m_schemaBtn.setEnabled(bl);
                SBGui.this.m_typeBtn.setEnabled(bl);
                SBGui.this.updateActions();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            object.run();
        } else {
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    PanelState getPanelState() {
        return this.m_state;
    }

    void setContext(Context context) {
        if (context != null) {
            String string = (String)context.getProperty("SchemaBrowser.Connection");
            String string2 = (String)context.getProperty("SchemaBrowser.CATALOG");
            this.init(string, string2);
        }
    }

    private Database getDatabase() {
        if (this.m_db != null) {
            Database database = (Database)this.m_db.get();
            if (database == null) {
                this.m_db = null;
            }
            return database;
        }
        return null;
    }

    private void setDatabase(Database database) {
        this.m_db = new WeakReference<Database>(database);
    }

    private void init(final String string, final String string2) {
        Object object;
        Object object2;
        try {
            object2 = Connections.getInstance().getDatabase(string, false);
            object = this.getDatabase();
            if (object != object2) {
                if (object != null) {
                    object.removeProviderListener(this.m_provListener);
                }
                if (object2 != null) {
                    object2.addProviderListener(this.m_provListener);
                    this.setDatabase((Database)object2);
                }
            }
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Exception)((Object)dBException), (String)string);
        }
        object2 = new DatabaseQueryTask<SBModel>("SB Init", IRaptorTaskRunMode.MODAL, false, true){

            protected SBModel doWork() throws TaskException {
                return new SBModel(string, string2);
            }

            public String getConnectionName() {
                return string;
            }

            public String getQuery() {
                return null;
            }
        };
        object = new DatabaseQueryTask<Collection<SBSchema>>("Schema Load", IRaptorTaskRunMode.MODAL, false, true){

            protected Collection<SBSchema> doWork() throws TaskException {
                return SBGui.this.m_model.getSchemas();
            }

            public String getConnectionName() {
                return string;
            }

            public String getQuery() {
                return null;
            }
        };
        object2.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((DatabaseQueryTask)object2, (DatabaseQueryTask)object){
            final /* synthetic */ DatabaseQueryTask val$initTask;
            final /* synthetic */ DatabaseQueryTask val$schemaTask;
            {
                this.val$initTask = databaseQueryTask;
                this.val$schemaTask = databaseQueryTask2;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    SBGui.this.m_model = (SBModel)this.val$initTask.getResult();
                    RaptorTaskManager.getInstance().addTask((RaptorTask)this.val$schemaTask);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        });
        object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((DatabaseQueryTask)object){
            final /* synthetic */ DatabaseQueryTask val$schemaTask;
            {
                this.val$schemaTask = databaseQueryTask;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final Collection collection = (Collection)this.val$schemaTask.getResult();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SBGui.this.m_schemaModel.clear();
                            SBGui.this.m_schemaModel.addElements(collection);
                            SBGui.this.m_schemaModel.setSelectedItem(SBGui.this.m_model.getDefaultSchema());
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)object2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_view != null) {
            this.m_view.scheduleUpdateSelection();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    private void tryPopup(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point;
        int n;
        if (mouseEvent != null && mouseEvent.isPopupTrigger() && (n = this.m_objects.locationToIndex(point = mouseEvent.getPoint())) != -1 && (rectangle = this.m_objects.getCellBounds(n, n)).contains(point)) {
            Context context;
            if (!this.m_objects.isSelectedIndex(n)) {
                this.m_objects.setSelectedIndex(n);
            }
            if ((context = this.m_view.getContext(mouseEvent)).getElement() != null) {
                ContextMenu contextMenu = this.m_view.getContextMenu();
                contextMenu.show(context);
            }
        }
    }

    Component getSelectableComponent() {
        return this.m_objects;
    }

    void refresh() {
        SBType sBType = this.getSelectedType();
        if (sBType != null) {
            sBType.markForRefresh();
            this.loadObjects(sBType, null);
        }
    }

    void refresh(String string, String string2) {
        SBType sBType;
        SBSchema sBSchema;
        if (this.m_model != null && (sBSchema = this.m_model.getSchema(string)) != null && (sBType = sBSchema.getTypeByName(string2, false)) != null) {
            sBType.markForRefresh();
            if (sBSchema == this.getSelectedSchema() && sBType == this.getSelectedType()) {
                this.loadObjects(sBType, null);
            }
        }
    }

    private DropDownMenuButton createSchemaMenuButton() {
        DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
        dropDownMenuButton.addItemListener((ItemListener)this);
        dropDownMenuButton.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
        return dropDownMenuButton;
    }

    private DropDownMenuButton createTypeMenuButton() {
        DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
        dropDownMenuButton.addItemListener((ItemListener)this);
        dropDownMenuButton.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
        return dropDownMenuButton;
    }

    private void updateTypeButtonMenu() {
        ContextMenu contextMenu = new ContextMenu();
        this.m_solver.clear();
        XMLBasedObjectAction xMLBasedObjectAction = XMLBasedObjectAction.getInstance();
        SBType sBType = this.getSelectedType();
        DBObject dBObject = new DBObject(sBType.getURL());
        Context context = Context.newIdeContext((View)this.m_view);
        context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
        JPopupMenu jPopupMenu = this.m_typeBtn.getPopupMenu();
        IdeAction ideAction = DefaultCreateActionProvider.getDefaultNewAction((DBObject)dBObject);
        if (ideAction != null) {
            jPopupMenu.add(SBGui.createMenuItem((MenuManager)contextMenu, ideAction, 1.0f));
        }
        ideAction = IdeAction.find((int)51);
        ideAction.setEnabled(true);
        this.addToPopup(jPopupMenu, SBGui.createMenuItem((MenuManager)contextMenu, ideAction, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT), true);
        ideAction = IdeAction.find((int)SBViewController.SCHEMA_BROWSER_FILTER_OBJECT_ID);
        SBViewController.updateFilterAction(ideAction, dBObject, sBType);
        this.addToPopup(jPopupMenu, SBGui.createMenuItem((MenuManager)contextMenu, ideAction, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT), true);
        ideAction = IdeAction.find((int)SBViewController.SCHEMA_BROWSER_CLEAR_OBJECT_ID);
        SBViewController.updateClearFilterAction(ideAction, sBType);
        this.addToPopup(jPopupMenu, SBGui.createMenuItem((MenuManager)contextMenu, ideAction, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT), true);
        JPopupMenu jPopupMenu2 = xMLBasedObjectAction.getMenu(dBObject);
        for (Component component : jPopupMenu2.getComponents()) {
            if (!(component instanceof JMenuItem)) continue;
            this.addToPopup(jPopupMenu, (JMenuItem)component, false);
        }
        this.m_solver.solve();
        contextMenu.sortContainer((Container)jPopupMenu);
        jPopupMenu.putClientProperty("ContextMenuContext", context);
    }

    private void addToPopup(JPopupMenu jPopupMenu, JMenuItem jMenuItem, boolean bl) {
        jPopupMenu.add(jMenuItem);
        this.m_solver.addMenuLabel(jMenuItem, bl);
    }

    private void updateSchemaButtonMenu() {
        ContextMenu contextMenu = new ContextMenu();
        Context context = Context.newIdeContext((View)this.m_view);
        JPopupMenu jPopupMenu = this.m_schemaBtn.getPopupMenu();
        IdeAction ideAction = IdeAction.find((int)SBViewController.SCHEMA_FILTER_ID);
        ideAction.setEnabled(true);
        jPopupMenu.add(SBGui.createMenuItem((MenuManager)contextMenu, ideAction, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
        ideAction = IdeAction.find((int)SBViewController.CLEAR_SCHEMA_FILTER_ID);
        ideAction.setEnabled(this.m_model.isSchemaListFiltered());
        jPopupMenu.add(SBGui.createMenuItem((MenuManager)contextMenu, ideAction, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
        contextMenu.sortContainer((Container)jPopupMenu);
        jPopupMenu.putClientProperty("ContextMenuContext", context);
    }

    private static JMenuItem createMenuItem(MenuManager menuManager, IdeAction ideAction, float f) {
        JMenuItem jMenuItem = menuManager.createMenuItem((ToggleAction)ideAction);
        jMenuItem.putClientProperty("menu-section-id", Float.valueOf(f));
        return jMenuItem;
    }

    private static void clearButtonMenu(final DropDownMenuButton dropDownMenuButton) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dropDownMenuButton.removeAllPopupItems();
            }
        });
    }

    void promptForSchemaFilter() {
        SBSearchCategory sBSearchCategory = this.m_model.getSchemaFilterType();
        String string = this.m_model.getSchemaFilterValue();
        Namespace namespace = new Namespace();
        namespace.put("SchemaFilterPanel.CATEGORY", (Object)sBSearchCategory);
        namespace.put("SchemaFilterPanel.VALUE", (Object)string);
        SchemaFilterPanel schemaFilterPanel = new SchemaFilterPanel();
        schemaFilterPanel.setHelpID("f1_navfilters_html");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), StringUtils.stripMnemonic((String)SchemaBrowserResources.getString("SCHEMA_FILTER_LABEL")), (Traversable)schemaFilterPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(schemaFilterPanel.getInitialFocusComponent());
        if (tDialogLauncher.showDialog()) {
            sBSearchCategory = (SBSearchCategory)((Object)namespace.find("SchemaFilterPanel.CATEGORY"));
            string = (String)namespace.find("SchemaFilterPanel.VALUE");
            this.setSchemaFilter(sBSearchCategory, string);
        }
        tDialogLauncher.dispose();
    }

    void clearSchemaFilter() {
        this.setSchemaFilter(null, null);
    }

    void setSchemaFilter(SBSearchCategory sBSearchCategory, String string) {
        this.m_model.setSchemaFilterType(sBSearchCategory);
        this.m_model.setSchemaFilterValue(string);
        SBSchema sBSchema = (SBSchema)this.m_schemaModel.getSelectedItem();
        try {
            Collection<SBSchema> collection = this.m_model.getSchemas();
            this.m_schemaModel.clear();
            this.m_schemaModel.addElements(collection);
            if (!collection.contains(sBSchema)) {
                sBSchema = collection.size() > 0 ? (SBSchema)this.m_schemaModel.getElementAt(0) : null;
            }
            this.m_schemaModel.setSelectedItem(sBSchema);
        }
        catch (TaskException taskException) {
            // empty catch block
        }
    }

    private class ListTransferHandler
    extends TransferHandler {
        private ListTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            Transferable transferable = null;
            Element[] elementArray = SBGui.this.getSelection();
            if (elementArray != null) {
                ArrayList<DatabaseElementTransferable> arrayList = new ArrayList<DatabaseElementTransferable>();
                for (Element element : elementArray) {
                    if (!(element instanceof DatabaseElement)) continue;
                    DatabaseElementTransferable databaseElementTransferable = new DatabaseElementTransferable((DatabaseElement)element);
                    arrayList.add(databaseElementTransferable);
                }
                if (arrayList.size() == 1) {
                    transferable = (Transferable)arrayList.get(0);
                } else if (arrayList.size() > 0) {
                    transferable = new TransferablesList(arrayList);
                }
            }
            return transferable;
        }
    }
}

