/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.wizard.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;
import javax.ide.wizard.spi.WizardCategory;
import javax.ide.wizard.spi.WizardInfo;

public final class WizardHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-hook");
    private static final ElementName WIZARDS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizards");
    private static final ElementName WIZARD = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard");
    private static final ElementName WIZARD_CATEGORY = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-category");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final String KEY_WIZARD_INFO = "wizardInfo";
    private static final String KEY_CATEGORY = "wizardCategory";
    private ElementVisitor _wizardsVisitor = new WizardsVisitor();
    private ElementVisitor _wizardVisitor = new WizardVisitor();
    private ElementVisitor _labelVisitor = new LabelVisitor();
    private ElementVisitor _iconpathVisitor = new IconPathVisitor();
    private ElementVisitor _tooltipVisitor = new ToolTipVisitor();
    private ElementVisitor _wizardCategoryVisitor = new WizardCategoryVisitor();
    private final Map _wizardsByClass = new HashMap();
    private final Map _categoriesById = new HashMap();
    private final Map _categoryChildren = new HashMap();

    public WizardInfo getWizardInfo(String className) {
        WizardInfo info = (WizardInfo)this._wizardsByClass.get(className);
        if (info == null) {
            throw new IllegalArgumentException("Unknown wizard class " + className);
        }
        return info;
    }

    public Collection getChildren(WizardCategory category) {
        if (category == null) {
            throw new NullPointerException("Null category");
        }
        return Collections.unmodifiableCollection(this.getCategoryChildren(category));
    }

    private Collection getCategoryChildren(WizardCategory parent) {
        ArrayList children = (ArrayList)this._categoryChildren.get(parent);
        if (children == null) {
            children = new ArrayList();
            this._categoryChildren.put(parent, children);
        }
        return children;
    }

    public Collection getAllWizardClasses() {
        return Collections.unmodifiableCollection(this._wizardsByClass.keySet());
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(WIZARDS, this._wizardsVisitor);
    }

    private static WizardInfo getWizardInfo(ElementContext context) {
        return (WizardInfo)context.getScopeData().get(KEY_WIZARD_INFO);
    }

    private class WizardsVisitor
    extends ElementVisitor {
        private WizardsVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(WIZARD, WizardHook.this._wizardVisitor);
            context.registerChildVisitor(WIZARD_CATEGORY, WizardHook.this._wizardCategoryVisitor);
        }
    }

    private class WizardVisitor
    extends ElementVisitor {
        private WizardVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("wizard-class");
            if (className == null || (className = className.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'wizard-class' attribute.");
                return;
            }
            String parentId = context.getAttributeValue("category-ref");
            WizardCategory parent = WizardCategory.NONE;
            if (parentId != null && (parentId = parentId.trim()).length() > 0 && (parent = (WizardCategory)WizardHook.this._categoriesById.get(parentId)) == null) {
                this.log(context, Level.WARNING, "Unknown category id '" + parentId + "'.");
                parent = WizardCategory.NONE;
            }
            MetaClass clazz = new MetaClass((ClassLoader)context.getScopeData().get("classLoader"), className);
            WizardInfo info = new WizardInfo(clazz);
            WizardHook.this.getCategoryChildren(parent).add(info);
            info.setCategory(parent);
            context.getScopeData().put(WizardHook.KEY_WIZARD_INFO, info);
            context.registerChildVisitor(LABEL, WizardHook.this._labelVisitor);
            context.registerChildVisitor(ICONPATH, WizardHook.this._iconpathVisitor);
            context.registerChildVisitor(TOOLTIP, WizardHook.this._tooltipVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            WizardInfo wi = WizardHook.getWizardInfo(context);
            WizardHook.this._wizardsByClass.put(wi.getWizardClass().getClassName(), wi);
        }
    }

    private class LabelVisitor
    extends I18NStringVisitor {
        private LabelVisitor() {
        }

        @Override
        protected void string(ElementContext context, String value) {
            WizardHook.getWizardInfo(context).setLabel(value);
        }
    }

    private class IconPathVisitor
    extends IconVisitor {
        private IconPathVisitor() {
        }

        @Override
        protected void icon(ElementContext context, IconDescription icon) {
            WizardHook.getWizardInfo(context).setIcon(icon);
        }
    }

    private class ToolTipVisitor
    extends I18NStringVisitor {
        private ToolTipVisitor() {
        }

        @Override
        protected void string(ElementContext context, String value) {
            WizardHook.getWizardInfo(context).setToolTip(value);
        }
    }

    private class WizardCategoryVisitor
    extends ElementVisitor {
        private WizardCategoryVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'id' attribute.");
                return;
            }
            WizardCategory parent = WizardCategory.NONE;
            String parentCategory = context.getAttributeValue("parent-category");
            if (parentCategory != null && (parent = (WizardCategory)WizardHook.this._categoriesById.get(parentCategory = parentCategory.trim())) == null) {
                this.log(context, Level.WARNING, "Wizard category '" + parentCategory + "' not found.");
                parent = WizardCategory.NONE;
            }
            WizardCategory cat = new WizardCategory(parent, id);
            context.getScopeData().put(WizardHook.KEY_CATEGORY, cat);
            WizardHook.this._categoriesById.put(id, cat);
            WizardHook.this.getCategoryChildren(parent).add(cat);
            context.registerChildVisitor(LABEL, new I18NStringVisitor(){

                @Override
                protected void string(ElementContext context, String string) {
                    WizardCategory c = (WizardCategory)context.getScopeData().get(WizardHook.KEY_CATEGORY);
                    c.setLabel(string);
                }
            });
        }

        @Override
        public void end(ElementEndContext context) {
            WizardCategory c = (WizardCategory)context.getScopeData().get(WizardHook.KEY_CATEGORY);
            if (c.getLabel() == null) {
                this.log(context, Level.WARNING, "Missing label element for category.");
                c.setLabel(c.getId());
            }
        }
    }
}

