/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.SectionVisitor;

public class ContextMenuHookHelper
extends ElementVisitor {
    public static final String KEY_SECTION_CONTAINER = "sectionContainer";
    public static final String KEY_MENU_MODEL = "menuModel";
    private MenuModel _menuModel;
    private String _site;
    private String _popupId;
    private static int _uniqueId = 0;

    public ContextMenuHookHelper() {
    }

    public ContextMenuHookHelper(String site, MenuModel model) {
        this._site = site;
        this._menuModel = model;
    }

    public void setSite(String site) {
        this._site = site;
        this._popupId = null;
    }

    public String getPopupId() {
        return this._popupId;
    }

    public MenuModel getMenuModel() {
        return this._menuModel;
    }

    private MenuModel getMenuModel(ElementContext context) {
        if (this._menuModel == null) {
            this._menuModel = (MenuModel)context.getScopeData().get(KEY_MENU_MODEL);
            if (this._menuModel == null) {
                this._menuModel = new MenuModel();
            }
        }
        return this._menuModel;
    }

    private synchronized String createUniquePopupId() {
        this._popupId = this._site + "_" + ++_uniqueId;
        return this._popupId;
    }

    @Override
    public void start(ElementStartContext context) {
        if (this._site != null) {
            MenuModel model = this.getMenuModel(context);
            context.getScopeData().put(KEY_MENU_MODEL, model);
            PopupMenu popup = model.findOrCreatePopupMenu(this.createUniquePopupId());
            context.getScopeData().put(KEY_SECTION_CONTAINER, popup);
            context.registerChildVisitor(SectionVisitor.SECTION, new SectionVisitor());
        }
    }
}

