/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.parser;

import java.util.ArrayList;
import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTagLexer;
import oracle.bali.xml.editor.parser.AttributeNode;
import oracle.bali.xml.editor.parser.DocumentNode;
import oracle.bali.xml.editor.parser.NamespaceDeclaration;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;

public class DocumentPathGenerator {
    public static ArrayList generateDocumentPath(ReadTextBuffer buffer, int caretPosition) {
        ArrayList<DocumentNode> documentPath = new ArrayList<DocumentNode>();
        if (buffer != null) {
            XMLLexer lexer = new XMLLexer();
            XMLTagLexer tagLexer = new XMLTagLexer();
            lexer.setTextBuffer(buffer);
            tagLexer.setTextBuffer(buffer);
            LexerToken currentToken = lexer.createLexerToken();
            lexer.lex(currentToken);
            while (currentToken.getToken() != 0) {
                DocumentNode anInfo;
                if (currentToken.getStartOffset() >= caretPosition) {
                    DocumentNode lastInfo;
                    if (documentPath.size() > 0 && (lastInfo = (DocumentNode)documentPath.get(documentPath.size() - 1)).getEndOffset() >= caretPosition) break;
                    documentPath.add(DocumentNode.UNKNOWN);
                    break;
                }
                if ((currentToken.getToken() == 11 || currentToken.getToken() == 12) && (anInfo = DocumentPathGenerator.getElementNode(currentToken, tagLexer, caretPosition)) != null) {
                    if (anInfo.getTagType() == 11) {
                        documentPath.add(anInfo);
                    } else if (anInfo.getTagType() == 13) {
                        if (caretPosition >= currentToken.getStartOffset() && caretPosition < currentToken.getEndOffset()) {
                            documentPath.add(anInfo);
                        }
                    } else if (anInfo.getTagType() == 12) {
                        DocumentNode lastPath;
                        String lastElement;
                        if (caretPosition >= currentToken.getStartOffset() && caretPosition <= currentToken.getEndOffset()) {
                            if (caretPosition == currentToken.getEndOffset()) {
                                if (currentToken.getToken() == 12) {
                                    documentPath.add(anInfo);
                                }
                            } else {
                                documentPath.add(anInfo);
                            }
                        } else if (documentPath.size() > 0 && (lastElement = (lastPath = (DocumentNode)documentPath.get(documentPath.size() - 1)).getElementName()) != null && lastElement.equals(anInfo.getElementName())) {
                            documentPath.remove(documentPath.size() - 1);
                        }
                    }
                }
                lexer.lex(currentToken);
            }
        }
        return documentPath;
    }

    public static DocumentNode getElementNode(LexerToken elementToken, XMLTagLexer tagLexer, int caretOffset) {
        DocumentNode returnInfo = null;
        int startOffset = elementToken.getStartOffset();
        int endOffset = elementToken.getEndOffset();
        tagLexer.setPosition(startOffset);
        LexerToken tagToken = tagLexer.createLexerToken();
        tagLexer.lex(tagToken);
        String elementName = null;
        String namespacePrefix = null;
        String currentAttNamespacePrefix = null;
        String currentAttName = null;
        ArrayList<NamespaceDeclaration> namespaceDecls = new ArrayList<NamespaceDeclaration>();
        ArrayList<AttributeNode> attributes = new ArrayList<AttributeNode>();
        AttributeNode currentAttribute = null;
        boolean isStartTag = true;
        boolean isEndTag = false;
        boolean isEmpty = false;
        while (tagToken.getEndOffset() <= endOffset && tagToken.getToken() != 0) {
            String symbolValue;
            if (tagToken.getToken() == 21) {
                elementName = DocumentPathGenerator._getStringValue(tagLexer.getTextBuffer(), tagToken);
                int colonLoc = elementName.indexOf(":");
                if (colonLoc != -1) {
                    namespacePrefix = elementName.substring(0, colonLoc);
                    if ((elementName = elementName.substring(colonLoc + 1)).length() == 0) {
                        elementName = null;
                    }
                } else {
                    namespacePrefix = null;
                }
            } else if (tagToken.getToken() == 22) {
                currentAttName = DocumentPathGenerator._getStringValue(tagLexer.getTextBuffer(), tagToken);
                int colonLoc = currentAttName.indexOf(":");
                if (colonLoc != -1) {
                    currentAttNamespacePrefix = currentAttName.substring(0, colonLoc);
                    if ((currentAttName = currentAttName.substring(colonLoc + 1)).length() == 0) {
                        currentAttName = null;
                    }
                } else {
                    currentAttNamespacePrefix = null;
                }
                currentAttribute = new AttributeNode(currentAttNamespacePrefix, currentAttName, tagToken.getStartOffset(), tagToken.getEndOffset());
                attributes.add(currentAttribute);
            } else if (tagToken.getToken() == 23) {
                String attValue = DocumentPathGenerator._getStringValue(tagLexer.getTextBuffer(), tagToken);
                if (attValue.length() > 0) {
                    int attValueBegin = 0;
                    int attValueEnd = attValue.length();
                    char testChar = attValue.charAt(0);
                    if (testChar == '\'' || testChar == '\"') {
                        attValueBegin = 1;
                    }
                    if (attValueEnd > 1 && ((testChar = attValue.charAt(attValueEnd - 1)) == '\'' || testChar == '\"')) {
                        --attValueEnd;
                    }
                    attValue = attValue.substring(attValueBegin, attValueEnd);
                }
                if (currentAttribute != null && currentAttribute.isIncomplete()) {
                    currentAttribute.setValue(attValue, tagToken.getStartOffset(), tagToken.getEndOffset());
                }
                if ("xmlns".equals(currentAttName)) {
                    NamespaceDeclaration aDecl = new NamespaceDeclaration(attValue);
                    namespaceDecls.add(aDecl);
                } else if ("xmlns".equals(currentAttNamespacePrefix) && currentAttName != null) {
                    NamespaceDeclaration prefixDecl = new NamespaceDeclaration(attValue, currentAttName);
                    namespaceDecls.add(prefixDecl);
                }
            } else if (tagToken.getToken() == 24 && (symbolValue = DocumentPathGenerator._getStringValue(tagLexer.getTextBuffer(), tagToken)).indexOf("/") != -1) {
                isEndTag = true;
                if (elementName == null) {
                    isStartTag = false;
                }
            }
            tagLexer.lex(tagToken);
        }
        returnInfo = new DocumentNode(namespacePrefix, elementName, elementToken.getStartOffset(), elementToken.getEndOffset());
        if (attributes.size() > 0) {
            AttributeNode[] array = new AttributeNode[attributes.size()];
            attributes.toArray(array);
            returnInfo.setAttributes(array);
        }
        int tagType = 11;
        if (isStartTag && isEndTag) {
            tagType = 13;
        } else if (isEndTag) {
            tagType = 12;
        }
        returnInfo.setTagType(tagType);
        returnInfo.addNamespaceDecls(namespaceDecls);
        return returnInfo;
    }

    private static String _getStringValue(ReadTextBuffer buffer, LexerToken token) {
        int startOffset = token.getStartOffset();
        int endOffset = token.getEndOffset();
        return new String(buffer.getChars(startOffset, endOffset - startOffset));
    }
}

