/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.io.File;
import java.net.URL;
import java.util.Set;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;

public final class GrammarRegistryTest {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage:  SchemaTest [path to schema]");
            System.exit(1);
        }
        SchemaGrammarProvider grammarProvider = new SchemaGrammarProvider();
        for (int i = 0; i < args.length; ++i) {
            URL currentURL = null;
            try {
                Object filename = args[i];
                File aFile = new File((String)filename);
                filename = aFile.getCanonicalPath();
                filename = ((String)filename).charAt(0) == '/' ? "file:" + (String)filename : "file:/" + (String)filename;
                currentURL = new URL((String)filename);
            }
            catch (Exception e) {
                System.err.println("Could not find file" + args[i]);
            }
            if (currentURL == null) continue;
            try {
                Set grammars = grammarProvider.addSchema(currentURL);
                for (Grammar g : grammars) {
                    System.out.println(g.getTargetNamespace());
                    System.out.println(g.getElementDefs());
                }
                continue;
            }
            catch (GrammarException ex) {
                ex.printStackTrace();
            }
        }
        Grammar uiGrammar = grammarProvider.getGrammarForNamespace("http://xmlns.oracle.com/uix/ui");
        ElementDef element = uiGrammar.getElementDefByName("pageLayout");
        System.out.println(element.getElementDefs());
        System.out.println(element.getAttributeDefs());
        ElementDef inside = element.getElementDefByName("contents");
        System.out.println(inside.getElementDefs());
        System.out.println(inside.getAttributeDefs());
    }
}

