/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.newquery.controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.text.Document;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.auxgui.SpatialColorChooserPanel;
import oracle.dbtools.spatial.dialogs.newquery.model.NewQueryModel;
import oracle.dbtools.spatial.dialogs.newquery.view.NewQueryDialog;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.plugins.EditorPlugin;

public class NewQueryController {
    private NewQueryModel model;
    private NewQueryDialog view;

    public NewQueryController(NewQueryModel newQueryModel, NewQueryDialog newQueryDialog) {
        this.model = newQueryModel;
        this.view = newQueryDialog;
        this.view.setOkButtonListener(new OkButtonActionListener());
        this.view.setCancelButtonListener(new CancelButtonActionListener());
        this.view.setHelpButtonActionListener(new HelpButonActionListener());
        this.view.setAreaFillColorPanelListener(new ColorPanelMouseListener());
        this.view.setBorderColorPanelListener(new ColorPanelMouseListener());
        this.view.setCurveColorPanelListener(new ColorPanelMouseListener());
        this.view.setMarkerColorPanelListener(new ColorPanelMouseListener());
        this.view.setMarkerFillPanelListener(new ColorPanelMouseListener());
        this.view.setLabelColoPanelClickListener(new ColorPanelMouseListener());
        this.view.setQueryAreaKeyListener(new QueryAreaKeyListener());
        this.installPlugins();
        this.view.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewQueryController.this.view.dispose();
            }
        });
    }

    public void showDialog() {
        this.view.setVisible(true);
    }

    private void installPlugins() {
        this.view.getQueryEditorPane().installPlugin((EditorPlugin)this.model.getHighLightPlugin());
        this.view.getQueryEditorPane().installPlugin((EditorPlugin)this.model.getLineGutterPlugin());
        this.view.getQueryEditorPane().setDocument((Document)this.model.getDocument());
    }

    private class OkButtonActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = NewQueryController.this.view.getTitleText();
            boolean bl = this.validateTitle(string);
            if (!bl) {
                return;
            }
            String string2 = MapViewerHelper.purgeLastSemicolon(NewQueryController.this.view.getQueryText());
            bl = this.validateQuery(string2);
            if (!bl) {
                return;
            }
            NewQueryController.this.model.setQueryTitle(string);
            NewQueryController.this.model.setQueryText(string2);
            NewQueryController.this.model.setLabelColumn(NewQueryController.this.view.getLabelColumn());
            NewQueryController.this.model.setMarkerBorder(NewQueryController.this.view.getMarkerBorderColor());
            NewQueryController.this.model.setMarkerFillColor(NewQueryController.this.view.getMarkerFillColor());
            NewQueryController.this.model.setMarker_size(NewQueryController.this.view.getMarkerSize());
            NewQueryController.this.model.setMarkerStyle(NewQueryController.this.view.getMarkerType());
            NewQueryController.this.model.setLine_color(NewQueryController.this.view.getCurveColor());
            NewQueryController.this.model.setLine_width(NewQueryController.this.view.getCurveWidth());
            NewQueryController.this.model.setArea_border_color(NewQueryController.this.view.getAreaBorderColor());
            NewQueryController.this.model.setArea_fill_color(NewQueryController.this.view.getAreaFillColor());
            ((SpatialReorderableTableModel)((Object)NewQueryController.this.model.getMapsTableModel())).setTableSRID(NewQueryController.this.model.getCurrentTableSRID());
            NewQueryController.this.view.dispatchEvent(new WindowEvent(NewQueryController.this.view, 201));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean validateQuery(String string) {
            boolean bl = false;
            int n = NewQueryController.this.model.getCurrentTableSRID();
            try {
                Vector<Integer[]> vector = MapViewerHelper.getQuerySRIDS(string, NewQueryController.this.model.getMapConnection());
                bl = MapViewerHelper.isValidSpatialQuery(string, NewQueryController.this.model.getMapConnection());
                if (MapViewerHelper.areQuerySRIDsValid(n, vector)) {
                    if (vector.size() > 0) {
                        NewQueryController.this.model.setCurrentTableSRID(vector.get(0)[0]);
                    }
                    boolean bl2 = bl;
                    return bl2;
                }
                try {
                    throw new Exception(SpatialArb.getString("NonMatchingSRIDException"));
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
                    boolean bl3 = false;
                    return bl3;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TITLE"), null);
                    boolean bl4 = false;
                    return bl4;
                }
            }
            finally {
                System.gc();
            }
        }

        private boolean validateTitle(String string) {
            if (string == null || string.equals("") || string.length() == 0) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13514"), (String)SpatialArb.getString("MapViewerQueryEditDialogMapTitleErrorTitle"), null);
                return false;
            }
            if (MapViewerHelper.isDuplicatedTitleInTable(string, NewQueryController.this.model.getMapsTableModel())) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13515"), (String)SpatialArb.getString("MapViewerQueryTitleUniqnessError"), null);
                return false;
            }
            return true;
        }
    }

    private class CancelButtonActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewQueryController.this.view.dispatchEvent(new WindowEvent(NewQueryController.this.view, 201));
        }
    }

    private class HelpButonActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpButonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpSystem.getHelpSystem().showHelp(NewQueryController.this.model.getHelpInfo());
        }
    }

    private class ColorPanelMouseListener
    extends MouseAdapter {
        Color theColor;
        Object source;
        JColorChooser colorChooser;

        private ColorPanelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            Object object2;
            this.theColor = Color.cyan;
            this.source = mouseEvent.getSource();
            AbstractColorChooserPanel[] abstractColorChooserPanelArray = new AbstractColorChooserPanel[]{new SpatialColorChooserPanel()};
            JPanel jPanel = new JPanel();
            if (this.source instanceof JPanel) {
                object2 = (JPanel)this.source;
                object = ((Component)object2).getName();
                if (((String)object).equals("markerBorderColorPanel")) {
                    this.theColor = NewQueryController.this.model.getMarker_color();
                } else if (((String)object).equals("curveColorPanel")) {
                    this.theColor = NewQueryController.this.model.getLine_color();
                } else if (((String)object).equals("areaBorderColorPanel")) {
                    this.theColor = NewQueryController.this.model.getArea_border_color();
                } else if (((String)object).equals("areaFillColorPanel")) {
                    this.theColor = NewQueryController.this.model.getArea_fill_color();
                } else if (((String)object).equals("markerFillPanel")) {
                    this.theColor = NewQueryController.this.model.getMarkerFillColor();
                } else if (((String)object).equals("labelColorPanel")) {
                    this.theColor = NewQueryController.this.model.getLabelColor();
                }
            }
            this.colorChooser = new JColorChooser(this.theColor);
            object2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPanelMouseListener.this.theColor = ColorPanelMouseListener.this.colorChooser.getColor();
                    if (ColorPanelMouseListener.this.source instanceof JPanel) {
                        JPanel jPanel = (JPanel)ColorPanelMouseListener.this.source;
                        jPanel.setBackground(ColorPanelMouseListener.this.theColor);
                        String string = jPanel.getName();
                        if (string.equals("markerBorderColorPanel")) {
                            NewQueryController.this.model.setMarkerBorder(ColorPanelMouseListener.this.theColor);
                        } else if (string.equals("curveColorPanel")) {
                            NewQueryController.this.model.setLine_color(ColorPanelMouseListener.this.theColor);
                        } else if (string.equals("areaBorderColorPanel")) {
                            NewQueryController.this.model.setArea_border_color(ColorPanelMouseListener.this.theColor);
                        } else if (string.equals("areaFillColorPanel")) {
                            NewQueryController.this.model.setArea_fill_color(ColorPanelMouseListener.this.theColor);
                        } else if (string.equals("markerFillPanel")) {
                            NewQueryController.this.model.setMarkerFillColor(ColorPanelMouseListener.this.theColor);
                        } else if (string.equals("labelColorPanel")) {
                            NewQueryController.this.model.setLabelColor(ColorPanelMouseListener.this.theColor);
                        }
                    }
                }
            };
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            JDialog jDialog = JColorChooser.createDialog(jPanel, SpatialArb.getString("NewQueryDialogChooseColor"), true, this.colorChooser, (ActionListener)object2, (ActionListener)object);
            jDialog.setVisible(true);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jDialog);
        }
    }

    private class QueryAreaKeyListener
    extends KeyAdapter {
        private QueryAreaKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            NewQueryController.this.model.getComboLoader().setQuery(NewQueryController.this.view.getQueryText());
            NewQueryController.this.view.getDelayedComboBox().restart();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            NewQueryController.this.model.getComboLoader().setQuery(NewQueryController.this.view.getQueryText());
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            NewQueryController.this.model.getComboLoader().setQuery(NewQueryController.this.view.getQueryText());
            NewQueryController.this.view.getDelayedComboBox().restart();
        }
    }
}

