/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.viz.util.Tree;

public class DFTreeIterator
implements Iterator {
    Tree tree = null;
    int viewDepth = Integer.MAX_VALUE;
    ListIterator internalIter = null;
    DFTreeIterator childIter = null;
    Tree.Node lastNode = null;
    boolean skipChildren = false;

    DFTreeIterator(Tree t) {
        this(t, Integer.MAX_VALUE);
    }

    DFTreeIterator(Tree t, int viewDepth) {
        if (null == t) {
            throw new IllegalArgumentException("Null Tree passed to DFTreeIterator");
        }
        if (viewDepth < 0) {
            throw new IllegalArgumentException("Illegal viewDepth setting passed to DFTreeIterator");
        }
        this.tree = t;
        this.viewDepth = viewDepth;
        this.internalIter = t.internalList.listIterator();
        this.childIter = null;
        this.lastNode = null;
        this.skipChildren = false;
    }

    Tree.Node lastNode() {
        if (null == this.lastNode) {
            throw new NoSuchElementException("No active last node");
        }
        if (null != this.childIter) {
            return this.childIter.lastNode();
        }
        return this.lastNode;
    }

    public int depth() {
        if (null == this.childIter) {
            return 0;
        }
        return this.childIter.depth() + 1;
    }

    public boolean hasChildren() {
        if (null != this.childIter) {
            return this.childIter.hasChildren();
        }
        if (this.viewDepth == 0 || this.skipChildren) {
            return false;
        }
        Tree t = this.lastNode().subTree;
        return null != t && !t.isEmpty();
    }

    public void add(Object o) {
        if (null != this.childIter) {
            this.childIter.add(o);
            return;
        }
        this.lastNode = Tree.newNode(o);
        this.childIter = null;
        this.skipChildren = false;
        this.tree.addNotify(this.lastNode);
        this.internalIter.add(this.lastNode);
    }

    public void addChild(Object o) {
        if (null != this.childIter) {
            this.childIter.addChild(o);
            return;
        }
        Tree.Node node = this.lastNode();
        if (null == node.subTree) {
            node.subTree = new Tree(this.tree);
        }
        node.subTree.add(o);
    }

    public void addChildren(Object[] array) {
        if (null != this.childIter) {
            this.childIter.addChildren(array);
            return;
        }
        Tree.Node node = this.lastNode();
        if (null == node.subTree) {
            node.subTree = new Tree(this.tree, array);
        } else {
            int i = 0;
            while (i < array.length) {
                node.subTree.add(array[i]);
                ++i;
            }
        }
    }

    public void addTree(Tree t) {
        Iterator addIter = t.internalList.iterator();
        while (addIter.hasNext()) {
            Tree.Node node = (Tree.Node)addIter.next();
            this.add(node.item);
            this.lastNode.subTree = node.subTree;
        }
    }

    public void addTree(Object[] array) {
        int i = 0;
        while (i < array.length) {
            Object o = array[i];
            Class<?> type = o.getClass();
            if (type.isArray()) {
                if (null == this.lastNode) {
                    throw new IllegalArgumentException("No root for subarray");
                }
                if (null != this.lastNode.subTree) {
                    throw new IllegalArgumentException("Subarray already set");
                }
                this.lastNode.subTree = new Tree(this.tree);
                DFTreeIterator subIter = new DFTreeIterator(this.lastNode.subTree);
                subIter.addTree((Object[])array[i]);
            } else {
                this.add(o);
            }
            ++i;
        }
    }

    public boolean hasNextCousin() {
        if (this.internalIter.hasNext()) {
            return true;
        }
        if (this.viewDepth == 0) {
            return false;
        }
        return null != this.childIter && this.childIter.hasNextCousin();
    }

    public Object nextCousin() {
        if (null == this.lastNode) {
            this.lastNode = (Tree.Node)this.internalIter.next();
            return this.lastNode.item;
        }
        if (null != this.childIter) {
            if (this.childIter.hasNextCousin()) {
                return this.childIter.nextCousin();
            }
            this.childIter = null;
        }
        this.lastNode = (Tree.Node)this.internalIter.next();
        return this.lastNode.item;
    }

    public void up() {
        int d = this.depth();
        if (0 == d) {
            return;
        }
        this.up(d - 1);
    }

    void up(int moreDepth) {
        if (0 == moreDepth) {
            this.childIter = null;
            this.skipChildren = true;
            return;
        }
        if (null != this.childIter) {
            this.childIter.up(moreDepth - 1);
        }
    }

    public boolean hasNext() {
        if (this.internalIter.hasNext()) {
            return true;
        }
        if (this.viewDepth == 0) {
            return false;
        }
        if (null != this.childIter && this.childIter.hasNext()) {
            return true;
        }
        return null != this.lastNode && this.hasChildren();
    }

    public Object next() {
        if (null == this.lastNode) {
            this.lastNode = (Tree.Node)this.internalIter.next();
            return this.lastNode.item;
        }
        if (null != this.childIter) {
            if (this.childIter.hasNext()) {
                return this.childIter.next();
            }
            this.childIter = null;
        } else if (this.viewDepth > 0 && this.hasChildren()) {
            this.childIter = new DFTreeIterator(this.lastNode.subTree, this.viewDepth == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.viewDepth - 1);
            return this.childIter.next();
        }
        this.skipChildren = false;
        this.lastNode = (Tree.Node)this.internalIter.next();
        return this.lastNode.item;
    }

    public void remove() {
        if (null != this.childIter) {
            this.childIter.remove();
            return;
        }
        this.tree.removeNotify(this.lastNode.item);
        this.internalIter.remove();
        this.lastNode = null;
        this.childIter = null;
        this.skipChildren = false;
    }
}

