/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.FontMetrics;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DimensionElement {
    public String name;
    public int field;
    public int field2;
    public int label;
    public int field_modulus;
    public int field_modulus2;
    public String[] fieldLabels;
    int gridline = 2;
    boolean gridOn = true;
    public boolean labelOn = true;
    public int period = 1;
    int period_counter = 0;
    String[] ampmLabels;
    public int ampmIndex = 0;
    public Locale chartLocale;

    public DimensionElement(String n, int f, int l) {
        this.name = n;
        this.field = f;
        this.label = l;
    }

    public DimensionElement() {
        this.field = 0;
        this.field2 = 0;
        this.label = 0;
        this.field_modulus = 0;
        this.field_modulus2 = 0;
        this.fieldLabels = null;
    }

    public String getName() {
        return this.name;
    }

    public DimensionElement(Locale chtLocale, String n, int f, int l, Calendar C, Date initialDate) {
        this.chartLocale = chtLocale;
        this.name = n;
        this.field = f;
        this.label = l;
        DateFormatSymbols dfs = new DateFormatSymbols(this.chartLocale);
        C.setTime(initialDate);
        this.field_modulus = C.get(this.field);
        this.field_modulus2 = C.get(this.field2);
        this.setChoiceFieldLabels();
    }

    public void updateFieldModulus(Calendar C) {
        this.field_modulus = C.get(this.field);
    }

    public void updateFieldModulus2(Calendar C) {
        this.field_modulus2 = C.get(this.field2);
    }

    public void setAmPm() {
        DateFormatSymbols dfs = new DateFormatSymbols(this.chartLocale);
        this.ampmLabels = dfs.getAmPmStrings();
    }

    public void setOneCharMonths() {
        DateFormatSymbols dfs = new DateFormatSymbols(this.chartLocale);
        this.fieldLabels = dfs.getShortMonths();
        int j = 0;
        while (j < this.fieldLabels.length) {
            if (this.fieldLabels[j].length() > 1) {
                this.fieldLabels[j] = this.fieldLabels[j].substring(0, 1);
            }
            ++j;
        }
    }

    public void setOneCharWeekDays(int availableWidth, FontMetrics fontmet) {
        int j;
        int currentStringLength;
        String labelString;
        DateFormatSymbols dfs = new DateFormatSymbols(this.chartLocale);
        boolean labelWidth = false;
        String[] fieldLabelsTemp = dfs.getWeekdays();
        boolean longWeeksFit = true;
        int maxStringLength = 0;
        int j2 = 1;
        while (j2 < fieldLabelsTemp.length) {
            labelString = fieldLabelsTemp[j2];
            currentStringLength = fontmet.stringWidth(labelString);
            if (maxStringLength < currentStringLength && (maxStringLength = currentStringLength) > availableWidth) {
                longWeeksFit = false;
                break;
            }
            ++j2;
        }
        boolean shortWeeksFit = true;
        if (!longWeeksFit) {
            maxStringLength = 0;
            fieldLabelsTemp = dfs.getShortWeekdays();
            j = 1;
            while (j < fieldLabelsTemp.length) {
                labelString = fieldLabelsTemp[j];
                currentStringLength = fontmet.stringWidth(labelString);
                if (maxStringLength < currentStringLength && (maxStringLength = currentStringLength) > availableWidth) {
                    shortWeeksFit = false;
                    break;
                }
                ++j;
            }
        }
        this.fieldLabels = fieldLabelsTemp;
        if (!longWeeksFit && !shortWeeksFit) {
            j = 0;
            while (j < this.fieldLabels.length) {
                if (this.fieldLabels[j].length() > 1) {
                    this.fieldLabels[j] = this.fieldLabels[j].substring(0, 1);
                }
                ++j;
            }
        }
    }

    public void setChoiceFieldLabels() {
        DateFormatSymbols dfs = new DateFormatSymbols(this.chartLocale);
        switch (this.label) {
            case 4: {
                this.setOneCharMonths();
                break;
            }
            case 62: {
                this.fieldLabels = dfs.getShortMonths();
                break;
            }
            case 6: {
                this.fieldLabels = dfs.getMonths();
                break;
            }
            case 61: {
                this.setOneCharMonths();
            }
        }
    }
}

