/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.view.MultiManager;
import oracle.ide.view.View;
import oracle.ideimpl.palette2.GroupDockable;
import oracle.ideimpl.palette2.InactiveDockable;
import oracle.ideimpl.palette2.MyComponentsDockable;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.jndi.Names;

public class PaletteDockableFactory
implements BaseDockableFactory {
    public static final String VIEW_TYPE = "PALETTEFACTORY";
    private static PaletteDockableFactory _singleton;
    private static InactiveDockable inactiveDockable;
    private static InactiveDockable loadingPaletteDockable;
    final Map<String, WeakReference<View>> groupViews = new HashMap<String, WeakReference<View>>();

    public PaletteDockableFactory() {
        assert (_singleton == null) : "Attempt to construct more than one PaletteDockableFactory. Use getInstance() instead";
        _singleton = this;
    }

    public static PaletteDockableFactory getInstance() {
        if (_singleton == null) {
            new PaletteDockableFactory();
        }
        return _singleton;
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        MultiManager mgr = (MultiManager)Names.lookup((Context)Names.newInitialContext(), (String)"ide/inspector-manager");
        ViewId viewId = mgr.getDefaultViewId();
        DockStation ds = DockStation.getDockStation();
        Dockable inspectorDockable = ds.findDockable(viewId);
        if (inspectorDockable != null) {
            dockingParam.setPosition(inspectorDockable, 2, 1);
        } else {
            dockingParam.setPosition(1);
        }
        DockStation.getDockStation().dock((Dockable)PaletteWindowImpl.getInstance(), dockingParam);
    }

    public View lookupView(ViewId viewId) {
        View view;
        String viewName = viewId.getName();
        if (viewName == null || "PALETTE".equals(viewName)) {
            return PaletteWindowImpl.getInstance();
        }
        WeakReference<View> reference = this.groupViews.get(viewId.getId());
        if (null != reference && null != (view = (View)reference.get())) {
            return view;
        }
        if (viewName.startsWith(PaletteArb.getString(5))) {
            return this.addForHideDockables(viewId, (View)new MyComponentsDockable(viewId));
        }
        if (viewName.startsWith(PaletteArb.getString(52))) {
            if (inactiveDockable == null) {
                inactiveDockable = new InactiveDockable(viewName);
                inactiveDockable.setDisplayMessage(PaletteArb.getString(52));
            }
            return inactiveDockable;
        }
        if (viewName.startsWith(PaletteArb.getString(62))) {
            if (loadingPaletteDockable == null) {
                loadingPaletteDockable = new InactiveDockable(viewName);
                loadingPaletteDockable.setDisplayMessage(PaletteArb.getString(62));
            }
            return loadingPaletteDockable;
        }
        return this.addForHideDockables(viewId, (View)new GroupDockable(viewId));
    }

    private View addForHideDockables(ViewId viewId, View view) {
        this.groupViews.put(viewId.getId(), new WeakReference<View>(view));
        return view;
    }

    public Dockable getDockable(ViewId viewId) {
        return (Dockable)this.lookupView(viewId);
    }

    public void hideDockables() {
        PaletteWindowImpl w = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
        for (WeakReference<View> wrView : this.groupViews.values()) {
            View view = (View)wrView.get();
            if (view == null) continue;
            try {
                w.hide(view);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
            }
        }
    }
}

