/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetSection;
import oracle.ideimpl.palette2.MyComponentsFavoritesSection;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.MyComponentsRecentlyUsedSection;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public class MyComponentsPageModel
extends HashStructureAdapter {
    private MyComponentsPageModel(HashStructure hash) {
        super(hash);
    }

    public static MyComponentsPageModel getInstance(HashStructure hash) {
        return new MyComponentsPageModel(hash);
    }

    public void persistFavorites(Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
        FavoritesAdapter favAdapter = new FavoritesAdapter(this._hash, context, nsURI, rootName, urlHashIO, palettePage);
        this.persist(favAdapter);
    }

    public void persistRecentlyUsed(Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
        RecentlyUsedAdapter ruAdapter = new RecentlyUsedAdapter(this._hash, context, nsURI, rootName, urlHashIO, palettePage);
        this.persist(ruAdapter);
    }

    public void persist(Adapter adapter) {
        HashStructure sections;
        String groupName;
        HashStructure group;
        HashStructure hash = null;
        HashStructureIO hashIO = new HashStructureIO(adapter.nsURI, adapter.rootName);
        Object view = null;
        if (null != adapter.context && null == (view = adapter.context.getView()) && null == (view = EditorManager.getEditorManager().getCurrentEditor())) {
            return;
        }
        String editorName = view.getClass().getName();
        try {
            hash = (HashStructure)hashIO.load(adapter.urlHashIO);
        }
        catch (IOException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (hash == null) {
            hash = this._hash;
        }
        if ((group = hash.getHashStructure(groupName = adapter.getGroupName())) == null) {
            group = HashStructure.newInstance();
            hash.putHashStructure(groupName, group);
        }
        if ((sections = group.getHashStructure(editorName)) == null) {
            sections = HashStructure.newInstance();
            group.putHashStructure(editorName, sections);
        }
        sections.clear();
        if (adapter.palettePage != null) {
            Collection<PaletteGroup> paletteGroups = adapter.palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!adapter.isMatchingGroup(paletteGroup.getName())) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    HashStructure sectionHash = HashStructure.newInstance();
                    PaletteAugmentedSection mySection = (PaletteAugmentedSection)paletteSection;
                    String sectionName = mySection.getName();
                    if (sectionName == null) {
                        sectionName = " ";
                    }
                    sections.putHashStructure(sectionName, sectionHash);
                    ListStructure items = ListStructure.newInstance();
                    sectionHash.putListStructure("items", items);
                    Collection<PaletteAugmentedItem> paletteItems = mySection.getAugmentedItems(false);
                    for (PaletteAugmentedItem augItem : paletteItems) {
                        HashStructure itemHash = HashStructure.newInstance();
                        String pageName = augItem.getPageName();
                        itemHash.putString("pageName", pageName);
                        String itemGroupName = augItem.getGroupName();
                        itemHash.putString("groupName", itemGroupName);
                        String providerId = augItem.getPaletteItem().getProviderId();
                        itemHash.putString("providerId", providerId);
                        String itemId = augItem.getPaletteItem().getItemId();
                        itemHash.putString("itemId", itemId);
                        items.add((Object)itemHash);
                    }
                }
            }
        }
        try {
            hashIO.save(adapter.urlHashIO, (Object)hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<MyComponentsFavoritesSection> getFavorites(Context context) {
        FavoritesAdapter favAdapter = new FavoritesAdapter(this._hash, context);
        this.processSections(favAdapter);
        return ((Adapter)favAdapter).getSections();
    }

    public Collection<MyComponentsRecentlyUsedSection> getRecentlyUsed(Context context) {
        RecentlyUsedAdapter ruAdapter = new RecentlyUsedAdapter(this._hash, context);
        this.processSections(ruAdapter);
        return ((Adapter)ruAdapter).getSections();
    }

    private void processSections(Adapter adapter) {
        if (null == adapter || null == adapter.context || null == adapter.context.getView()) {
            return;
        }
        String editorName = adapter.context.getView().getClass().getName();
        PaletteWindowImpl pWindow = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
        HashStructure group = this._hash.getHashStructure(adapter.getGroupName());
        if (group == null) {
            return;
        }
        HashStructure sections = group.getHashStructure(editorName);
        if (sections == null || sections.keySet().size() == 0) {
            return;
        }
        for (String sectionName : sections.keySet()) {
            HashStructure section = sections.getHashStructure(sectionName);
            if (sectionName.equals(" ")) {
                sectionName = "";
            }
            PaletteAugmentedSection favoriteSect = adapter.newSection(sectionName);
            ListStructure items = section.getListStructure("items");
            if (items == null || items.size() == 0) continue;
            for (HashStructure hI : items) {
                String pageName = hI.getString("pageName");
                String groupName = hI.getString("groupName");
                String itemId = hI.getString("itemId");
                String providerId = hI.getString("providerId");
                PaletteItem pItem = pWindow.getItem(providerId, itemId);
                if (pItem == null) continue;
                favoriteSect.addItem(pItem, pageName, groupName);
            }
        }
    }

    public void persistCodeSnippets(Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
        HashStructure hash = null;
        HashStructureIO hashIO = new HashStructureIO(nsURI, rootName);
        String editorName = context.getView().getClass().getName();
        try {
            hash = (HashStructure)hashIO.load(urlHashIO);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (hash == null) {
            hash = this._hash;
        } else {
            hash.remove("CodeSnippets");
        }
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(11))) continue;
                ListStructure snippets = ListStructure.newInstance();
                hash.putListStructure("CodeSnippets", snippets);
                ListStructure editorList = ListStructure.newInstance();
                snippets.add((Object)editorList);
                HashStructure editorHash = HashStructure.newInstance();
                editorList.add((Object)editorHash);
                ListStructure sections = ListStructure.newInstance();
                editorHash.putListStructure(editorName, sections);
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    MyComponentsCodeSnippetSection mySection = (MyComponentsCodeSnippetSection)paletteSection;
                    HashStructure sectionHash = HashStructure.newInstance();
                    sections.add((Object)sectionHash);
                    String sectionName = mySection.getName();
                    if (sectionName == null) {
                        sectionName = " ";
                    }
                    sectionHash.putString("sectionName", sectionName);
                    ListStructure items = ListStructure.newInstance();
                    sectionHash.putListStructure("items", items);
                    Collection<PaletteItem> paletteItems = mySection.getItems();
                    for (PaletteItem pItem : paletteItems) {
                        HashStructure itemHash = HashStructure.newInstance();
                        items.add((Object)itemHash);
                        DefaultPaletteItem defItem = (DefaultPaletteItem)pItem;
                        itemHash.putString("name", defItem.getName());
                        itemHash.putString("iconUrl", defItem.getIconURL());
                        String snippet = (String)defItem.getData("codeSnippet");
                        itemHash.putString("snippet", snippet);
                    }
                }
            }
        }
        try {
            hashIO.save(urlHashIO, (Object)hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<MyComponentsCodeSnippetSection> getCodeSnippets(Context context) {
        String sectionId = MyComponentsPages.getIdentifier(6, null);
        if (context == null || context.getView() == null) {
            return Collections.emptyList();
        }
        String editor = context.getView().getClass().getName();
        ArrayList<MyComponentsCodeSnippetSection> codeSnippetsSection = new ArrayList<MyComponentsCodeSnippetSection>();
        ListStructure listSnippets = this._hash.getListStructure("CodeSnippets");
        if (listSnippets != null) {
            for (ListStructure listX : listSnippets) {
                for (HashStructure hashX : listX) {
                    ListStructure hashEditor = hashX.getListStructure(editor);
                    if (hashEditor == null) continue;
                    for (HashStructure hE : hashEditor) {
                        String sectionName = hE.getString("sectionName");
                        if (sectionName.equals(" ")) {
                            sectionName = "";
                        }
                        String sectionIdCodeSnippet = sectionId + sectionName;
                        MyComponentsCodeSnippetSection codeSnippetSect = new MyComponentsCodeSnippetSection(sectionName, sectionIdCodeSnippet);
                        codeSnippetsSection.add(codeSnippetSect);
                        ListStructure listItems = hE.getListStructure("items");
                        if (listItems == null) continue;
                        for (HashStructure hI : listItems) {
                            String itemName = hI.getString("name");
                            String itemIconUrl = hI.getString("iconUrl");
                            String snippet = hI.getString("snippet");
                            MyComponentsCodeSnippetItem pItem = new MyComponentsCodeSnippetItem(itemName, itemIconUrl, snippet);
                            codeSnippetSect.addItem(pItem);
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableList(codeSnippetsSection);
    }

    class FavoritesAdapter
    extends Adapter {
        static final String GROUP_NAME = "Favorites";
        List<MyComponentsFavoritesSection> favoritesSections;

        FavoritesAdapter(HashStructure hash, Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
            super(hash, context, nsURI, rootName, urlHashIO, palettePage);
            this.favoritesSections = new ArrayList<MyComponentsFavoritesSection>();
        }

        FavoritesAdapter(HashStructure hash, Context context) {
            super(hash, context);
            this.favoritesSections = new ArrayList<MyComponentsFavoritesSection>();
        }

        @Override
        String getGroupName() {
            return GROUP_NAME;
        }

        @Override
        boolean isMatchingGroup(String name) {
            return PaletteArb.getString(7).equals(name);
        }

        @Override
        String getSectionId() {
            return MyComponentsPages.getIdentifier(5, null);
        }

        Collection<MyComponentsFavoritesSection> getSections() {
            return Collections.unmodifiableCollection(this.favoritesSections);
        }

        @Override
        PaletteAugmentedSection newSection(String sectionName) {
            String sectionIdFavorites = this.getSectionId() + sectionName;
            MyComponentsFavoritesSection section = new MyComponentsFavoritesSection(sectionName, sectionIdFavorites);
            this.favoritesSections.add(section);
            return section;
        }
    }

    abstract class Adapter {
        final HashStructure hash;
        final Context context;
        final String nsURI;
        final String rootName;
        final URL urlHashIO;
        final PalettePage palettePage;

        Adapter(HashStructure hash, Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
            this.hash = hash;
            this.context = context;
            this.nsURI = nsURI;
            this.rootName = rootName;
            this.urlHashIO = urlHashIO;
            this.palettePage = palettePage;
        }

        Adapter(HashStructure hash, Context context) {
            this(hash, context, null, null, null, null);
        }

        abstract String getGroupName();

        abstract boolean isMatchingGroup(String var1);

        abstract String getSectionId();

        abstract Collection<? extends PaletteAugmentedSection> getSections();

        abstract PaletteAugmentedSection newSection(String var1);
    }

    class RecentlyUsedAdapter
    extends Adapter {
        static final String GROUP_NAME = "Recently Used";
        List<MyComponentsRecentlyUsedSection> recentlyUsedSections;

        RecentlyUsedAdapter(HashStructure hash, Context context, String nsURI, String rootName, URL urlHashIO, PalettePage palettePage) {
            super(hash, context, nsURI, rootName, urlHashIO, palettePage);
            this.recentlyUsedSections = new ArrayList<MyComponentsRecentlyUsedSection>();
        }

        RecentlyUsedAdapter(HashStructure hash, Context context) {
            super(hash, context);
            this.recentlyUsedSections = new ArrayList<MyComponentsRecentlyUsedSection>();
        }

        @Override
        String getGroupName() {
            return GROUP_NAME;
        }

        @Override
        boolean isMatchingGroup(String name) {
            return PaletteArb.getString(9).equals(name);
        }

        @Override
        String getSectionId() {
            return MyComponentsPages.getIdentifier(7, null);
        }

        Collection<MyComponentsRecentlyUsedSection> getSections() {
            if (this.recentlyUsedSections.isEmpty()) {
                this.newSection("");
            }
            return Collections.unmodifiableCollection(this.recentlyUsedSections);
        }

        @Override
        PaletteAugmentedSection newSection(String sectionName) {
            String sectionIdFavorites = this.getSectionId() + sectionName;
            MyComponentsRecentlyUsedSection section = new MyComponentsRecentlyUsedSection(sectionName, sectionIdFavorites);
            this.recentlyUsedSections.add(section);
            return section;
        }
    }
}

