/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public abstract class PalettePage {
    private static KeyDepth DEFAULT_DEPTH = KeyDepth.ITEM;
    private static KeyDepth EQUALS_DEPTH = KeyDepth.GROUP;

    public abstract Collection<PaletteGroup> getGroups();

    public abstract String getName();

    public abstract String getDescription();

    public abstract Icon getIcon();

    public abstract Object getData(Object var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PalettePage)) {
            return false;
        }
        PalettePage that = (PalettePage)object;
        return this.doGetPageKey(EQUALS_DEPTH).equals(that.doGetPageKey(EQUALS_DEPTH));
    }

    public int hashCode() {
        return this.doGetPageKey(EQUALS_DEPTH).hashCode();
    }

    public boolean isEmpty() {
        Collection<PaletteGroup> myGroups = this.getGroups();
        if (null == myGroups || myGroups.isEmpty()) {
            return true;
        }
        for (PaletteGroup group : myGroups) {
            if (group.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (PaletteGroup group : this.getGroups()) {
            group.dispose();
        }
    }

    public String toString() {
        StringBuilder temp = new StringBuilder();
        boolean afterFirst = false;
        for (PaletteGroup x : this.getGroups()) {
            if (afterFirst) {
                temp.append(",\n");
            }
            temp.append("\t").append(x.toString());
            afterFirst = true;
        }
        return temp.toString();
    }

    public String getPageKey() {
        return this.doGetPageKey(DEFAULT_DEPTH);
    }

    private String doGetPageKey(KeyDepth depth) {
        StringBuilder key = new StringBuilder(this.getClass().getSimpleName()).append(" - ").append(this.getName()).append(":\n");
        boolean nextGroup = false;
        for (PaletteGroup group : depth.getGroups(this)) {
            if (nextGroup) {
                key.append(",\n");
            }
            key.append("\t").append(group.getClass().getSimpleName()).append(" - ").append(group.getName()).append(":\n");
            nextGroup = true;
            boolean nextSection = false;
            for (PaletteSection section : depth.getSections(group)) {
                if (nextSection) {
                    key.append(",\n");
                }
                key.append("\t\t").append(section.getClass().getSimpleName()).append(" - ").append(section.getName()).append(":\n");
                nextSection = true;
                boolean nextItem = false;
                for (PaletteItem item : depth.getItems(section)) {
                    if (nextItem) {
                        key.append(",\n");
                    }
                    key.append("\t\t\t").append(item.getClass().getSimpleName()).append(" - ").append(item.getName());
                    nextItem = true;
                }
            }
        }
        return key.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum KeyDepth {
        NONE{

            @Override
            public Collection<PaletteGroup> getGroups(PalettePage page) {
                return Collections.emptyList();
            }

            @Override
            public Collection<PaletteSection> getSections(PaletteGroup group) {
                return Collections.emptyList();
            }

            @Override
            public Collection<PaletteItem> getItems(PaletteSection section) {
                return Collections.emptyList();
            }
        }
        ,
        GROUP{

            @Override
            public Collection<PaletteSection> getSections(PaletteGroup group) {
                return Collections.emptyList();
            }

            @Override
            public Collection<PaletteItem> getItems(PaletteSection section) {
                return Collections.emptyList();
            }
        }
        ,
        SECTION{

            @Override
            public Collection<PaletteItem> getItems(PaletteSection section) {
                return Collections.emptyList();
            }
        }
        ,
        ITEM,
        FULL;


        public Collection<PaletteGroup> getGroups(PalettePage page) {
            return page.getGroups();
        }

        public Collection<PaletteSection> getSections(PaletteGroup group) {
            return group.getSections();
        }

        public Collection<PaletteItem> getItems(PaletteSection section) {
            return section.getItems();
        }
    }
}

