/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class SQLDerivedPropertySupport {
    public static DerivedPropertyBuilder createCheckConstraintBuilder(DBObjectProvider dBObjectProvider) {
        return new CheckConstraintConditionBuilder((AbstractDBObjectProvider)dBObjectProvider);
    }

    public static DerivedPropertyBuilder createVirtualExpressionBuilder(DBObjectProvider dBObjectProvider) {
        return new VirtualExpressionBuilder((AbstractDBObjectProvider)dBObjectProvider);
    }

    public static DerivedPropertyBuilder createIndexExpressionBuilder(DBObjectProvider dBObjectProvider) {
        return new IndexExpressionBuilder((AbstractDBObjectProvider)dBObjectProvider);
    }

    private static void alwaysQuoteColumnUsages(DBObject dBObject) {
        if (dBObject instanceof ColumnUsage) {
            ((ColumnUsage)dBObject).setAlwaysQuote(true);
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            SQLDerivedPropertySupport.alwaysQuoteColumnUsages(dBObject2);
        }
    }

    private static SQLFragment getExpressionOrFail(DBObjectProvider dBObjectProvider, Relation relation, SQLFragmentExpressionBuilder.ExpressionType expressionType, String string, String string2) throws SQLQueryException {
        SQLFragment sQLFragment = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)dBObjectProvider, (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)expressionType, (String)string);
        if (sQLFragment != null && sQLFragment.getName() == null) {
            sQLFragment.setName(string2);
        }
        return sQLFragment;
    }

    public static class CheckConstraintConditionBuilder
    extends DerivedFromColumnsBuilder<CheckConstraint> {
        private CheckConstraintConditionBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
            super(abstractDBObjectProvider, "CONSTRAINT");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"checkConditionFragment"})
        public boolean buildConditionFragment(CheckConstraint checkConstraint) throws SQLQueryException {
            String string;
            boolean bl = false;
            Relation relation = checkConstraint.getRelation();
            if (relation != null && ModelUtil.hasLength((String)(string = checkConstraint.getCheckCondition()))) {
                bl = true;
                SQLFragment sQLFragment = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), relation, SQLFragmentExpressionBuilder.ExpressionType.CONDITION, string, "checkConditionFragment");
                checkConstraint.setCheckConditionFragment(sQLFragment);
            }
            return bl;
        }
    }

    public static class VirtualExpressionBuilder
    extends DerivedFromColumnsBuilder<Column> {
        private VirtualExpressionBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
            super(abstractDBObjectProvider, "COLUMN");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"virtualExpression"})
        public boolean buildVirtualExpression(Column column) throws SQLQueryException {
            String string;
            boolean bl = false;
            Relation relation = column.getRelation();
            if (relation != null && ModelUtil.hasLength((String)(string = column.getVirtualExpressionSource()))) {
                bl = true;
                SQLFragment sQLFragment = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), relation, SQLFragmentExpressionBuilder.ExpressionType.ITEM, string, "virtualExpression");
                if (sQLFragment != null) {
                    SQLDerivedPropertySupport.alwaysQuoteColumnUsages((DBObject)sQLFragment);
                }
                column.setVirtualExpression(sQLFragment);
            }
            return bl;
        }
    }

    public static class IndexExpressionBuilder
    extends DerivedFromColumnsBuilder<IndexObject> {
        private IndexExpressionBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
            super(abstractDBObjectProvider, "IndexObject");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"expression"})
        public boolean buildColumnExpression(IndexObject indexObject) throws SQLQueryException {
            String string;
            boolean bl = false;
            Relation relation = (Relation)DBUtil.findParentOfType((DBObject)indexObject, Relation.class);
            if (relation != null && ModelUtil.hasLength((String)(string = indexObject.getExpressionSource()))) {
                bl = true;
                SQLFragment sQLFragment = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), relation, SQLFragmentExpressionBuilder.ExpressionType.ITEM, string, "expression");
                if (sQLFragment != null && (!(sQLFragment instanceof ColumnUsage) || IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType()))) {
                    SQLDerivedPropertySupport.alwaysQuoteColumnUsages((DBObject)sQLFragment);
                }
                indexObject.setExpression(sQLFragment);
            }
            return bl;
        }
    }

    public static class SynonymUsageBuilder
    extends DerivedPropertyBuilder<SynonymUsage> {
        public SynonymUsageBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
            super(abstractDBObjectProvider, "SQLFragment");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"referenceChain"})
        public void buildReferenceChain(SynonymUsage synonymUsage) throws DBException {
            DBObject dBObject;
            DBObjectID dBObjectID = synonymUsage.getObjectID();
            if (dBObjectID != null && (dBObject = dBObjectID.resolveID()) instanceof Synonym) {
                List list = DBUtil.getSynonymReferenceChain((Synonym)((Synonym)dBObject));
                DBObjectID[] dBObjectIDArray = new DBObjectID[list.size()];
                for (int i = 0; i < dBObjectIDArray.length; ++i) {
                    dBObjectIDArray[i] = ((SchemaObject)list.get(i)).getID();
                }
                synonymUsage.setReferenceChain(dBObjectIDArray);
            }
        }
    }

    public static class SQLQueryViewColumnDTUBuilder
    extends DerivedPropertyBuilder<Column> {
        private static final String BIND_DEFAULT = "null";
        private SQLQuery m_sqlQuery;
        private int m_columnIndex;
        private final List<Tuple<String, DataTypeUsage>> m_columnInfos;

        public SQLQueryViewColumnDTUBuilder(AbstractDBObjectProvider abstractDBObjectProvider, SQLQuery sQLQuery, int n, List<Tuple<String, DataTypeUsage>> list) {
            super(abstractDBObjectProvider, "COLUMN");
            this.m_sqlQuery = sQLQuery;
            this.m_columnIndex = n;
            this.m_columnInfos = list;
        }

        protected boolean canCacheBuildFailure(Column column, String string) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
        public void buildDataTypeUsage(Column column) throws SQLQueryException {
            List list;
            if (column == null) return;
            DBObject dBObject = column.getParent();
            AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
            if (abstractDBObjectProvider instanceof Database) {
                List<Tuple<String, DataTypeUsage>> list2 = null;
                String string = this.m_sqlQuery.getSQLText();
                if (string == null) return;
                Column[] columnArray = this.m_columnInfos;
                synchronized (this.m_columnInfos) {
                    try {
                        if (this.m_columnInfos.isEmpty()) {
                            this.m_columnInfos.addAll(SQLQueryViewColumnDTUBuilder.getColumnInfo((Database)abstractDBObjectProvider, string));
                        }
                        list2 = this.m_columnInfos;
                    }
                    catch (DBException dBException) {
                        this.getLogger().warning(dBException.getMessage());
                    }
                    if (list2 == null) return;
                    if (dBObject instanceof Relation) {
                        columnArray = ((Relation)dBObject).getColumns();
                        if (columnArray.length != list2.size()) {
                            throw new IllegalStateException("Mismatch of columns");
                        }
                        for (int i = 0; i < columnArray.length; ++i) {
                            columnArray[i].setDataTypeUsage((DataTypeUsage)list2.get(i).getSecond());
                        }
                        return;
                    } else if (this.m_columnIndex < list2.size()) {
                        column.setDataTypeUsage((DataTypeUsage)list2.get(this.m_columnIndex).getSecond());
                        return;
                    } else {
                        column.setDataTypeUsage(new DataTypeUsage());
                    }
                    return;
                }
            }
            SelectObject[] selectObjectArray = SQLFragmentUtils.getSelectObjects((SQLQuery)this.m_sqlQuery);
            boolean bl = true;
            for (int i = 0; i < selectObjectArray.length; ++i) {
                bl = false;
                if (!(selectObjectArray[i].getExpression() instanceof ColumnKeywordUsage)) continue;
                bl = true;
                break;
            }
            if (this.m_columnIndex >= (list = bl ? SQLFragmentUtils.expandStarColumns((SQLQuery)this.m_sqlQuery) : Arrays.asList(selectObjectArray)).size()) return;
            SQLFragment sQLFragment = ((SelectObject)list.get(this.m_columnIndex)).getExpression();
            DataTypeUsage dataTypeUsage = this.findDTU(sQLFragment);
            column.setDataTypeUsage(dataTypeUsage);
        }

        private DataTypeUsage findDTU(SQLFragment sQLFragment) {
            SQLFragmentWithDatatype sQLFragmentWithDatatype;
            DBObjectID dBObjectID;
            DataTypeUsage dataTypeUsage = null;
            if (sQLFragment instanceof ColumnUsage) {
                ColumnUsage columnUsage = (ColumnUsage)sQLFragment;
                try {
                    Column column = (Column)columnUsage.getObjectID().resolveID();
                    if (column != null && (dataTypeUsage = column.getDataTypeUsage()) != null) {
                        dataTypeUsage = (DataTypeUsage)dataTypeUsage.copyTo(null);
                        dataTypeUsage.setID(TemporaryObjectID.createID((DBObject)dataTypeUsage));
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().fine(dBException.getMessage());
                }
            } else if (sQLFragment instanceof SelectObjectUsage) {
                SelectObjectUsage selectObjectUsage = (SelectObjectUsage)sQLFragment;
                DBObjectID dBObjectID2 = selectObjectUsage.getSelectObjectID();
                if (dBObjectID2 != null) {
                    try {
                        SelectObject selectObject = (SelectObject)dBObjectID2.resolveID();
                        return this.findDTU(selectObject.getExpression());
                    }
                    catch (DBException dBException) {
                        this.getLogger().fine(dBException.getMessage());
                    }
                }
            } else if (sQLFragment instanceof PlSqlUsage) {
                PlSqlUsage plSqlUsage = (PlSqlUsage)sQLFragment;
                try {
                    DBObject dBObject = plSqlUsage.getObjectID().resolveID();
                    if (dBObject instanceof PlSqlAttribute && (dataTypeUsage = ((PlSqlAttribute)dBObject).getDataTypeUsage()) != null) {
                        dataTypeUsage = (DataTypeUsage)dataTypeUsage.copyTo(null);
                        dataTypeUsage.setID(TemporaryObjectID.createID((DBObject)dataTypeUsage));
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().fine(dBException.getMessage());
                }
            } else if (sQLFragment instanceof SQLFragmentWithDatatype && (dBObjectID = (sQLFragmentWithDatatype = (SQLFragmentWithDatatype)sQLFragment).getDataTypeID()) != null) {
                DBObject dBObject;
                try {
                    dBObject = dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    dBObject = null;
                }
                if (dBObject instanceof DataType) {
                    dataTypeUsage = ((DataType)dBObject).createDefaultUsage();
                } else {
                    dataTypeUsage = new DataTypeUsage();
                    dataTypeUsage.setDataTypeID(dBObjectID);
                }
            }
            return dataTypeUsage;
        }

        public static List<Tuple<String, DataTypeUsage>> getColumnInfo(Database database, String string) throws DBException {
            final ArrayList arrayList = new ArrayList();
            final QueryWrapper queryWrapper = new QueryWrapper(database, SQLQueryViewColumnDTUBuilder.convertBindValues(string));
            queryWrapper.executeQuery(1, new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int n = resultSetMetaData.getColumnCount();
                        for (int i = 1; i < n + 1; ++i) {
                            arrayList.add(new ColumnMetadata(resultSetMetaData, i));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            });
            ArrayList<Tuple<String, DataTypeUsage>> arrayList2 = new ArrayList<Tuple<String, DataTypeUsage>>(arrayList.size());
            for (ColumnMetadata columnMetadata : arrayList) {
                DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsage((DBObjectProvider)database, null, (String)columnMetadata.m_typeName, (int)columnMetadata.m_size, (int)columnMetadata.m_precision, (int)columnMetadata.m_scale);
                arrayList2.add((Tuple<String, DataTypeUsage>)new Tuple((Object)columnMetadata.m_colName, (Object)dataTypeUsage));
            }
            return arrayList2;
        }

        private static String convertBindValues(String string) {
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            StringBuffer stringBuffer = new StringBuffer();
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                if (plSqlToken.matches(":") && ((PlSqlToken)plSqlToken.getNextToken()).isCode()) {
                    stringBuffer.append(BIND_DEFAULT);
                    plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
                } else {
                    stringBuffer.append(plSqlToken.getSource());
                }
                plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            }
            return stringBuffer.toString().trim();
        }

        private static class ColumnMetadata {
            private final String m_colName;
            private final String m_typeName;
            private final int m_precision;
            private final int m_scale;
            private final int m_size;

            ColumnMetadata(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
                this.m_colName = resultSetMetaData.getColumnName(n);
                this.m_typeName = resultSetMetaData.getColumnTypeName(n);
                this.m_precision = resultSetMetaData.getPrecision(n);
                this.m_scale = resultSetMetaData.getScale(n);
                this.m_size = this.m_precision;
            }
        }
    }

    public static class SQLQueryColumnsBuilder
    extends DerivedPropertyBuilder<Relation> {
        private final DBObjectSet<Column> m_colCache = new DBObjectSet();

        public SQLQueryColumnsBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
            super(abstractDBObjectProvider, string);
        }

        protected boolean canCacheBuildFailure(Relation relation, String string) {
            return false;
        }

        public Collection<String> clearDerivedProperties(Relation relation, String string, DBObjectChange dBObjectChange) {
            if (!DBUtil.needsBuilding((DBObject)relation, (String)"columns")) {
                for (Column column : relation.getColumns()) {
                    this.m_colCache.add((Object)column);
                }
            }
            return super.clearDerivedProperties((AbstractBuildableObject)relation, string, dBObjectChange);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
        public void buildColumns(Relation relation) throws SQLQueryException {
            block19: {
                ArrayList<AbstractSQLQueryBuilder> arrayList = new ArrayList<AbstractSQLQueryBuilder>();
                try {
                    AbstractSQLQueryBuilder abstractSQLQueryBuilder;
                    SQLQueryBuilder sQLQueryBuilder;
                    SQLQuery sQLQuery;
                    Column[] columnArray = null;
                    Column[] columnArray2 = null;
                    List list = null;
                    List list2 = null;
                    if (relation instanceof SQLQueryOwner && (sQLQuery = ((SQLQueryOwner)relation).getSQLQuery()) != null && (sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                        try {
                            abstractSQLQueryBuilder = (AbstractSQLQueryBuilder)sQLQueryBuilder;
                            columnArray = abstractSQLQueryBuilder.getColumns();
                            list = abstractSQLQueryBuilder.getQueryColumnInfos();
                        }
                        catch (SQLQueryException sQLQueryException) {
                            list = null;
                        }
                    }
                    if (columnArray == null) break block19;
                    boolean bl = false;
                    for (int i = 0; i < columnArray.length; ++i) {
                        if (columnArray[i].getName() != null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        Column column;
                        Relation relation2 = (Relation)TemporaryObjectID.findOriginalObject((DBObject)relation);
                        if (relation2 instanceof SQLQueryOwner) {
                            Iterator iterator;
                            columnArray2 = relation2.getColumns();
                            abstractSQLQueryBuilder = ((SQLQueryOwner)relation2).getSQLQuery();
                            if (abstractSQLQueryBuilder != null && (iterator = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)abstractSQLQueryBuilder, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                                try {
                                    column = (AbstractSQLQueryBuilder)iterator;
                                    list2 = column.getQueryColumnInfos();
                                }
                                catch (SQLQueryException sQLQueryException) {
                                    list2 = null;
                                }
                            }
                        }
                        if (columnArray2 != null && list2 != null) {
                            abstractSQLQueryBuilder = new PlSqlComparator();
                            block10: for (int i = 0; i < columnArray.length; ++i) {
                                if (columnArray[i].getName() != null) continue;
                                column = (AbstractSQLQueryBuilder.QueryColumnInfo)list.get(i);
                                for (int j = 0; j < list2.size(); ++j) {
                                    AbstractSQLQueryBuilder.QueryColumnInfo queryColumnInfo = (AbstractSQLQueryBuilder.QueryColumnInfo)list2.get(j);
                                    if (queryColumnInfo.getName() != null || abstractSQLQueryBuilder.compare(column.getExpression(), queryColumnInfo.getExpression()) != 0) continue;
                                    columnArray[i].setName(columnArray2[j].getName());
                                    continue block10;
                                }
                            }
                        }
                    }
                    for (int i = 0; i < columnArray.length; ++i) {
                        abstractSQLQueryBuilder = columnArray[i];
                        for (Column column : this.m_colCache) {
                            if (column.getName() == null || !column.getName().equals(abstractSQLQueryBuilder.getName())) continue;
                            abstractSQLQueryBuilder = column;
                            this.m_colCache.remove((Object)column);
                            break;
                        }
                        arrayList.add(abstractSQLQueryBuilder);
                    }
                }
                catch (DBException dBException) {
                    arrayList.clear();
                    this.getLogger().warning(dBException.getMessage());
                }
                finally {
                    relation.setColumns(arrayList.toArray(new Column[arrayList.size()]));
                    this.m_colCache.clear();
                }
            }
            this.maintainConstraints(relation);
        }

        private void maintainConstraints(Relation relation) {
            Constraint[] constraintArray = relation.getConstraints();
            if (constraintArray != null && constraintArray.length > 0) {
                DBObjectSet dBObjectSet = relation.getColumns();
                HashSet<String> hashSet = new HashSet<String>();
                for (Column column : dBObjectSet) {
                    hashSet.add(column.getName());
                }
                DBObjectSet dBObjectSet2 = new DBObjectSet();
                for (Constraint constraint : constraintArray) {
                    if (constraint instanceof ColumnConstraint) {
                        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
                        for (DBObjectID dBObjectID : ((ColumnConstraint)constraint).getColumnIDs()) {
                            if (!hashSet.contains(DBUtil.getDBObjectName((DBObjectID)dBObjectID))) continue;
                            arrayList.add(dBObjectID);
                        }
                        if (arrayList.size() <= 0) continue;
                        ((ColumnConstraint)constraint).setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
                        dBObjectSet2.add(constraint);
                        continue;
                    }
                    dBObjectSet2.add(constraint);
                }
                relation.setConstraints(dBObjectSet2.toArray(new Constraint[dBObjectSet2.size()]));
            }
        }
    }

    static class DerivedFromColumnsBuilder<T extends AbstractBuildableObject>
    extends DerivedPropertyBuilder<T> {
        DerivedFromColumnsBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
            super(abstractDBObjectProvider, string);
        }

        protected Object getFailureCacheValue(T t, String string) {
            Relation relation;
            Object object = super.getFailureCacheValue(t, string);
            if (object instanceof String && (relation = (Relation)DBUtil.findParentOfType(t, Relation.class)) != null) {
                Column[] columnArray = relation.getColumns();
                Object[] objectArray = new String[columnArray.length];
                for (int i = 0; i < columnArray.length; ++i) {
                    String string2 = columnArray[i].getName();
                    if (string2 != null) {
                        string2 = string2.replace(",", ",,");
                    }
                    objectArray[i] = string2;
                }
                Arrays.sort(objectArray);
                object = (String)object + Arrays.toString(objectArray);
            }
            return object;
        }
    }
}

