/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class DirectoryValidator
extends SchemaObjectValidator<Directory> {
    public DirectoryValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"path"})
    public void validatePath(Directory directory, Directory directory2) throws ValidationException {
        String string = directory2.getPath();
        if (!ModelUtil.hasLength((String)string)) {
            throw new ValidationException((DBObject)directory2, "Directory must have a valid path.");
        }
    }

    @DBObjectValidator.PropertyValidator(value={"schema"})
    public void validateSchema(Directory directory, Directory directory2) throws ValidationException {
        super.validateSchema((SchemaObject)directory, (SchemaObject)directory2);
        Schema schema = directory2.getSchema();
        if (schema != null && ModelUtil.areDifferent((Object)schema.getName(), (Object)"SYS")) {
            throw new ValidationException((DBObject)directory2, "Directory must be in SYS schema.");
        }
    }
}

