/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataFieldsBuilder;
import oracle.javatools.db.ora.bigdata.BigDataJsonValueBuilder;
import oracle.javatools.db.ora.bigdata.BigDataTablePropertiesBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class BigDataAccessParameterBuilder
extends DerivedPropertyBuilder<BigDataAccessParameter> {
    private final Map<String, ValueBuilder> m_builders = new HashMap<String, ValueBuilder>();

    public BigDataAccessParameterBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
        super(abstractDBObjectProvider, "BigDataAccessParameter");
        BigDataJsonValueBuilder bigDataJsonValueBuilder = new BigDataJsonValueBuilder();
        this.m_builders.put("com.oracle.bigdata.colmap", bigDataJsonValueBuilder);
        this.m_builders.put("com.oracle.bigdata.datemask", bigDataJsonValueBuilder);
        this.m_builders.put("com.oracle.bigdata.maxlen", bigDataJsonValueBuilder);
        this.m_builders.put("com.oracle.bigdata.overflow", bigDataJsonValueBuilder);
        this.m_builders.put("com.oracle.bigdata.erroropt", bigDataJsonValueBuilder);
        this.m_builders.put("com.oracle.bigdata.fields", new BigDataFieldsBuilder());
        this.m_builders.put("com.oracle.bigdata.tblproperties", new BigDataTablePropertiesBuilder());
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"parameterValueFragment"})
    public void buildValue(BigDataAccessParameter bigDataAccessParameter) throws DBException {
        ValueBuilder valueBuilder;
        String string = bigDataAccessParameter.getName();
        if (ModelUtil.hasLength((String)bigDataAccessParameter.getParameterValue()) && (valueBuilder = this.m_builders.get(string)) != null) {
            valueBuilder.buildFragment(bigDataAccessParameter);
        }
    }

    static abstract class ValueBuilder {
        ValueBuilder() {
        }

        public abstract void buildFragment(BigDataAccessParameter var1) throws DBException;

        protected final int findMatchingSingleQuote(BigDataAccessParameter bigDataAccessParameter, String string, int n) throws DBException {
            int n2 = string.indexOf(39, n + 1);
            if (n2 <= 0) {
                throw new DBException((DBObject)bigDataAccessParameter, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_UNMATCHED", (Object[])new Object[]{Character.valueOf('\'')}));
            }
            return n2;
        }

        protected final int findMatchingDoubleQuote(BigDataAccessParameter bigDataAccessParameter, String string, int n) throws DBException {
            int n2 = -1;
            for (int i = n + 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '\"') continue;
                if (string.charAt(i - 1) != '\\') {
                    // empty if block
                }
                n2 = i;
                break;
            }
            if (n2 <= 0) {
                throw new DBException((DBObject)bigDataAccessParameter, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_UNMATCHED", (Object[])new Object[]{Character.valueOf('\"')}));
            }
            return n2;
        }

        protected final String stripAndTrimParentheses(String string) {
            if (ModelUtil.hasLength((String)string)) {
                boolean bl;
                string = BigDataAccessParameterMetadata.stripLineEscapes((String)string).trim();
                int n = string.length();
                boolean bl2 = string.charAt(0) == '(';
                boolean bl3 = bl = string.charAt(n - 1) == ')';
                if (bl2 || bl) {
                    string = string.substring(bl2 ? 1 : 0, bl ? n - 1 : n);
                    string = string.trim();
                }
            }
            return string;
        }
    }
}

