/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.Version;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle11gR2XE;
import oracle.javatools.db.ora.Oracle122DatabaseDescriptor;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle12cDWCS;
import oracle.javatools.db.ora.Oracle12cR2;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.ora.lite.OracleDatabaseLiteDescriptor;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleDatabaseFactory
extends BaseDatabaseCreator {
    private static boolean s_autocommit = true;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";
    private static final DatabaseRegistry.DatabaseVersion[] s_versions;
    private static final DatabaseRegistry.DatabaseVersion[] s_liteVersions;
    private static final NavigableMap<Version, Integer> s_knownVersions;

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database database) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = database instanceof OracleDatabaseLite ? new OracleDatabaseLiteDescriptor(database.getDatabaseVersion()) : (database instanceof Oracle12cR2 ? new Oracle122DatabaseDescriptor(database.getDatabaseVersion()) : (database instanceof OracleDatabase ? new OracleDatabaseDescriptor(database.getDatabaseVersion()) : null));
        return oracleDatabaseDescriptor;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(String string, int n) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = "Oracle Lite".equals(string) ? new OracleDatabaseLiteDescriptor(n) : ("Oracle Database".equals(string) ? (1220 >= n ? new Oracle122DatabaseDescriptor(n) : new OracleDatabaseDescriptor(n)) : null);
        return oracleDatabaseDescriptor;
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = null;
        if (OracleDatabaseLite.class.isAssignableFrom(clazz)) {
            oracleDatabaseDescriptor = new OracleDatabaseLiteDescriptor(clazz);
        } else if (Oracle12cR2.class.isAssignableFrom(clazz)) {
            oracleDatabaseDescriptor = new Oracle122DatabaseDescriptor(clazz);
        } else if (OracleDatabase.class.isAssignableFrom(clazz)) {
            oracleDatabaseDescriptor = new OracleDatabaseDescriptor(clazz);
        }
        return oracleDatabaseDescriptor;
    }

    public Database createDatabaseImpl(String string, String string2, Connection connection) {
        BaseOracleDatabase baseOracleDatabase = null;
        Tuple<String, Integer> tuple = OracleDatabaseFactory.getType(connection);
        if (tuple != null) {
            Integer n = (Integer)tuple.getSecond();
            if ("Oracle Lite".equals(tuple.getFirst())) {
                switch (n) {
                    case 101: {
                        baseOracleDatabase = new OracleLite(string, string2, connection, n);
                        break;
                    }
                    case 103: {
                        baseOracleDatabase = new OracleLite10gR3(string, string2, connection, n);
                    }
                }
            } else {
                switch (n) {
                    case 81: {
                        baseOracleDatabase = new Oracle8(string, string2, connection, n);
                        break;
                    }
                    case 82: {
                        baseOracleDatabase = new Oracle8i(string, string2, connection, n);
                        break;
                    }
                    case 91: {
                        baseOracleDatabase = new Oracle9i(string, string2, connection, n);
                        break;
                    }
                    case 92: {
                        baseOracleDatabase = new Oracle9iR2(string, string2, connection, n);
                        break;
                    }
                    case 100: {
                        baseOracleDatabase = new Oracle10g(string, string2, connection, n);
                        break;
                    }
                    case 102: {
                        baseOracleDatabase = new Oracle10gR2(string, string2, connection, n);
                        break;
                    }
                    case 101: {
                        baseOracleDatabase = new Oracle10gR2XE(string, string2, connection, n);
                        break;
                    }
                    case 110: {
                        baseOracleDatabase = new Oracle11g(string, string2, connection, n);
                        break;
                    }
                    case 112: {
                        baseOracleDatabase = new Oracle11gR2(string, string2, connection, n);
                        break;
                    }
                    case 111: {
                        baseOracleDatabase = new Oracle11gR2XE(string, string2, connection, n);
                        break;
                    }
                    case 120: 
                    case 1210: {
                        baseOracleDatabase = new Oracle12c(string, string2, connection, n);
                        break;
                    }
                    case 1220: {
                        baseOracleDatabase = new Oracle12cR2(string, string2, connection, n);
                        break;
                    }
                    case 1221: {
                        baseOracleDatabase = new Oracle12cDWCS(string, string2, connection, n);
                    }
                }
            }
        }
        if (baseOracleDatabase != null) {
            this.initDB((Database)baseOracleDatabase);
        }
        return baseOracleDatabase;
    }

    private void initDB(Database database) {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(database, APIBundle.get((String)"SET_AUTOCOMMIT"));
        try {
            connectionWrapper.run(new ConnectionWrapper.SQLRunnable(connectionWrapper){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(s_autocommit);
                }
            });
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)((Object)this)).warning(dBException.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean bl) {
        s_autocommit = bl;
    }

    public static boolean isDefaultAutocommit() {
        return s_autocommit;
    }

    public static boolean isOracleDatabase(Connection connection) {
        return OracleDatabaseFactory.getType(connection) != null;
    }

    private static boolean isExpressEdition(String string) {
        return string.indexOf("Express Edition") >= 0;
    }

    private static String getCloudService(Connection connection) {
        Holder holder;
        block3: {
            holder = new Holder(null);
            QueryWrapper queryWrapper = new QueryWrapper("CloudServiceQuery", connection, "SELECT /*OracleDictionaryQueries.CLOUD_SERVICE_QUERY*/ SYS_CONTEXT('USERENV', 'CLOUD_SERVICE') AS SERVICE_ID FROM DUAL", new Object[0]);
            try {
                queryWrapper.executeQuery(resultSet -> {
                    if (resultSet.next()) {
                        holder.set((Object)resultSet.getString(1));
                    }
                });
            }
            catch (DBException dBException) {
                int n;
                boolean bl = true;
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException && (n = ((SQLException)throwable).getErrorCode()) == 2003) {
                    bl = false;
                }
                if (!bl) break block3;
                DBLog.getLogger(OracleDatabaseFactory.class).severe(dBException.getMessage());
            }
        }
        return (String)holder.get();
    }

    private static Tuple<String, Integer> getType(Connection connection) {
        Tuple tuple = null;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (ModelUtil.hasLength((String)string)) {
                    if (string.startsWith("Oracle Lite") || string.startsWith("Oracle9i Lite")) {
                        String string2 = databaseMetaData.getDatabaseProductVersion();
                        Version version = OracleDatabaseFactory.getOracleVersion(string2);
                        int n = 101;
                        if (version != null && version.compareTo(OracleDatabaseLite.OLITE_10GR3_VERSION) >= 0) {
                            n = 103;
                        }
                        tuple = new Tuple((Object)"Oracle Lite", (Object)n);
                    } else if (string.startsWith("Personal Oracle") || string.startsWith("Oracle") && !string.startsWith("Oracle Rdb") && !string.startsWith("Oracle Business Intelligence")) {
                        int n = 0;
                        String string3 = databaseMetaData.getDatabaseProductVersion();
                        Version version = OracleDatabaseFactory.getOracleVersion(string3);
                        if (version != null) {
                            Map.Entry<Version, Integer> entry = s_knownVersions.floorEntry(version);
                            if (entry == null) {
                                n = 0;
                            } else {
                                n = entry.getValue();
                                if (OracleDatabaseFactory.isExpressEdition(string3)) {
                                    if (n == 102) {
                                        n = 101;
                                    } else if (n == 112) {
                                        n = 111;
                                    }
                                } else if (1220 == n) {
                                    // empty if block
                                }
                            }
                        }
                        tuple = new Tuple((Object)"Oracle Database", (Object)n);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return tuple;
    }

    public static Version getOracleVersion(String string) {
        Version version = null;
        if (ModelUtil.hasLength((String)string)) {
            String string2;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(string);
            String string3 = string2 = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)string2)) {
                version = new Version(string2);
            }
        }
        return version;
    }

    public static void registerOracleDatabases() {
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getInstance();
        databaseRegistry.registerDatabases("Oracle Lite", OracleDatabaseFactory.class.getName(), null, null, s_liteVersions);
        databaseRegistry.registerDatabases("Oracle Database", OracleDatabaseFactory.class.getName(), null, null, s_versions);
        Metadata metadata = Metadata.getInstance();
        metadata.registerBooleanProperty("OBJECT TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerBooleanProperty("NESTED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerBooleanProperty("PARTITIONED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerProperty("USER_PRIVS", String[].class, OracleDatabase.class, new Class[]{Schema.class});
        metadata.registerProperty("USER_ROLES", String[].class, OracleDatabase.class, new Class[]{Schema.class});
        ColumnSequenceProcessor.registerProcessorProperties(OracleDatabaseImpl.class);
    }

    static Class<? extends OracleDatabase> getDatabaseClass(int n) {
        Class<?> clazz = null;
        for (DatabaseRegistry.DatabaseVersion databaseVersion : s_versions) {
            if (n != databaseVersion.getVersion()) continue;
            try {
                ClassLoader classLoader = OracleDatabaseFactory.class.getClassLoader();
                clazz = classLoader.loadClass(databaseVersion.getDatabaseClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                DBLog.getLogger(OracleDatabaseFactory.class).severe(classNotFoundException.getMessage());
            }
            break;
        }
        return clazz;
    }

    static int getDatabaseVersion(Class<? extends OracleDatabase> clazz) {
        DatabaseRegistry.DatabaseVersion[] databaseVersionArray;
        int n = 0;
        for (DatabaseRegistry.DatabaseVersion databaseVersion : databaseVersionArray = OracleDatabaseLite.class.isAssignableFrom(clazz) ? s_liteVersions : s_versions) {
            if (!clazz.getName().equals(databaseVersion.getDatabaseClassName())) continue;
            n = databaseVersion.getVersion();
            break;
        }
        return n;
    }

    static {
        s_liteVersions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_LITE_10gR1"), "oracle.javatools.db.ora.OracleLite", true), new DatabaseRegistry.DatabaseVersion(103, APIBundle.get((String)"DB_ORACLE_LITE_10gR3"), "oracle.javatools.db.ora.OracleLite10gR3", true)};
        s_versions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(0, null, "oracle.javatools.db.ora.OracleDatabaseImpl"), new DatabaseRegistry.DatabaseVersion(81, null, "oracle.javatools.db.ora.Oracle8"), new DatabaseRegistry.DatabaseVersion(82, APIBundle.get((String)"DB_ORACLE_8i"), "oracle.javatools.db.ora.Oracle8i", true), new DatabaseRegistry.DatabaseVersion(91, null, "oracle.javatools.db.ora.Oracle9i"), new DatabaseRegistry.DatabaseVersion(92, APIBundle.get((String)"DB_ORACLE_9i2"), "oracle.javatools.db.ora.Oracle9iR2"), new DatabaseRegistry.DatabaseVersion(100, APIBundle.get((String)"DB_ORACLE_10g"), "oracle.javatools.db.ora.Oracle10g"), new DatabaseRegistry.DatabaseVersion(102, APIBundle.get((String)"DB_ORACLE_10gR2"), "oracle.javatools.db.ora.Oracle10gR2"), new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_10gR2XE"), "oracle.javatools.db.ora.Oracle10gR2XE"), new DatabaseRegistry.DatabaseVersion(110, APIBundle.get((String)"DB_ORACLE_11g"), "oracle.javatools.db.ora.Oracle11g"), new DatabaseRegistry.DatabaseVersion(112, APIBundle.get((String)"DB_ORACLE_11gR2"), "oracle.javatools.db.ora.Oracle11gR2"), new DatabaseRegistry.DatabaseVersion(111, APIBundle.get((String)"DB_ORACLE_11gR2XE"), "oracle.javatools.db.ora.Oracle11gR2XE"), new DatabaseRegistry.DatabaseVersion(120, APIBundle.get((String)"DB_ORACLE_12c"), "oracle.javatools.db.ora.Oracle12c"), new DatabaseRegistry.DatabaseVersion(1210, APIBundle.get((String)"DB_ORACLE_12cR102"), "oracle.javatools.db.ora.Oracle12c"), new DatabaseRegistry.DatabaseVersion(1220, APIBundle.get((String)"DB_ORACLE_12cR201"), "oracle.javatools.db.ora.Oracle12cR2"), new DatabaseRegistry.DatabaseVersion(1221, APIBundle.get((String)"DB_ORACLE_12cR201_DWCS"), "oracle.javatools.db.ora.Oracle12cDWCS")};
        s_knownVersions = new TreeMap<Version, Integer>();
        s_knownVersions.put(OracleDatabase.ORACLE_VERSION, 0);
        s_knownVersions.put(OracleDatabase.ORACLE8_VERSION, 81);
        s_knownVersions.put(OracleDatabase.ORACLE8i_VERSION, 82);
        s_knownVersions.put(OracleDatabase.ORACLE9i_VERSION, 91);
        s_knownVersions.put(OracleDatabase.ORACLE9iR2_VERSION, 92);
        s_knownVersions.put(OracleDatabase.ORACLE10g_VERSION, 100);
        s_knownVersions.put(OracleDatabase.ORACLE10gR2_VERSION, 102);
        s_knownVersions.put(OracleDatabase.ORACLE11g_VERSION, 110);
        s_knownVersions.put(OracleDatabase.ORACLE11gR2_VERSION, 112);
        s_knownVersions.put(OracleDatabase.ORACLE12c_VERSION, 120);
        s_knownVersions.put(OracleDatabase.ORACLE12cR1_VERSION, 1210);
        s_knownVersions.put(OracleDatabase.ORACLE12cR2_VERSION, 1220);
    }
}

