/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDDLGenerator;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ViewValidator;

public class JdbcDatabaseDescriptor
extends BaseDatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 500;
    private static final char QUOTE_IDENTIFIER = '\'';
    private String m_quoteIdent;
    private int m_casePolicy = -1;
    private Database m_db;

    public JdbcDatabaseDescriptor(Class<? extends Database> clazz) {
        super(clazz);
    }

    public JdbcDatabaseDescriptor(Database database) {
        this(database.getClass());
        this.m_db = database;
    }

    public int getCasePolicy() {
        Connection connection;
        if (this.m_casePolicy < 0 && this.m_db != null && (connection = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                boolean bl = databaseMetaData.storesLowerCaseIdentifiers();
                boolean bl2 = databaseMetaData.storesLowerCaseQuotedIdentifiers();
                boolean bl3 = databaseMetaData.storesMixedCaseIdentifiers();
                boolean bl4 = databaseMetaData.storesMixedCaseQuotedIdentifiers();
                boolean bl5 = databaseMetaData.storesUpperCaseIdentifiers();
                boolean bl6 = databaseMetaData.storesUpperCaseQuotedIdentifiers();
                this.m_casePolicy = bl ? 1 : (bl5 ? 2 : 0);
            }
            catch (SQLException sQLException) {
                this.getLogger().log(Level.WARNING, "Could not get case policy for {0}: {1}", new Object[]{this.m_db.getConnectionName(), sQLException.getMessage()});
            }
        }
        return this.m_casePolicy < 0 ? 0 : this.m_casePolicy;
    }

    public String getIdentifierQuoteString() {
        Connection connection;
        if (this.m_db != null && this.m_quoteIdent == null && (connection = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.m_quoteIdent = databaseMetaData.getIdentifierQuoteString();
            }
            catch (SQLException sQLException) {
                this.getLogger().log(Level.WARNING, "Could not get quote string for {0}: {1}", new Object[]{this.m_db.getConnectionName(), sQLException.getMessage()});
            }
        }
        return this.m_quoteIdent == null ? String.valueOf('\'') : this.m_quoteIdent;
    }

    public int getMaxNameLength(String string) {
        return 500;
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        JdbcDatabaseDescriptor.validateIdentifier((String)string2, (char)'\'', (int)500, null, (boolean)true, null, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("VIEW", (DBObjectValidator)new ViewValidator(dBObjectProvider));
        return map;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new JdbcDDLGenerator(dBObjectProvider);
    }

    public boolean isCompatibleWith(DatabaseDescriptor databaseDescriptor) {
        boolean bl = DataTypeRegistry.isGenericJdbcClass((Class)this.getDatabaseClass()) ? false : super.isCompatibleWith(databaseDescriptor);
        return bl;
    }

    public String getDatabaseType() {
        return "Generic JDBC";
    }

    public int getDatabaseVersion() {
        return 0;
    }

    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new OracleSQLQueryBuilderFactory();
    }

    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        if (this.getDatabaseType().equals("Generic JDBC") && this.getDatabaseVersion() == 0) {
            for (Field field : JdbcDatabase.class.getDeclaredFields()) {
                try {
                    if (!field.getName().startsWith("ANSI_") || !Modifier.isStatic(field.getModifiers()) || !DataType.class.equals(field.getType())) continue;
                    DataType dataType = (DataType)field.get(null);
                    if (dataType instanceof PredefinedDataType) {
                        dataTypeCache.registerDataTypeResource((PredefinedDataType)dataType);
                        continue;
                    }
                    if (!(dataType instanceof DataTypeSynonym)) continue;
                    dataTypeCache.registerDataType(dataType);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace((String)field.getName(), (Throwable)exception);
                }
            }
        }
    }
}

