/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.SQLException;
import java.util.Optional;
import net.ucanaccess.log.ILoggerResourceMessage;
import net.ucanaccess.log.Logger;

public class UcanaccessSQLException
extends SQLException {
    static final String MSG_PREFIX = "UCAExc:";
    private static final long serialVersionUID = -1432048647665807662L;
    private static final String UCANACCESS_GENERIC_ERROR_STR = String.valueOf(15000);

    public UcanaccessSQLException() {
    }

    public UcanaccessSQLException(String _reason, String _sqlState, int _vendorCode, Throwable _cause) {
        super(_reason, _sqlState, _vendorCode, _cause);
    }

    public UcanaccessSQLException(ExceptionMessages _reason) {
        this(Logger.getMessage(_reason, new Object[0]), UCANACCESS_GENERIC_ERROR_STR, 15000, null);
    }

    public UcanaccessSQLException(ExceptionMessages _reason, Object ... _args) {
        this(Logger.getMessage(_reason, _args), UCANACCESS_GENERIC_ERROR_STR, 15000, null);
    }

    public UcanaccessSQLException(String _reason, String _sqlState, int _vendorCode) {
        super(_reason == null ? null : Logger.getMessage(_reason, new Object[0]), _sqlState, _vendorCode, null);
    }

    public UcanaccessSQLException(String _reason, String _sqlState, Throwable _cause) {
        super(_reason == null ? null : Logger.getMessage(_reason, new Object[0]), _sqlState, 15000, _cause);
    }

    public UcanaccessSQLException(String _reason, Throwable _cause) {
        super(_reason == null ? null : Logger.getMessage(_reason, new Object[0]), UCANACCESS_GENERIC_ERROR_STR, 15000, _cause);
    }

    public UcanaccessSQLException(String _reason, String _sqlState) {
        super(_reason == null ? null : Logger.getMessage(_reason, new Object[0]), _sqlState, 15000, null);
    }

    public UcanaccessSQLException(Throwable _cause) {
        super(UcanaccessSQLException.explainCause(_cause), _cause instanceof SQLException ? ((SQLException)_cause).getSQLState() : UCANACCESS_GENERIC_ERROR_STR, _cause instanceof SQLException ? ((SQLException)_cause).getErrorCode() : 15000, _cause);
    }

    public static String explainCause(Throwable _cause) {
        SQLException se;
        if (_cause instanceof SQLException && (se = (SQLException)_cause).getErrorCode() == -5562) {
            return _cause.getMessage() + " " + Logger.getMessage(ExceptionMessages.INVALID_TYPES_IN_COMBINATION, new Object[0]);
        }
        return _cause.getMessage();
    }

    String addVersionInfo(String _message) {
        if (_message != null && _message.startsWith(MSG_PREFIX)) {
            return _message;
        }
        return "UCAExc:::" + Optional.ofNullable(this.getClass().getPackage().getImplementationVersion()).orElse("5.1.0") + " " + (_message == null || _message.isBlank() ? "(n/a)" : _message.trim());
    }

    @Override
    public String getLocalizedMessage() {
        return this.addVersionInfo(super.getLocalizedMessage());
    }

    @Override
    public String getMessage() {
        return this.addVersionInfo(super.getMessage());
    }

    public static final <T extends Throwable> UcanaccessSQLException wrap(T _t) {
        return UcanaccessSQLException.class.isInstance(_t) ? (UcanaccessSQLException)UcanaccessSQLException.class.cast(_t) : new UcanaccessSQLException(_t);
    }

    public static enum ExceptionMessages implements ILoggerResourceMessage
    {
        CONCURRENT_PROCESS_ACCESS,
        INVALID_CREATE_STATEMENT,
        INVALID_INTERVAL_VALUE,
        INVALID_JACKCESS_OPENER,
        INVALID_MONTH_NUMBER,
        NOT_A_VALID_PASSWORD,
        ONLY_IN_MEMORY_ALLOWED,
        UNPARSABLE_DATE,
        COMPLEX_TYPE_UNSUPPORTED,
        INVALID_PARAMETER,
        INVALID_TYPES_IN_COMBINATION,
        UNSUPPORTED_TYPE,
        STATEMENT_DDL,
        CLOSE_ON_COMPLETION_STATEMENT,
        ACCESS_97,
        PARAMETER_NULL,
        TABLE_DOES_NOT_EXIST,
        DEFAULT_NEEDED;

    }
}

