/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.extension;

import java.io.BufferedOutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.worksheet.commands.scriptrunner.api.AStatementRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptRunnerProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.task.executor.DefaultStatementExecutorTask;
import oracle.dbtools.worksheet.scriptparser.api.IScriptParser;
import oracle.dbtools.worksheet.scriptparser.sqlplus.SQLPlusScriptParser;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class ScriptRunnerHook {
    private static Logger m_logger = Logger.getLogger(ScriptRunnerHook.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-scriptrunner-hook";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-scriptrunner-hook", "sqldev-scriptrunner-hook");
    private static List<IScriptConsumer> m_consumers = null;

    private static Iterator<MetaClass<? extends IScriptRunnerProvider>> getProviders() {
        return Adapter.getInstance().getProviders();
    }

    public static List<IScriptConsumer> getConsumers() {
        if (m_consumers == null) {
            m_consumers = new ArrayList<IScriptConsumer>();
            for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
                IScriptConsumer iScriptConsumer = iScriptRunnerProvider.getConsumer();
                if (iScriptConsumer == null) continue;
                m_consumers.add(iScriptConsumer);
            }
        }
        return m_consumers;
    }

    public static boolean isExecutor(ScriptRunnerContext scriptRunnerContext) {
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isExecutable(scriptRunnerContext)) continue;
            return true;
        }
        return false;
    }

    public static AStatementRunnerTask getStatementExecutorTask(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream, ScriptRunnerContext scriptRunnerContext, Connection connection) {
        AStatementRunnerTask aStatementRunnerTask = null;
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isExecutable(scriptRunnerContext)) continue;
            aStatementRunnerTask = iScriptRunnerProvider.getStatementExecutor(iSQLCommand, bufferedOutputStream, scriptRunnerContext, connection);
            break;
        }
        if (aStatementRunnerTask == null) {
            aStatementRunnerTask = new DefaultStatementExecutorTask(iSQLCommand, bufferedOutputStream, scriptRunnerContext, connection);
        }
        return aStatementRunnerTask;
    }

    public static IScriptParser getScriptParser(ScriptRunnerContext scriptRunnerContext, Reader reader) {
        IScriptParser iScriptParser = null;
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isParsable(scriptRunnerContext)) continue;
            iScriptParser = iScriptRunnerProvider.getParser(reader);
            break;
        }
        if (iScriptParser == null) {
            iScriptParser = new SQLPlusScriptParser(reader);
        }
        return iScriptParser;
    }

    private static List<IScriptRunnerProvider> getInstantiatedProviders() {
        ArrayList<IScriptRunnerProvider> arrayList = new ArrayList<IScriptRunnerProvider>();
        Iterator<MetaClass<? extends IScriptRunnerProvider>> iterator = ScriptRunnerHook.getProviders();
        while (iterator.hasNext()) {
            try {
                IScriptRunnerProvider iScriptRunnerProvider = (IScriptRunnerProvider)iterator.next().newInstance();
                arrayList.add(iScriptRunnerProvider);
            }
            catch (IllegalAccessException illegalAccessException) {
                m_logger.log(Level.SEVERE, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                m_logger.log(Level.SEVERE, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                m_logger.log(Level.SEVERE, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }
        return arrayList;
    }

    private static final class Adapter
    extends HashStructureAdapter {
        private static final String DESCRIPTOR_TEXT = "#text";

        private Adapter(HashStructure hashStructure) {
            super(hashStructure);
        }

        static Adapter getInstance() {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            return new Adapter(hashStructureHook.getHashStructure());
        }

        Iterator<MetaClass<? extends IScriptRunnerProvider>> getProviders() {
            ArrayList<MetaClass> arrayList = new ArrayList<MetaClass>();
            List list = this._hash.getAsList("provider");
            if (list != null) {
                for (HashStructure hashStructure : list) {
                    MetaClass metaClass = LazyClassAdapter.getInstance((HashStructure)this._hash).getMetaClass(DESCRIPTOR_TEXT);
                    arrayList.add(metaClass);
                }
            }
            return arrayList.iterator();
        }
    }
}

