/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.spatial.util.ByteOrder;
import oracle.spatial.util.ByteOrderBigEndian;
import oracle.spatial.util.ByteOrderLittleEndian;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.WKAdapter;
import oracle.spatial.util.WKBasis;
import oracle.spatial.util.WKInputStream;

public class WKB
extends WKBasis
implements WKAdapter {
    public WKB(ByteOrder byteOrder) {
        super(byteOrder);
    }

    public WKB() {
    }

    @Override
    protected WKInputStream getWKInputStream(byte[] byArray) {
        return new WKBInputStream(byArray);
    }

    @Override
    protected WKInputStream getWKInputStream(String string) {
        throw new RuntimeException("Unsuported method");
    }

    @Override
    protected void writeDouble(ByteOrder byteOrder, DataOutputStream dataOutputStream, double d) throws GeometryExceptionWithContext {
        byteOrder.writeDouble(dataOutputStream, d);
    }

    protected void writeUInt32(ByteOrder byteOrder, DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        byteOrder.writeUInt32(dataOutputStream, n);
    }

    @Override
    protected void writeByteOrder(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        if (this.m_defaultByteOrder instanceof ByteOrderBigEndian) {
            this.writeByte(dataOutputStream, 0);
        } else if (this.m_defaultByteOrder instanceof ByteOrderLittleEndian) {
            this.writeByte(dataOutputStream, 1);
        } else {
            throw new GeometryExceptionWithContext(null, "No default byte order has been specified.", null);
        }
    }

    @Override
    protected void writeLabel(DataOutputStream dataOutputStream, int n, int n2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        byteOrder.writeUInt32(dataOutputStream, n);
    }

    @Override
    protected void writeInnerLabel(DataOutputStream dataOutputStream, int n, int n2) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeCoordPairSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeGeometrySeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeXYSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeBeginningOfList(ByteOrder byteOrder, DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        byteOrder.writeUInt32(dataOutputStream, n);
    }

    @Override
    protected void writeBeginningOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeEndOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    @Override
    protected void writeByte(DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        try {
            dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            throw new GeometryExceptionWithContext(null, "IOException: " + iOException.toString(), null);
        }
    }

    protected class WKBInputStream
    implements WKInputStream {
        protected final DataInputStream m_is;
        protected int[] dimension = new int[1];

        public WKBInputStream(byte[] byArray) {
            this.m_is = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
            this.dimension[0] = 2;
        }

        @Override
        public int getOrdinatesSize() {
            return 1024;
        }

        @Override
        public double readDouble(ByteOrder byteOrder) {
            return byteOrder.readDouble(this.m_is);
        }

        protected int readUInt32(ByteOrder byteOrder) {
            return byteOrder.readUInt32(this.m_is);
        }

        @Override
        public void readStartList() {
        }

        @Override
        public int readStartList(ByteOrder byteOrder) {
            return this.readUInt32(byteOrder);
        }

        @Override
        public void readEndList() {
        }

        @Override
        public void readEndListOrSeparator() {
        }

        @Override
        public void readSeparator() {
        }

        @Override
        public int getDimensions() {
            return this.dimension[0];
        }

        @Override
        public int readLabel(ByteOrder byteOrder, int n) {
            return this.readUInt32(byteOrder);
        }

        @Override
        public int readInnerLabel() {
            return -1;
        }

        @Override
        public int readByte() throws GeometryExceptionWithContext {
            try {
                Byte by = this.m_is.readByte();
                return by.intValue();
            }
            catch (IOException iOException) {
                throw new GeometryExceptionWithContext(null, "IOException: " + iOException.toString(), null);
            }
        }

        @Override
        public ByteOrder readByteOrder() throws GeometryExceptionWithContext {
            try {
                byte by = this.m_is.readByte();
                switch (by) {
                    case 0: {
                        return ByteOrder.BIG_ENDIAN;
                    }
                    case 1: {
                        return ByteOrder.LITTLE_ENDIAN;
                    }
                }
                throw new GeometryExceptionWithContext(null, "Byte order can only be either BIG_ENDIAN (encoded as 0) or LITTLE_ENDIAN (encoded as 1). Found encoding " + by, null);
            }
            catch (IOException iOException) {
                throw new GeometryExceptionWithContext(null, "IOException: " + iOException.toString(), null);
            }
        }
    }
}

