/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.spatial.util.Hilbert;
import oracle.sql.BLOB;
import oracle.sql.STRUCT;

public class PcDiff {
    private static final long LONG_RUNNING_OP_PUBLISH_INTERVAL = 1000000L;

    private static OraclePreparedStatement prepareOutputTable(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return (OraclePreparedStatement)oracleConnection.prepareStatement("insert into " + string + " (\n  val_d1,\n  val_d2,\n  val_d3,\n  d)\nvalues (\n  :val_d1,\n  :val_d2,\n  :val_d3,\n  :d)");
    }

    private static void insertIntoOutputTable(OraclePreparedStatement oraclePreparedStatement, double d, double d2, double d3, long l) throws SQLException {
        try {
            oraclePreparedStatement.setDouble(1, d);
            oraclePreparedStatement.setDouble(2, d2);
            oraclePreparedStatement.setDouble(3, d3);
            oraclePreparedStatement.setLong(4, l);
            oraclePreparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            throw new RuntimeException("(" + d + ", " + d2 + ", " + d3 + ", " + l + ")", exception);
        }
    }

    public static void generatePcDiff(STRUCT sTRUCT, STRUCT sTRUCT2, long l, long l2, String string, String string2, String string3, String string4, String string5, String string6, double d, int n) throws SQLException {
        int n2 = -1;
        int n3 = -1;
        OracleConnection oracleConnection = sTRUCT.getInternalConnection();
        OraclePreparedStatement oraclePreparedStatement = PcDiff.prepareOutputTable((oracle.jdbc.OracleConnection)oracleConnection, string5);
        OraclePreparedStatement oraclePreparedStatement2 = PcDiff.prepareOutputTable((oracle.jdbc.OracleConnection)oracleConnection, string6);
        String string7 = null;
        String string8 = null;
        Vector<String> vector = new Vector<String>();
        Statement statement = oracleConnection.createStatement();
        statement.setFetchSize(10000);
        Statement statement2 = oracleConnection.createStatement();
        statement2.setFetchSize(10000);
        MyPCResultSet myPCResultSet = null;
        MyPCResultSet myPCResultSet2 = null;
        switch (string) {
            case "Flat": {
                string7 = string3;
                myPCResultSet = new MyFlatPCResultSet(statement, string7, l);
                break;
            }
            case "Hybrid Hilbert R-tree": {
                string7 = string3 + "$final";
                myPCResultSet = new MyFlatPCResultSet(statement, string7, l);
                break;
            }
            case "Hilbert R-tree": {
                string7 = string3;
                myPCResultSet = new MyBlockedPCResultSet(statement, string7, l);
                break;
            }
            default: {
                vector.add(string2 + " (pc A) not yet supported for PcDiff");
            }
        }
        switch (string2) {
            case "Flat": {
                string8 = string4;
                myPCResultSet2 = new MyFlatPCResultSet(statement2, string8, l2);
                break;
            }
            case "Hybrid Hilbert R-tree": {
                string8 = string4 + "$final";
                myPCResultSet2 = new MyFlatPCResultSet(statement2, string8, l2);
                break;
            }
            case "Hilbert R-tree": {
                string8 = string4;
                myPCResultSet2 = new MyBlockedPCResultSet(statement2, string8, l2);
                break;
            }
            default: {
                vector.add(string2 + " (pc B) not yet supported for PcDiff");
            }
        }
        if (vector.size() > 0) {
            throw new RuntimeException("Errors: " + vector.toString());
        }
        long l3 = myPCResultSet.getResultSize();
        long l4 = myPCResultSet2.getResultSize();
        boolean bl = true;
        boolean bl2 = true;
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray6[i] = 0.0;
            dArray5[i] = 0.0;
            dArray4[i] = 0.0;
            dArray3[i] = 0.0;
            dArray2[i] = 0.0;
            dArray[i] = 0.0;
            lArray2[i] = 0L;
            lArray[i] = 0L;
            blArray2[i] = true;
            blArray[i] = true;
        }
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l3 + l4;
        long[] lArray3 = PcDiff.prepareStatus((oracle.jdbc.OracleConnection)oracleConnection);
        OracleCallableStatement oracleCallableStatement = PcDiff.prepareLongOpPublishingCall((oracle.jdbc.OracleConnection)oracleConnection, string5 + " & " + string6);
        PcDiff.publishLongRunningOp(oracleCallableStatement, l6, l7, lArray3);
        while (bl || bl2) {
            int n4;
            if (l5 >= 0L) {
                if (bl) {
                    bl = myPCResultSet.next();
                    if (bl) {
                        ++l6;
                    }
                    if (l6 % 1000000L == 0L) {
                        PcDiff.publishLongRunningOp(oracleCallableStatement, l6, l7, lArray3);
                    }
                }
                if (bl) {
                    if (!blArray[n2 = (n2 + 1) % n]) {
                        PcDiff.insertIntoOutputTable(oraclePreparedStatement, dArray[n2], dArray2[n2], dArray3[n2], lArray[n2]);
                    }
                    myPCResultSet.readPtIntoBuffers(dArray, dArray2, dArray3, lArray, n2);
                    blArray[n2] = false;
                }
            }
            if (l5 <= 0L) {
                if (bl2) {
                    bl2 = myPCResultSet2.next();
                    if (bl2) {
                        ++l6;
                    }
                    if (l6 % 1000000L == 0L) {
                        PcDiff.publishLongRunningOp(oracleCallableStatement, l6, l7, lArray3);
                    }
                }
                if (bl2) {
                    if (!blArray2[n3 = (n3 + 1) % n]) {
                        PcDiff.insertIntoOutputTable(oraclePreparedStatement2, dArray4[n3], dArray5[n3], dArray6[n3], lArray2[n3]);
                    }
                    myPCResultSet2.readPtIntoBuffers(dArray4, dArray5, dArray6, lArray2, n3);
                    blArray2[n3] = false;
                }
            }
            if ((l5 = lArray2[n3] - lArray[n2]) >= 0L) {
                for (n4 = 0; n4 < n; ++n4) {
                    if (!(Math.sqrt((dArray[n2] - dArray4[n4]) * (dArray[n2] - dArray4[n4]) + (dArray2[n2] - dArray5[n4]) * (dArray2[n2] - dArray5[n4]) + (dArray3[n2] - dArray6[n4]) * (dArray3[n2] - dArray6[n4])) <= d)) continue;
                    blArray2[n4] = true;
                    blArray[n2] = true;
                }
            }
            if (l5 > 0L) continue;
            for (n4 = 0; n4 < n; ++n4) {
                if (!(Math.sqrt((dArray[n4] - dArray4[n3]) * (dArray[n4] - dArray4[n3]) + (dArray2[n4] - dArray5[n3]) * (dArray2[n4] - dArray5[n3]) + (dArray3[n4] - dArray6[n3]) * (dArray3[n4] - dArray6[n3])) <= d)) continue;
                blArray[n4] = true;
                blArray2[n3] = true;
            }
        }
        PcDiff.publishLongRunningOp(oracleCallableStatement, l6, l7, lArray3);
        myPCResultSet.close();
        statement.close();
        myPCResultSet2.close();
        statement2.close();
        oraclePreparedStatement.close();
        oraclePreparedStatement2.close();
    }

    private static long[] prepareStatus(oracle.jdbc.OracleConnection oracleConnection) {
        return new long[]{-1L, 0L};
    }

    private static OracleCallableStatement prepareLongOpPublishingCall(oracle.jdbc.OracleConnection oracleConnection, String string) {
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("call DBMS_APPLICATION_INFO.set_session_longops(\n  rindex      => :l_rindex,\n  slno        => :l_slno,\n  op_name     => 'PC_DIFF',\n  target      => 0,\n  context     => 0,\n  sofar       => :l_sofar,\n  totalwork   => :l_totalwork,\n  target_desc => :target_desc,\n  units       => 'rows')");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.registerOutParameter(2, 4);
            oracleCallableStatement.setString(5, string);
            return oracleCallableStatement;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private static void publishLongRunningOp(OracleCallableStatement oracleCallableStatement, long l, long l2, long[] lArray) {
        try {
            oracleCallableStatement.setLong(1, lArray[0]);
            oracleCallableStatement.setLong(2, lArray[1]);
            oracleCallableStatement.setLong(3, l);
            oracleCallableStatement.setLong(4, l2);
            System.out.print("qwerty publish [" + lArray[0] + ", " + lArray[1] + "] work done " + l + " total " + l2 + "... ");
            oracleCallableStatement.execute();
            lArray[0] = oracleCallableStatement.getLong(1);
            lArray[1] = oracleCallableStatement.getLong(2);
            System.out.println("[" + lArray[0] + ", " + lArray[1] + "]");
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private static class MyBlockedPCResultSet
    implements MyPCResultSet {
        private final long m_resultSize;
        private long m_ptsRemainingInBlock = 0L;
        private byte[] m_ptByteArray = null;
        private DataInputStream m_ptIS = null;
        private final ResultSet m_rs;

        @Override
        public long getResultSize() {
            return this.m_resultSize;
        }

        private MyBlockedPCResultSet(Statement statement, String string, long l) throws SQLException {
            ResultSet resultSet = statement.executeQuery("select sum(num_points) from " + string + " where obj_id = " + l);
            resultSet.next();
            this.m_resultSize = resultSet.getLong(1);
            resultSet.close();
            this.m_rs = resultSet = statement.executeQuery("select blk_id, points, num_points from " + string + " where obj_id = " + l + " order by blk_id");
        }

        @Override
        public boolean next() throws SQLException {
            boolean bl;
            if (this.m_ptsRemainingInBlock == 0L && !(bl = this.readNextBlock())) {
                return bl;
            }
            return this.readNextPt();
        }

        private boolean readNextPt() throws SQLException {
            --this.m_ptsRemainingInBlock;
            return true;
        }

        private boolean readNextBlock() throws SQLException {
            boolean bl = this.m_rs.next();
            if (!bl) {
                return bl;
            }
            this.m_ptsRemainingInBlock = this.m_rs.getLong(3);
            try {
                if (this.m_ptIS != null) {
                    this.m_ptIS.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            BLOB bLOB = (BLOB)this.m_rs.getBlob(2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(bLOB.getBinaryStream());
            this.m_ptIS = new DataInputStream(bufferedInputStream);
            long l = this.m_rs.getLong(1);
            System.out.println("qwerty read next block " + l + " with " + this.m_ptsRemainingInBlock + " points");
            return bl;
        }

        @Override
        public void readPtIntoBuffers(double[] dArray, double[] dArray2, double[] dArray3, long[] lArray, int n) throws SQLException {
            try {
                dArray[n] = this.m_ptIS.readDouble();
                dArray2[n] = this.m_ptIS.readDouble();
                dArray3[n] = this.m_ptIS.readDouble();
                this.m_ptIS.skipBytes(8);
                lArray[n] = Hilbert.hilbert_xy2d(Math.round(Math.pow(2.0, 31.0)), Math.round(dArray[n]), Math.round(dArray2[n]));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void close() throws SQLException {
        }
    }

    private static class MyFlatPCResultSet
    implements MyPCResultSet {
        private final ResultSet m_rs;
        private final long m_resultSize;

        @Override
        public boolean next() throws SQLException {
            return this.m_rs.next();
        }

        @Override
        public void close() throws SQLException {
            this.m_rs.close();
        }

        @Override
        public long getResultSize() {
            return this.m_resultSize;
        }

        private MyFlatPCResultSet(Statement statement, String string, long l) throws SQLException {
            ResultSet resultSet = statement.executeQuery("select count(*) from " + string);
            resultSet.next();
            this.m_resultSize = resultSet.getLong(1);
            resultSet.close();
            resultSet = statement.executeQuery("select val_d1, val_d2, val_d3, d from " + string + " order by d");
            resultSet.setFetchSize(10000);
            this.m_rs = resultSet;
        }

        @Override
        public void readPtIntoBuffers(double[] dArray, double[] dArray2, double[] dArray3, long[] lArray, int n) throws SQLException {
            dArray[n] = this.m_rs.getDouble(1);
            dArray2[n] = this.m_rs.getDouble(2);
            dArray3[n] = this.m_rs.getDouble(3);
            lArray[n] = this.m_rs.getLong(4);
        }
    }

    private static interface MyPCResultSet {
        public boolean next() throws SQLException;

        public void close() throws SQLException;

        public long getResultSize();

        public void readPtIntoBuffers(double[] var1, double[] var2, double[] var3, long[] var4, int var5) throws SQLException;
    }
}

