/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Comparator;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.Las2SqlLdrIndep;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;

public class PcBlockSortByLrs {
    private static long readLongFromByteArray(byte[] byArray, int n) {
        return ((long)(byArray[n + 0] & 0xFF) << 56) + ((long)(byArray[n + 1] & 0xFF) << 48) + ((long)(byArray[n + 2] & 0xFF) << 40) + ((long)(byArray[n + 3] & 0xFF) << 32) + ((long)(byArray[n + 4] & 0xFF) << 24) + ((long)(byArray[n + 5] & 0xFF) << 16) + ((long)(byArray[n + 6] & 0xFF) << 8) + (long)(byArray[n + 7] & 0xFF);
    }

    private static double readDoubleFromByteArray(byte[] byArray, int n) {
        return Double.longBitsToDouble(PcBlockSortByLrs.readLongFromByteArray(byArray, n));
    }

    private static void writeDoubleToByteArray(byte[] byArray, int n, double d) {
        Las2SqlLdrIndep.writeDoubleToByteArray(byArray, n, d);
    }

    public static Blob reSortPcBlock(Blob blob, int n, String string, Struct struct, int n2, int n3, double d, double d2, double d3, double d4, int n4) throws IOException, SQLException {
        SFCInfo sFCInfo = new SFCInfo(d, d2, d3, d4);
        Connection connection = DriverManager.getConnection("jdbc:default:connection:");
        int n5 = (int)(blob.length() / (long)n);
        JGeometry jGeometry = null;
        try {
            if (struct != null) {
                jGeometry = JGeometry.loadJS((Struct)struct);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        InputStream inputStream = blob.getBinaryStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        BLOB bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        bLOB.open(1);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 0x100000);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        BlockedPoint[] blockedPointArray = new BlockedPoint[n];
        byte[] byArray = null;
        for (int i = 0; i < n; ++i) {
            byArray = new byte[n5];
            dataInputStream.readFully(byArray);
            blockedPointArray[i] = new BlockedPoint(i, byArray, sFCInfo);
        }
        switch (string) {
            case "R-tree-blocked": {
                Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getX).thenComparing(BlockedPoint::getY).thenComparing(BlockedPoint::getPos));
                break;
            }
            case "Sorted by X": {
                Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getX).thenComparing(BlockedPoint::getY).thenComparing(BlockedPoint::getPos));
                break;
            }
            case "Sorted by Y": {
                Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getY).thenComparing(BlockedPoint::getX).thenComparing(BlockedPoint::getPos));
                break;
            }
            case "Sorted by Hilbert": {
                Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getSFCValue).thenComparing(BlockedPoint::getX).thenComparing(BlockedPoint::getY).thenComparing(BlockedPoint::getPos));
                break;
            }
            case "Sorted by Hilbert (Hybrid)": {
                throw new RuntimeException("Sort order \"" + string + "\" not supported for blocked model.");
            }
            case "Sorted by Linear Feature LRS/LOD": {
                for (int i = 0; i < blockedPointArray.length; ++i) {
                    blockedPointArray[i].setMeasure(i);
                }
                Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getMeasure).thenComparing(BlockedPoint::getX).thenComparing(BlockedPoint::getY).thenComparing(BlockedPoint::getPos));
                break;
            }
            case "Sorted by Linear Feature LRS": {
                try {
                    if (jGeometry == null || jGeometry.getType() != 2) break;
                    PreparedStatement preparedStatement = connection.prepareStatement("select\n  id,\n  Measure\nfrom (\n  select\n    p.id,\n    sdo_lrs.find_measure(\n      sdo_lrs.convert_to_lrs_geom(\n        ?,\n        0,\n        1.0),\n      p.pt) Measure\n  from (\n    select\n      it.z id,\n      sdo_geometry(\n        2001,\n        null,\n        sdo_point_type(\n          it.x,\n          it.y,\n          null),\n        null,\n        null) pt\n    from\n      table(?) it\n    ) p)\norder by\n  id");
                    int n6 = 10000;
                    int n7 = -1;
                    int n8 = -1;
                    int n9 = (blockedPointArray.length + n6 - 1) / n6;
                    for (int i = 0; i < n9; ++i) {
                        n7 = n8 + 1;
                        if ((n8 += n6) >= blockedPointArray.length) {
                            n8 = blockedPointArray.length - 1;
                        }
                        Object[] objectArray = new Object[n8 - n7 + 1];
                        for (int j = n7; j <= n8; ++j) {
                            objectArray[j - n7] = connection.createStruct("MDSYS.VERTEX_TYPE", new Object[]{blockedPointArray[j].getX(), blockedPointArray[j].getY(), j});
                        }
                        ARRAY aRRAY = ((OracleConnection)connection).createARRAY("MDSYS.VERTEX_SET_TYPE", (Object)objectArray);
                        ((OraclePreparedStatement)preparedStatement).setObject(1, (Object)struct);
                        ((OraclePreparedStatement)preparedStatement).setARRAY(2, aRRAY);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        int n10 = 0;
                        int n11 = n7;
                        while (resultSet.next()) {
                            blockedPointArray[n11].setMeasure(resultSet.getDouble(2));
                            if (n4 > -1) {
                                blockedPointArray[n11].writeDoubleToDim(n4, resultSet.getDouble(2));
                            }
                            if (n11 != resultSet.getInt(1)) {
                                throw new RuntimeException("Internal count off (" + n11 + " != " + resultSet.getInt(1) + ").");
                            }
                            ++n10;
                            ++n11;
                        }
                        resultSet.close();
                    }
                    preparedStatement.close();
                    Arrays.sort(blockedPointArray, Comparator.comparing(BlockedPoint::getMeasure).thenComparing(BlockedPoint::getX).thenComparing(BlockedPoint::getY).thenComparing(BlockedPoint::getPos));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case "Sorted by LOD": {
                throw new RuntimeException("Sort order \"" + string + "\" not YET supported.");
            }
            case "No Blocking": {
                throw new RuntimeException("Sort order \"" + string + "\" not YET supported.");
            }
            default: {
                throw new RuntimeException("Sort order \"" + string + "\" not supported.");
            }
        }
        for (int i = 0; i < n; ++i) {
            dataOutputStream.write(blockedPointArray[i].getEncoding(), 0, n5 - 8);
            if (n2 >= 0) {
                dataOutputStream.writeInt(n2);
            } else {
                dataOutputStream.write(blockedPointArray[i].getEncoding(), n5 - 8, 4);
            }
            if (n3 >= 0) {
                dataOutputStream.writeInt(n3 + i);
                continue;
            }
            dataOutputStream.write(blockedPointArray[i].getEncoding(), n5 - 4, 4);
        }
        dataOutputStream.close();
        outputStream.close();
        bLOB.close();
        dataInputStream.close();
        bufferedInputStream.close();
        inputStream.close();
        return bLOB;
    }

    public static class BlockedPoint {
        private final int m_ptPos;
        private final byte[] m_encoding;
        private double m_measure;
        private final SFCInfo m_sfcInfo;

        public BlockedPoint(int n, byte[] byArray, SFCInfo sFCInfo) {
            this.m_ptPos = n;
            this.m_encoding = byArray;
            this.m_sfcInfo = sFCInfo;
        }

        public int getPos() {
            return this.m_ptPos;
        }

        public double getX() {
            return PcBlockSortByLrs.readDoubleFromByteArray(this.m_encoding, 0);
        }

        public double getY() {
            return PcBlockSortByLrs.readDoubleFromByteArray(this.m_encoding, 8);
        }

        public void writeDoubleToDim(int n, double d) {
            PcBlockSortByLrs.writeDoubleToByteArray(this.m_encoding, n * 8, d);
        }

        public double getMeasure() {
            return this.m_measure;
        }

        public void setMeasure(double d) {
            this.m_measure = d;
        }

        public byte[] getEncoding() {
            return this.m_encoding;
        }

        public static long hilbert_xy2d(long l, long l2, long l3) {
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = l2;
            long l8 = l3;
            for (long i = l >> 1; i >= 1L; i >>= 1) {
                l4 = (l7 & i) > 0L ? 1 : 0;
                l5 = (l8 & i) > 0L ? 1 : 0;
                l6 += i * i * (3L * l4 ^ l5);
                if (l5 != 0L) continue;
                if (l4 == 1L) {
                    l7 = i - 1L - l7;
                    l8 = i - 1L - l8;
                }
                long l9 = l7;
                l7 = l8;
                l8 = l9;
            }
            return l6;
        }

        public long getSFCValue() {
            long l = (long)Math.pow(2.0, 31.0);
            return BlockedPoint.hilbert_xy2d(l, (long)Math.floor(this.getX()), (long)Math.floor(this.getY()));
        }
    }

    private static class SFCInfo {
        private final double m_sfcDomainMinX;
        private final double m_sfcDomainMinY;
        private final double m_sfcDomainMaxX;
        private final double m_sfcDomainMaxY;

        public SFCInfo(double d, double d2, double d3, double d4) {
            this.m_sfcDomainMinX = d;
            this.m_sfcDomainMinY = d2;
            this.m_sfcDomainMaxX = d3;
            this.m_sfcDomainMaxY = d4;
        }

        public double getSfcDomainMinX() {
            return this.m_sfcDomainMinX;
        }

        public double getSfcDomainMinY() {
            return this.m_sfcDomainMinY;
        }

        public double getSfcDomainMaxX() {
            return this.m_sfcDomainMaxX;
        }

        public double getSfcDomainMaxY() {
            return this.m_sfcDomainMaxY;
        }
    }
}

