/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TableScrollPaneUI;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableScrollBoxLayout;

public class TableScrollBox
extends ScrollBox {
    private Component _hScrollBar;
    private Component _vScrollBar;

    public TableScrollBox() {
        this(null);
    }

    public TableScrollBox(SpreadTable spreadTable) {
        this(spreadTable, 1, 1);
    }

    public TableScrollBox(Component component) {
        this(component, 1, 1);
    }

    public TableScrollBox(SpreadTable spreadTable, int n, int n2) {
        this((Component)spreadTable, n, n2);
    }

    public TableScrollBox(Component component, int n, int n2) {
        super(null, 2, 2);
        this.setLayout(new TableScrollBoxLayout());
        this.setContent(component);
        this.setHDisplayPolicy(n);
        this.setVDisplayPolicy(n2);
        this.updateUI(TableScrollBox.class);
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == TableScrollBox.class) {
            this.updateUI();
        }
    }

    @Override
    public Object getUIClassID() {
        return "TableScrollPaneUI";
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._hScrollBar != null) {
            this._hScrollBar.setEnabled(bl);
        }
        if (this._vScrollBar != null) {
            this._vScrollBar.setEnabled(bl);
        }
    }

    @Override
    public int getRepaintFlags() {
        return super.getRepaintFlags() | 1 | 4 | 0x80;
    }

    public boolean isHScrollbarVisible() {
        return this._hScrollBar != null && this._hScrollBar.isVisible();
    }

    public boolean isVScrollbarVisible() {
        return this._vScrollBar != null && this._vScrollBar.isVisible();
    }

    protected int getHScrollbarOffset() {
        SpreadTable spreadTable;
        Component component = this.getContent();
        if (component != null && component instanceof SpreadTable && (spreadTable = (SpreadTable)component).isRowHeaderVisible()) {
            return spreadTable.getRowHeaderWidth();
        }
        return 0;
    }

    protected int getVScrollbarOffset() {
        SpreadTable spreadTable;
        Component component = this.getContent();
        if (component != null && component instanceof SpreadTable && (spreadTable = (SpreadTable)component).isColumnHeaderVisible()) {
            return spreadTable.getColumnHeaderHeight();
        }
        return 0;
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        int n;
        Object object;
        super.paintCanvasInterior(graphics);
        boolean bl = this.getActualReadingDirection() == 1;
        TableScrollPaneUI tableScrollPaneUI = (TableScrollPaneUI)this.getUI();
        Point point = this.getInnerOrigin();
        int n2 = this.getHScrollbarOffset();
        if (n2 != 0 && this.isHScrollbarVisible()) {
            Painter painter = tableScrollPaneUI.getCornerPainter(bl ? 0 : 2);
            object = this._hScrollBar.getBounds();
            int n3 = bl ? 0 : ((Rectangle)object).x + ((Rectangle)object).width;
            painter.paint(this.getPaintContext(), graphics, n3, ((Rectangle)object).y - point.y + 1, n2 + 1, ((Rectangle)object).height - 1);
        }
        if ((n = this.getVScrollbarOffset()) != 0 && this.isVScrollbarVisible()) {
            object = tableScrollPaneUI.getCornerPainter(bl ? 1 : 3);
            Rectangle rectangle = this._vScrollBar.getBounds();
            int n4 = bl ? rectangle.x - point.x + 1 : 0;
            object.paint(this.getPaintContext(), graphics, n4, 0, rectangle.width - 1, n);
        }
    }

    void setScrollBars(Component component, Component component2) {
        this._hScrollBar = component;
        this._vScrollBar = component2;
        this.getUI().installUI(this);
        this.repaint();
    }
}

