/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.table;

import oracle.ewt.event.Cancelable;
import oracle.ewt.grid.GridCellSelectListener;
import oracle.ewt.grid.GridColSelectListener;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridFocusListener;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridScrollListener;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderSelection;
import oracle.ewt.table.SpreadTable;

final class TableGridAdapter
implements GridCellSelectListener,
GridColSelectListener,
GridRowSelectListener,
GridEditListener,
GridFocusListener,
GridScrollListener {
    private SpreadTable _table;

    public TableGridAdapter(SpreadTable spreadTable) {
        this._table = spreadTable;
    }

    @Override
    public void columnSelecting(GridEvent gridEvent) {
        Header header = this._table.getColumnHeader();
        if (header == null && this._table.fireCancelableColumnEvent(2009, gridEvent.getColumn())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void columnDeselecting(GridEvent gridEvent) {
        Header header = this._table.getColumnHeader();
        if (header == null && this._table.fireCancelableColumnEvent(2011, gridEvent.getColumn())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void columnSelected(GridEvent gridEvent) {
        HeaderSelection headerSelection;
        Header header = this._table.getRowHeader();
        if (header != null) {
            headerSelection = header.getHeaderSelection();
            header.freezeRepaints();
            headerSelection.deselectAll();
            header.unfreezeRepaints();
        }
        int n = gridEvent.getColumn();
        header = this._table.getColumnHeader();
        if (header != null) {
            headerSelection = header.getHeaderSelection();
            if (!headerSelection.isItemSelected(n)) {
                headerSelection.setItemSelected(n, true);
            }
        } else {
            this._table.fireColumnEvent(2010, n);
        }
    }

    @Override
    public void columnDeselected(GridEvent gridEvent) {
        int n = gridEvent.getColumn();
        Header header = this._table.getColumnHeader();
        if (header != null) {
            HeaderSelection headerSelection = header.getHeaderSelection();
            if (headerSelection.isItemSelected(n)) {
                headerSelection.setItemSelected(n, false);
            }
        } else {
            this._table.fireColumnEvent(2012, n);
        }
    }

    @Override
    public void rowSelecting(GridEvent gridEvent) {
        Header header = this._table.getRowHeader();
        if (header == null && this._table.fireCancelableRowEvent(2005, gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void rowDeselecting(GridEvent gridEvent) {
        Header header = this._table.getRowHeader();
        if (header == null && this._table.fireCancelableRowEvent(2007, gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void rowSelected(GridEvent gridEvent) {
        HeaderSelection headerSelection;
        Header header = this._table.getColumnHeader();
        if (header != null) {
            headerSelection = header.getHeaderSelection();
            header.freezeRepaints();
            headerSelection.deselectAll();
            header.unfreezeRepaints();
        }
        int n = gridEvent.getRow();
        header = this._table.getRowHeader();
        if (header != null) {
            headerSelection = header.getHeaderSelection();
            if (!headerSelection.isItemSelected(n)) {
                headerSelection.setItemSelected(n, true);
            }
        } else {
            this._table.fireRowEvent(2006, n);
        }
    }

    @Override
    public void rowDeselected(GridEvent gridEvent) {
        int n = gridEvent.getRow();
        Header header = this._table.getRowHeader();
        if (header != null) {
            HeaderSelection headerSelection = header.getHeaderSelection();
            if (headerSelection.isItemSelected(n)) {
                headerSelection.setItemSelected(n, false);
            }
        } else {
            this._table.fireRowEvent(2008, n);
        }
    }

    @Override
    public void cellSelecting(GridEvent gridEvent) {
        if (this._table.fireCancelableCellEvent(2001, gridEvent.getColumn(), gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void cellSelected(GridEvent gridEvent) {
        this._table.fireCellEvent(2002, gridEvent.getColumn(), gridEvent.getRow());
    }

    @Override
    public void cellDeselecting(GridEvent gridEvent) {
        if (this._table.fireCancelableCellEvent(2003, gridEvent.getColumn(), gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void cellDeselected(GridEvent gridEvent) {
        this._table.fireCellEvent(2004, gridEvent.getColumn(), gridEvent.getRow());
    }

    @Override
    public void cellEditing(GridEvent gridEvent) {
        if (this._table.fireCancelableCellEvent(2017, gridEvent.getColumn(), gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void cellEdited(GridEvent gridEvent) {
        this._table.fireCellEvent(2018, gridEvent.getColumn(), gridEvent.getRow());
    }

    @Override
    public void focusCellChanging(GridEvent gridEvent) {
        if (this._table.fireCancelableCellEvent(2027, gridEvent.getColumn(), gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void focusCellChanged(GridEvent gridEvent) {
        this._table.fireCellEvent(2028, gridEvent.getColumn(), gridEvent.getRow());
        if (this._table.getColumnHeader() != null) {
            this._table.getColumnHeader().setFocusItem(gridEvent.getColumn());
        }
        if (this._table.getRowHeader() != null) {
            this._table.getRowHeader().setFocusItem(gridEvent.getRow());
        }
    }

    @Override
    public void columnScrolling(GridEvent gridEvent) {
        if (this._table.fireCancelableColumnEvent(2019, gridEvent.getColumn())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void rowScrolling(GridEvent gridEvent) {
        if (this._table.fireCancelableRowEvent(2021, gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    @Override
    public void columnScrolled(GridEvent gridEvent) {
        int n = gridEvent.getColumn();
        Header header = this._table.getColumnHeader();
        if (header != null) {
            header.setFirstItemOnScreen(n);
        }
        int n2 = this._table.getScrollByColumn() ? n : this._table.getGrid().getColumnPosition(n);
        this._table.updateHScrollBarValue(n2);
        this._table.fireColumnEvent(2020, n);
    }

    @Override
    public void rowScrolled(GridEvent gridEvent) {
        int n = gridEvent.getRow();
        Header header = this._table.getRowHeader();
        if (header != null) {
            header.setFirstItemOnScreen(n);
        }
        int n2 = this._table.getScrollByRow() ? n : this._table.getGrid().getRowPosition(n);
        this._table.updateVScrollBarValue(n2);
        this._table.fireRowEvent(2022, n);
    }
}

