/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.popup.PopupHandler;
import oracle.ewt.swing.FakeRoot;
import oracle.ewt.swing.HackRepaintManager;

public class JBufferedFrame
extends BufferedFrame
implements RootPaneContainer {
    private FakeRoot _rp;

    public JBufferedFrame() {
    }

    public JBufferedFrame(String string) {
        super(string);
    }

    @Override
    public JRootPane getRootPane() {
        this._enableSwingSupport();
        return this._rp;
    }

    @Override
    public void setContentPane(Container container) {
        this._enableSwingSupport();
        this._rp.setContentPane(container);
    }

    @Override
    public Container getContentPane() {
        this._enableSwingSupport();
        return this._rp.getContentPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this._enableSwingSupport();
        this._rp.setLayeredPane(jLayeredPane);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        this._enableSwingSupport();
        return this._rp.getLayeredPane();
    }

    @Override
    public void setGlassPane(Component component) {
        this._enableSwingSupport();
        this._rp.setGlassPane(component);
    }

    @Override
    public Component getGlassPane() {
        this._enableSwingSupport();
        return this._rp.getGlassPane();
    }

    @Override
    public Component add(Component component) {
        if (PopupHandler.isSwingPopup(component)) {
            this.addPopup(component);
            component.validate();
            return component;
        }
        return super.add(component);
    }

    @Override
    public void postProcessKey(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._rp != null && (keyEvent.getID() != 401 || keyEvent.getKeyCode() != 9)) {
            this._rp.dispatchEvent(keyEvent);
        }
        super.postProcessKey(keyEvent);
    }

    @Override
    protected void validateTree() {
        FakeRoot fakeRoot = this._rp;
        super.validateTree();
        if (this._rp != null) {
            this._addRootPane();
            if (fakeRoot == null) {
                this.invalidate();
                this.validate();
            }
        }
    }

    private void _addRootPane() {
        if (!this.isShowing()) {
            return;
        }
        if (!this.isPopup(this._rp)) {
            this.addPopup(this._rp);
            this.showPopup(this._rp, 0, 0);
            this._rp.superAddNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _enableSwingSupport() {
        if (this._rp != null) {
            return;
        }
        JBufferedFrame jBufferedFrame = this;
        synchronized (jBufferedFrame) {
            if (this._rp == null) {
                this._rp = new FakeRoot();
            }
        }
        this._addRootPane();
    }

    static {
        HackRepaintManager.install();
    }
}

