/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.scrolling.MouseWheelScrolling;

public final class MouseWheelUtils {
    private static boolean _sMouseWheelSupported = false;
    private static Class _sMouseWheelListenerClass = null;
    private static boolean _sWheelScrolling;
    private static Class _sMouseWheelEventClass;
    private static Class _sMouseWheelHandlerClass;
    private static Constructor _sMouseWheelConstructor;
    private static Method _sAddMouseWheelListenerMethod;
    private static Method _sRemoveMouseWheelListenerMethod;
    private static Method _sGetScrollTypeMethod;
    private static Method _sGetScrollAmountMethod;
    private static Method _sGetWheelRotationMethod;
    private Object _mouseWheelHandlerObject = null;

    public static final void setWheelScrollingEnabled(boolean bl) {
        _sWheelScrolling = bl;
    }

    public static final boolean isWheelScrollingEnabled() {
        return _sMouseWheelSupported && _sWheelScrolling;
    }

    public final void addMouseWheelListener(MouseWheelScrolling mouseWheelScrolling) {
        if (_sMouseWheelSupported && mouseWheelScrolling != null) {
            try {
                Object[] objectArray = new Object[]{this._getMouseWheelHandlerInstance()};
                Method method = MouseWheelUtils._getAddMouseWheelListenerMethod();
                method.invoke((Object)mouseWheelScrolling.getMouseWheelScrollingComponent(), objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void removeMouseWheelListener(MouseWheelScrolling mouseWheelScrolling) {
        if (_sMouseWheelSupported && mouseWheelScrolling != null) {
            try {
                Object[] objectArray = new Object[]{this._getMouseWheelHandlerInstance()};
                Method method = MouseWheelUtils._getRemoveMouseWheelListenerMethod();
                method.invoke((Object)mouseWheelScrolling.getMouseWheelScrollingComponent(), objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final boolean isMouseWheelEvent(MouseEvent mouseEvent) {
        if (_sMouseWheelSupported) {
            try {
                Class clazz = MouseWheelUtils._getMouseWheelEventClass();
                return clazz.isInstance(mouseEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static final void dispatchMouseWheelEvent(MouseEvent mouseEvent, Component component, Point point) {
        if (mouseEvent == null || component == null || point == null) {
            return;
        }
        if (_sMouseWheelSupported && MouseWheelUtils.isMouseWheelEvent(mouseEvent)) {
            try {
                Constructor constructor = MouseWheelUtils._getMouseWheelConstructor();
                Object[] objectArray = new Object[]{component, IntegerUtils.getInteger((int)mouseEvent.getID()), new Long(mouseEvent.getWhen()), IntegerUtils.getInteger((int)mouseEvent.getModifiers()), IntegerUtils.getInteger((int)point.x), IntegerUtils.getInteger((int)point.y), IntegerUtils.getInteger((int)mouseEvent.getClickCount()), BooleanUtils.getBoolean((boolean)mouseEvent.isPopupTrigger()), MouseWheelUtils._getScrollTypeMethod().invoke((Object)mouseEvent, (Object[])null), MouseWheelUtils._getScrollAmountMethod().invoke((Object)mouseEvent, (Object[])null), MouseWheelUtils._getWheelRotationMethod().invoke((Object)mouseEvent, (Object[])null)};
                component.dispatchEvent((MouseEvent)constructor.newInstance(objectArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Class _getMouseWheelEventClass() {
        if (_sMouseWheelEventClass == null) {
            try {
                _sMouseWheelEventClass = Class.forName("java.awt.event.MouseWheelEvent");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sMouseWheelEventClass;
    }

    private static Class _getMouseWheelHandlerClass() {
        if (_sMouseWheelHandlerClass == null) {
            try {
                _sMouseWheelHandlerClass = Class.forName("oracle.ewt.scrolling.MouseWheelHandler");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sMouseWheelHandlerClass;
    }

    private static Constructor _getMouseWheelConstructor() {
        if (_sMouseWheelConstructor == null) {
            try {
                Class clazz = MouseWheelUtils._getMouseWheelEventClass();
                Class[] classArray = new Class[]{Component.class, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                _sMouseWheelConstructor = clazz.getConstructor(classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sMouseWheelConstructor;
    }

    private Object _getMouseWheelHandlerInstance() {
        if (this._mouseWheelHandlerObject == null) {
            try {
                this._mouseWheelHandlerObject = MouseWheelUtils._getMouseWheelHandlerClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._mouseWheelHandlerObject;
    }

    private static Method _getAddMouseWheelListenerMethod() {
        if (_sAddMouseWheelListenerMethod == null) {
            try {
                Class[] classArray = new Class[]{_sMouseWheelListenerClass};
                _sAddMouseWheelListenerMethod = Component.class.getMethod("addMouseWheelListener", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sAddMouseWheelListenerMethod;
    }

    private static Method _getRemoveMouseWheelListenerMethod() {
        if (_sRemoveMouseWheelListenerMethod == null) {
            try {
                Class[] classArray = new Class[]{_sMouseWheelListenerClass};
                _sRemoveMouseWheelListenerMethod = Component.class.getMethod("removeMouseWheelListener", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sRemoveMouseWheelListenerMethod;
    }

    private static Method _getScrollTypeMethod() {
        if (_sGetScrollTypeMethod == null) {
            try {
                Class clazz = MouseWheelUtils._getMouseWheelEventClass();
                _sGetScrollTypeMethod = clazz.getMethod("getScrollType", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sGetScrollTypeMethod;
    }

    private static Method _getScrollAmountMethod() {
        if (_sGetScrollAmountMethod == null) {
            try {
                Class clazz = MouseWheelUtils._getMouseWheelEventClass();
                _sGetScrollAmountMethod = clazz.getMethod("getScrollAmount", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sGetScrollAmountMethod;
    }

    private static Method _getWheelRotationMethod() {
        if (_sGetWheelRotationMethod == null) {
            try {
                Class clazz = MouseWheelUtils._getMouseWheelEventClass();
                _sGetWheelRotationMethod = clazz.getMethod("getWheelRotation", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sGetWheelRotationMethod;
    }

    static {
        try {
            _sMouseWheelListenerClass = Class.forName("java.awt.event.MouseWheelListener");
            _sMouseWheelSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _sWheelScrolling = false;
        _sMouseWheelEventClass = null;
        _sMouseWheelHandlerClass = null;
        _sMouseWheelConstructor = null;
        _sAddMouseWheelListenerMethod = null;
        _sRemoveMouseWheelListenerMethod = null;
        _sGetScrollTypeMethod = null;
        _sGetScrollAmountMethod = null;
        _sGetWheelRotationMethod = null;
    }
}

