/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.event.tracking.GlassMouseGrabProvider;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.popup.PopupHandler;
import oracle.ewt.popup.PopupOwner;

public abstract class PopupFrame
extends Frame
implements PopupOwner,
MouseGrabProvider {
    private PopupHandler _popper;
    private MouseGrabProvider _mouseGrabProvider;

    public PopupFrame() {
    }

    public PopupFrame(String string) {
        super(string);
    }

    @Override
    public void addPopup(Component component) {
        this._getPopupHandler().addPopup(this, component);
    }

    @Override
    public boolean isPopup(Component component) {
        return this._getPopupHandler().isPopup(this, component);
    }

    @Override
    public void showPopup(Component component, int n, int n2) {
        this._getPopupHandler().showPopup(this, component, n, n2);
    }

    @Override
    public void removePopup(Component component) {
        this._getPopupHandler().removePopup(this, component);
    }

    @Override
    public void setPopupBounds(Component component, int n, int n2, int n3, int n4) {
        this._getPopupHandler().setPopupBounds(this, component, n, n2, n3, n4);
    }

    @Override
    public void addMouseGrab(MouseListener mouseListener) {
        this._getNonNullMouseGrabProvider().addMouseGrab(mouseListener);
        this._getPopupHandler().showProxyComponent(this, this.getProxyComponent());
    }

    @Override
    public void addMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._getNonNullMouseGrabProvider().addMouseMotionGrab(mouseMotionListener);
        this._getPopupHandler().showProxyComponent(this, this.getProxyComponent());
    }

    public MouseGrabProvider getMouseGrabProvider() {
        return this._mouseGrabProvider;
    }

    @Override
    public Component getProxyComponent() {
        MouseGrabProvider mouseGrabProvider = this.getMouseGrabProvider();
        if (mouseGrabProvider != null) {
            return mouseGrabProvider.getProxyComponent();
        }
        return null;
    }

    @Override
    public void removeMouseGrab(MouseListener mouseListener) {
        this.getMouseGrabProvider().removeMouseGrab(mouseListener);
    }

    @Override
    public void removeMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this.getMouseGrabProvider().removeMouseMotionGrab(mouseMotionListener);
    }

    @Override
    public void processMouseGrabs(MouseEvent mouseEvent) {
        this.getMouseGrabProvider().processMouseGrabs(mouseEvent);
    }

    public void setMouseGrabProvider(MouseGrabProvider mouseGrabProvider) {
        if (this._mouseGrabProvider != mouseGrabProvider) {
            if (this._mouseGrabProvider != null) {
                throw new IllegalStateException();
            }
            this._mouseGrabProvider = mouseGrabProvider;
        }
    }

    @Override
    public void invalidate() {
        if (this._getPopupHandler().shouldInvalidate()) {
            super.invalidate();
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        PopupHandler popupHandler = this._getPopupHandler();
        if (layoutManager == null) {
            super.setLayout(null);
        } else {
            super.setLayout(popupHandler);
        }
        popupHandler.setLayout(layoutManager);
    }

    private MouseGrabProvider _getNonNullMouseGrabProvider() {
        MouseGrabProvider mouseGrabProvider = this.getMouseGrabProvider();
        if (mouseGrabProvider == null) {
            this._mouseGrabProvider = mouseGrabProvider = new GlassMouseGrabProvider();
        }
        return mouseGrabProvider;
    }

    private PopupHandler _getPopupHandler() {
        if (this._popper == null) {
            this._popper = new PopupHandler();
        }
        return this._popper;
    }
}

