/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu.laf;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemContainer;
import oracle.ewt.lwAWT.lwMenu.laf.MenuItemController;
import oracle.ewt.util.InputEventUtils;

public class HorzMenuController
extends MouseAdapter
implements MenuItemController,
KeyListener {
    public static final Object _CLIENTPROP_DISPLAY_SUBMENU = "_displaySubmenu";
    private LWMenu _menu;
    private boolean _hideOnRelease;

    @Override
    public void installController(LWMenuItem lWMenuItem) {
        this._menu = (LWMenu)lWMenuItem;
        lWMenuItem.addMouseListener(this);
        lWMenuItem.addKeyListener(this);
    }

    @Override
    public void uninstallController(LWMenuItem lWMenuItem) {
        lWMenuItem.removeMouseListener(this);
        lWMenuItem.removeKeyListener(this);
        this._menu = null;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 40: {
                if (this._menu.isSubMenuDisplayed() || !this._menu.isEnabled()) break;
                this._menu.activate();
                keyEvent.consume();
                break;
            }
            case 38: {
                if (!this._menu.isSubMenuDisplayed()) break;
                this._hideSubmenu();
                keyEvent.consume();
                break;
            }
            case 27: {
                if (this._menu.isSubMenuDisplayed()) {
                    this._hideSubmenu();
                } else {
                    this._menu.setSelected(false);
                }
                keyEvent.consume();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        LWMenu lWMenu = (LWMenu)mouseEvent.getSource();
        if (lWMenu.isEnabled() && mouseEvent.getClickCount() == 1 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            if (!lWMenu.isSubMenuDisplayed()) {
                lWMenu.setSubMenuDisplayed(true);
            } else {
                this._hideOnRelease = true;
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        LWMenu lWMenu = (LWMenu)mouseEvent.getSource();
        if (this._hideOnRelease) {
            this._hideOnRelease = false;
            lWMenu.setSelected(false);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        LWMenu lWMenu = (LWMenu)mouseEvent.getSource();
        LWMenuItemContainer lWMenuItemContainer = lWMenu.getMenuItemContainer();
        LWMenuItem lWMenuItem = lWMenuItemContainer.getSelectedItem();
        if (lWMenuItem != null) {
            if (lWMenu.isEnabled() && this._displaySubmenu(lWMenuItemContainer)) {
                lWMenu.setSubMenuDisplayed(true);
            } else {
                lWMenu.setSelected(true);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean _displaySubmenu(LWMenuItemContainer lWMenuItemContainer) {
        if (lWMenuItemContainer instanceof LWMenuBar) {
            return ((LWMenuBar)lWMenuItemContainer).getClientProperty(_CLIENTPROP_DISPLAY_SUBMENU) != null;
        }
        return true;
    }

    private void _hideSubmenu() {
        this._menu.setSubMenuDisplayed(false);
        LWMenuItemContainer lWMenuItemContainer = this._menu.getMenuItemContainer();
        if (lWMenuItemContainer instanceof LWMenuBar) {
            ((LWMenuBar)lWMenuItemContainer).putClientProperty(_CLIENTPROP_DISPLAY_SUBMENU, null);
        }
    }
}

