/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceAdapter;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWDataSourceList;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ChoiceUI;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.LookAndFeelUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public class LWDataSourceChoice
extends LWComponent
implements ItemSelectable {
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private static final long _VISIBLE_MILLIS = 400L;
    private long _popMillis;
    private boolean _dragging;
    private ListListener _listListener;
    private OneDDataSource _items;
    private OneDDataSourceListener _listen;
    private int _selectedIndex = -1;
    private PushButton _button;
    private int _textX;
    private boolean _isDropDownVisible;
    private LWDataSourceList _list;
    private Window _checkWindow;
    private MoveCheck _moveCheck;
    private ListenerManager _iListenerManager;
    private long _currentTime;
    private long _typeAheadDelay = -1L;
    private static long _sDefaultTypeAheadDelay = 750L;
    private StringBuffer _buffer;
    private MouseGrabProvider _mouseGrabProvider;
    private KeeperUpper _popdownCanceller;
    private char _keyChar;

    public LWDataSourceChoice() {
        this(null);
    }

    public LWDataSourceChoice(OneDDataSource oneDDataSource) {
        long l = 60L;
        this.enableEvents(l);
        this._isDropDownVisible = false;
        this._popMillis = 0L;
        this.updateUI(LWDataSourceChoice.class);
        ChoiceUI choiceUI = (ChoiceUI)this.getUI();
        this._button = this.createButton();
        this._button.setFocusable(false);
        this._button.setEnabled(false);
        ButtonListen buttonListen = new ButtonListen();
        this._button.addMouseListener(buttonListen);
        this._button.addMouseMotionListener(buttonListen);
        this.add(this._button);
        this._listen = new Listen();
        this.setDataSource(oneDDataSource);
    }

    public void setDataSource(OneDDataSource oneDDataSource) {
        if (this._items != null) {
            this._items.removeDataSourceListener(this._listen);
        }
        this._items = oneDDataSource;
        if (this._list != null) {
            this._list.setDataSource(this._items);
        }
        if (oneDDataSource != null) {
            oneDDataSource.addDataSourceListener(this._listen);
        }
        this.setSelectedIndex(this.getItemCount() > 0 ? 0 : -1);
        this.updateButtonEnabled();
    }

    public OneDDataSource getDataSource() {
        return this._items;
    }

    public int getItemCount() {
        return this._items != null ? this._items.getItemCount() : 0;
    }

    public String getItem(int n) {
        return (String)this._items.getData(n);
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        return n >= 0 ? this.getItem(n) : null;
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            Object[] objectArray = new Object[]{this.getItem(n)};
            return objectArray;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            String string = "illegal LWChoice item position: " + n;
            throw new IllegalArgumentException(string);
        }
        this.setSelectedIndex(n);
        this.repaint();
    }

    public synchronized void select(String string) {
        int n = this.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._iListenerManager == null) {
            this._iListenerManager = new ListenerManager();
        }
        this._iListenerManager.addListener(itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this._iListenerManager != null) {
            this._iListenerManager.removeListener(itemListener);
        }
    }

    public ImageSet getImageSet(int n) {
        return null;
    }

    public int getRowHeight() {
        FontMetrics fontMetrics;
        Font font = this.getFont();
        int n = 0;
        if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            n = fontMetrics.getHeight() + 2;
        }
        return n;
    }

    @Override
    public void doLayout() {
        int n;
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = this.getChoiceUI().getButtonInsets(this);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._button.getPreferredSize();
        int n2 = dimension.height - immInsets.top - immInsets2.top - immInsets2.bottom - immInsets.bottom;
        int n3 = this.getActualReadingDirection();
        if (n3 == 1) {
            n = dimension.width - immInsets.right - dimension2.width - immInsets2.right;
            this._textX = 0;
        } else {
            n = immInsets.left + immInsets2.right;
            this._textX = n + dimension2.width + immInsets2.left;
        }
        this._button.setBounds(n, immInsets.top + immInsets2.top, dimension2.width, n2);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        ChoiceUI choiceUI = this.getChoiceUI();
        Painter painter = choiceUI.getPainter(this);
        Dimension dimension = painter.getPreferredSize(this.getPaintContext());
        int n2 = 100;
        int n3 = 20;
        Font font = this.getFont();
        Dimension dimension2 = this._button.getPreferredSize();
        ImmInsets immInsets = choiceUI.getButtonInsets(this);
        if (font != null) {
            ImmInsets immInsets2 = choiceUI.getSelectionInsets(this);
            LWDataSourceList lWDataSourceList = this.getList();
            Font font2 = lWDataSourceList.getFont();
            if (!font.equals(font2)) {
                lWDataSourceList.setFont(font);
            }
            lWDataSourceList.setLocale(LocaleUtils.getDefaultableLocale(this));
            n3 = dimension.height;
            n2 = immInsets2.left + lWDataSourceList.getPreferredSize().width + immInsets2.right + immInsets.left + dimension2.width + immInsets.left;
        }
        if (n3 < (n = immInsets.top + dimension2.height + immInsets.bottom)) {
            n3 = n;
        }
        return this.convertInnerToOuterSize(n2, n3);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtonEnabled();
    }

    public void setTypeAheadDelay(long l) {
        this._typeAheadDelay = l;
    }

    public long getTypeAheadDelay() {
        if (this._typeAheadDelay == -1L) {
            return LWDataSourceChoice.getDefaultTypeAheadDelay();
        }
        return this._typeAheadDelay;
    }

    public static void setDefaultTypeAheadDelay(long l) {
        _sDefaultTypeAheadDelay = l;
    }

    public static long getDefaultTypeAheadDelay() {
        return _sDefaultTypeAheadDelay;
    }

    protected void setSelectedIndex(int n) {
        int n2 = this._selectedIndex;
        this._selectedIndex = n;
        this._fireActiveEvent(n2, n);
        if (n >= 0) {
            this.getList().select(n);
        }
    }

    private void _fireActiveEvent(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", n == -1 ? null : this.getList().getAccessibleContext().getAccessibleChild(n), n2 == -1 ? null : this.getList().getAccessibleContext().getAccessibleChild(n2));
        }
    }

    protected PushButton createButton() {
        return new ChoiceButton();
    }

    protected PushButton getButton() {
        return this._button;
    }

    @Override
    protected Object getPaintData(Object object) {
        int n;
        Object object2 = null;
        if (object == null || object == PaintContext.LABEL_KEY) {
            String string = this.getSelectedItem();
            if (string != null && string.length() > 0) {
                object2 = string;
            }
        } else if (object == PaintContext.IMAGESET_KEY && (n = this.getSelectedIndex()) >= 0) {
            return this.getImageSet(n);
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    @Override
    public void paintInterior(Graphics graphics) {
        Dimension dimension = this.getInnerSize();
        int n = this._button.getSize().width;
        int n2 = this.getActualReadingDirection() == 1 ? 0 : n;
        this.getChoiceUI().getPainter(this).paint(this.getPaintContext(), graphics, n2, 0, dimension.width - n, dimension.height);
    }

    @Override
    public void removeNotify() {
        this.setDropDownVisible(false);
        super.removeNotify();
    }

    @Override
    public Object getUIClassID() {
        return "ChoiceUI";
    }

    @Override
    public Object getToolTipValue() {
        if (this.isDropDownVisible()) {
            return null;
        }
        return super.getToolTipValue();
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        LookAndFeelUtils.setComponentTreeColorScheme(this.getList(), colorScheme);
    }

    @Override
    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x20 | 0x100 | 0x4000 | 1 | 0x800;
    }

    @Override
    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x100 | 0x4000;
    }

    protected ChoiceUI getChoiceUI() {
        return (ChoiceUI)this.getUI();
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == LWDataSourceChoice.class) {
            this.updateUI();
        }
    }

    @Override
    protected void updateUI(LookAndFeel lookAndFeel) {
        super.updateUI(lookAndFeel);
        this.getList();
    }

    protected void hideDropDown(boolean bl) {
        if (!this.isDropDownVisible()) {
            return;
        }
        if (bl) {
            int n = this.getSelectedIndex();
            int n2 = this.getList().getSelectedIndex();
            if (n2 != -1) {
                this.fireItemEvent(this.getItem(n), 2);
                this.select(n2);
                this.fireItemEvent(this.getItem(n2), 1);
            }
        }
        this.setDropDownVisible(false);
    }

    protected void setDropDownVisible(boolean bl) {
        if (this._isDropDownVisible == bl) {
            return;
        }
        LWDataSourceList lWDataSourceList = this.getList();
        if (bl) {
            if (!this.allowDropDown()) {
                return;
            }
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                lWDataSourceList.getAccessibleContext().setAccessibleParent(this);
            }
            ToolTipManager.getToolTipManager().leave(this);
            this._popMillis = System.currentTimeMillis();
            if (this._moveCheck == null) {
                this._moveCheck = new MoveCheck();
            }
            lWDataSourceList.setFont(this.getFont());
            lWDataSourceList.setReadingDirection(this.getActualReadingDirection());
            lWDataSourceList.setForeground(this.getForeground());
            lWDataSourceList.setBackground(this.getBackground());
            int n = this.getSelectedIndex();
            if (n != -1) {
                lWDataSourceList.select(n);
            } else {
                n = lWDataSourceList.getSelectedIndex();
                if (n != -1) {
                    lWDataSourceList.deselect(n);
                }
            }
            this._isDropDownVisible = ((ChoiceUI)this.getUI()).showDropDown(this, this.getList(), this._button.getSize().width);
            if (this._isDropDownVisible) {
                if (n != -1) {
                    lWDataSourceList.makeVisible(n);
                }
                this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this);
                this._checkWindow = WindowUtils.getWindow(this.getList());
                this._checkWindow.addComponentListener(this._moveCheck);
                if (this._mouseGrabProvider != null) {
                    this._popdownCanceller = new KeeperUpper(this.getList());
                    this._mouseGrabProvider.addMouseGrab(this._popdownCanceller);
                }
            }
        } else {
            PopupUtils.hidePopup(lWDataSourceList);
            this._checkWindow.removeComponentListener(this._moveCheck);
            if (this._mouseGrabProvider != null) {
                this._mouseGrabProvider.removeMouseGrab(this._popdownCanceller);
                this._popdownCanceller = null;
                this._mouseGrabProvider = null;
            }
            this._isDropDownVisible = false;
            this._dragging = false;
        }
        this._button.repaint();
    }

    protected boolean allowDropDown() {
        return this.getItemCount() > 1;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this._iListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._iListenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!this.hasFocus()) {
            this.setDropDownVisible(false);
        } else if (this._selectedIndex != -1) {
            this._fireActiveEvent(-1, this._selectedIndex);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                Dimension dimension = this.getSize();
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (n2 < 0 || n2 > dimension.width || n3 < 0 || n3 > dimension.height) break;
                this.requestFocus();
                this._button.simulatePush();
                this.toggleDropDown();
                mouseEvent.consume();
                break;
            }
            case 502: {
                this.processMouseReleased(mouseEvent);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || mouseEvent.getID() != 506 || !this.isEnabled()) {
            return;
        }
        this.processMouseDrag(mouseEvent);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this._keyTyped(keyEvent);
                break;
            }
            case 401: {
                this._keyPressed(keyEvent);
                break;
            }
            case 402: {
                this._keyReleased(keyEvent);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",current=" + this.getSelectedItem();
    }

    protected void updateListUI() {
        this._list = null;
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this.isDropDownVisible()) {
            n |= 2;
        }
        return n;
    }

    protected void toggleDropDown() {
        boolean bl = !this.isDropDownVisible();
        this.setDropDownVisible(bl);
    }

    protected void updateButtonEnabled() {
        this._button.setEnabled(this.isEnabled() && this.allowDropDown());
    }

    protected void fireItemEvent(String string, int n) {
        ItemEvent itemEvent = new ItemEvent(this, 701, string, n);
        this.processEvent(itemEvent);
    }

    protected boolean isDropDownVisible() {
        return this._isDropDownVisible;
    }

    void processMouseDrag(MouseEvent mouseEvent) {
        if (!this.isDropDownVisible()) {
            return;
        }
        LWDataSourceList lWDataSourceList = this.getList();
        Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
        Point point2 = lWDataSourceList.getLocationOnScreen();
        int n = mouseEvent.getX() + point.x - point2.x;
        int n2 = mouseEvent.getY() + point.y - point2.y;
        Dimension dimension = lWDataSourceList.getSize();
        if (!(this._dragging || n >= 0 && n <= dimension.width && n2 >= 0 && n2 <= dimension.height)) {
            return;
        }
        Point point3 = lWDataSourceList.getContent().getLocationOnScreen();
        mouseEvent.translatePoint(point.x - point3.x, point.y - point3.y);
        this._listListener.mouseMoved(mouseEvent);
        this._dragging = true;
        mouseEvent.consume();
    }

    void processMouseReleased(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        if (l - this._popMillis < 400L) {
            mouseEvent.consume();
            return;
        }
        if (this._dragging) {
            Point point = this.getLocationOnScreen();
            Point point2 = this.getList().getLocationOnScreen();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            mouseEvent.translatePoint(n, n2);
            this._listListener.mouseReleased(mouseEvent);
            mouseEvent.consume();
        }
        this._dragging = false;
    }

    LWDataSourceList getList() {
        if (this._list == null) {
            ChoiceUI choiceUI = this.getChoiceUI();
            if (this._items != null) {
                this._items.removeDataSourceListener(this._listen);
            }
            LWDataSourceList lWDataSourceList = choiceUI.createList(this, this._items);
            if (this._items != null) {
                this._items.addDataSourceListener(this._listen);
            }
            lWDataSourceList.setFocusTraversable(false);
            this._listListener = new ListListener();
            lWDataSourceList.getContent().addMouseMotionListener(this._listListener);
            lWDataSourceList.getContent().addMouseListener(this._listListener);
            this._list = lWDataSourceList;
        }
        return this._list;
    }

    private void _keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.getItemCount() - 1;
        int n3 = this.getList().getRows();
        int n4 = -1;
        int n5 = !this.isDropDownVisible() ? this.getSelectedIndex() : this.getList().getSelectedIndex();
        this._keyChar = keyEvent.getKeyChar();
        switch (n) {
            case 40: {
                if (keyEvent.isAltDown()) {
                    this.toggleDropDown();
                    n4 = n5;
                    break;
                }
            }
            case 39: {
                if (n5 == -1) {
                    n4 = 0;
                    break;
                }
                if (n5 >= this.getItemCount() - 1) break;
                n4 = n5 + 1;
                break;
            }
            case 38: {
                if (keyEvent.isAltDown()) {
                    this.toggleDropDown();
                    n4 = n5;
                    break;
                }
            }
            case 37: {
                if (n5 == -1) {
                    n4 = 0;
                    break;
                }
                if (n5 <= 0) break;
                n4 = n5 - 1;
                break;
            }
            case 36: {
                if (n5 == 0) break;
                n4 = 0;
                break;
            }
            case 35: {
                if (n5 == n2) break;
                n4 = n2;
                break;
            }
            case 33: {
                if (n5 == 0 || (n4 = n5 - n3) >= 0) break;
                n4 = 0;
                break;
            }
            case 34: {
                if (n5 == n2 || (n4 = n5 + n3) <= n2) break;
                n4 = n2;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                n4 = this.getList().getSelectedIndex();
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this._fireActiveEvent(n5, this.getSelectedIndex());
                this.repaint();
            }
        }
        if (n4 != -1) {
            if (!this.isDropDownVisible()) {
                this.fireItemEvent(this.getItem(n5), 2);
                this.select(n4);
                this.fireItemEvent(this.getItem(n4), 1);
            } else {
                this.getList().select(n4);
                this._fireActiveEvent(n5, n4);
            }
            keyEvent.consume();
        }
    }

    private void _keyTyped(KeyEvent keyEvent) {
        if (this._keyChar != keyEvent.getKeyChar()) {
            return;
        }
        if (this._checkTime(this.getTypeAheadDelay())) {
            this._buffer = null;
        }
        StringBuffer stringBuffer = this._getBuffer();
        stringBuffer.append(keyEvent.getKeyChar());
        int n = this.getSelectedIndex();
        int n2 = stringBuffer.length() == 1 ? n + 1 : n;
        int n3 = this._findItem(n2, stringBuffer.toString());
        if (n3 == -1 && stringBuffer.length() == 2 && stringBuffer.charAt(0) == stringBuffer.charAt(1)) {
            stringBuffer.setLength(1);
            n3 = this._findItem(n + 1, stringBuffer.toString());
        }
        if (n3 != -1 && n3 != n) {
            this.fireItemEvent(this.getItem(n), 2);
            this.select(n3);
            if (this._isDropDownVisible) {
                this.getList().select(n3);
            }
            this.fireItemEvent(this.getItem(n3), 1);
        }
        this._storeTime();
    }

    private void _keyReleased(KeyEvent keyEvent) {
        this._keyChar = StringUtils.CHAR_UNDEFINED;
    }

    private void _storeTime() {
        this._currentTime = System.currentTimeMillis();
    }

    private boolean _checkTime(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - this._currentTime > l;
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    private int _findItem(int n, String string) {
        String string2;
        int n2;
        int n3 = this.getItemCount();
        if (n == -1) {
            n = 0;
        }
        Locale locale = this.getLocale();
        string = string.toUpperCase(locale);
        for (n2 = n; n2 < n3; ++n2) {
            string2 = this.getItem(n2).toUpperCase(locale);
            if (!string2.startsWith(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            string2 = this.getItem(n2).toUpperCase(locale);
            if (!string2.startsWith(string)) continue;
            return n2;
        }
        return -1;
    }

    protected int indexOf(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!this._items.getData(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected Component getEditComponent() {
        return null;
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleAction {
        public Access() {
            super(LWDataSourceChoice.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            int n = 1;
            Component component = LWDataSourceChoice.this.getEditComponent();
            if (component instanceof Accessible) {
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Component component;
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                return LWDataSourceChoice.this.getList();
            }
            if (n == 1 && (component = LWDataSourceChoice.this.getEditComponent()) instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LWDataSourceChoice._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString("TOGGLE_DROP_DOWN");
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                if (LWDataSourceChoice.this.isDropDownVisible()) {
                    int n2 = LWDataSourceChoice.this.getList().getSelectedIndex();
                    int n3 = LWDataSourceChoice.this.getSelectedIndex();
                    LWDataSourceChoice.this.setDropDownVisible(false);
                    if (n2 != -1 && n2 != n3) {
                        LWDataSourceChoice.this.fireItemEvent(LWDataSourceChoice.this.getItem(n3), 2);
                        LWDataSourceChoice.this.select(n2);
                        LWDataSourceChoice.this.fireItemEvent(LWDataSourceChoice.this.getItem(n2), 1);
                    }
                } else {
                    LWDataSourceChoice.this.setDropDownVisible(true);
                }
                return true;
            }
            return false;
        }
    }

    private class Listen
    extends OneDDataSourceAdapter {
        private Listen() {
        }

        @Override
        public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
            int n;
            int n2 = LWDataSourceChoice.this.getSelectedIndex();
            if (n2 >= (n = oneDDataSourceEvent.getStartIndex())) {
                LWDataSourceChoice.this.setSelectedIndex(n2 + oneDDataSourceEvent.getItemCount());
            } else if (n2 < 0) {
                LWDataSourceChoice.this.select(0);
            }
            LWDataSourceChoice.this.updateButtonEnabled();
        }

        @Override
        public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = LWDataSourceChoice.this.getSelectedIndex();
            int n2 = oneDDataSourceEvent.getStartIndex();
            int n3 = oneDDataSourceEvent.getItemCount();
            if (n >= n2) {
                if (n >= n2 + n3) {
                    LWDataSourceChoice.this.setSelectedIndex(n - n3);
                } else {
                    LWDataSourceChoice.this.setSelectedIndex(LWDataSourceChoice.this.getItemCount() > 0 ? 0 : -1);
                    LWDataSourceChoice.this.repaint();
                }
            }
            LWDataSourceChoice.this.updateButtonEnabled();
        }
    }

    private class ChoiceButton
    extends PushButton {
        public ChoiceButton() {
            this.updateUI(ChoiceButton.class);
        }

        @Override
        protected void updateUI(Class clazz) {
            if (clazz == ChoiceButton.class) {
                this.updateUI();
            }
        }

        @Override
        protected void updateUI(LookAndFeel lookAndFeel) {
            super.updateUI(lookAndFeel);
            this.setBackground(this.getUIDefaults().getColor("ChoiceButton.background"));
        }

        @Override
        protected int getPaintState() {
            int n = super.getPaintState();
            n &= 0xFFFFFFFD;
            if (LWDataSourceChoice.this.isDropDownVisible()) {
                n |= 2;
            }
            return n;
        }

        @Override
        public BorderPainter getBorderPainter() {
            ChoiceUI choiceUI = (ChoiceUI)LWDataSourceChoice.this.getUI();
            if (choiceUI == null) {
                return null;
            }
            return choiceUI.getButtonBorderPainter(LWDataSourceChoice.this);
        }

        @Override
        public Painter getPainter() {
            ChoiceUI choiceUI = (ChoiceUI)LWDataSourceChoice.this.getUI();
            if (choiceUI == null) {
                return null;
            }
            return choiceUI.getButtonPainter(LWDataSourceChoice.this);
        }
    }

    final class KeeperUpper
    extends MouseAdapter {
        private Component _parent;

        public KeeperUpper(Component component) {
            this._parent = component;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            for (Component component = (Component)mouseEvent.getSource(); component != null; component = component.getParent()) {
                if (component != this._parent) continue;
                return;
            }
            if (mouseEvent.getComponent() == LWDataSourceChoice.this.getButton()) {
                mouseEvent.consume();
            }
            LWDataSourceChoice.this.setDropDownVisible(false);
        }
    }

    private class MoveCheck
    extends ComponentAdapter {
        private MoveCheck() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            LWDataSourceChoice.this.setDropDownVisible(false);
        }
    }

    private class ListListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ListListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            LWDataSourceList lWDataSourceList = LWDataSourceChoice.this.getList();
            int n = lWDataSourceList.getItemAt(mouseEvent.getY());
            if (n != -1) {
                lWDataSourceList.select(n);
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
            if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
                return;
            }
            LWDataSourceList lWDataSourceList = LWDataSourceChoice.this.getList();
            int n = lWDataSourceList.getItemAt(mouseEvent.getY());
            if (n == -1) {
                return;
            }
            int n2 = LWDataSourceChoice.this.getSelectedIndex();
            LWDataSourceChoice.this.fireItemEvent(LWDataSourceChoice.this.getItem(n2), 2);
            LWDataSourceChoice.this.select(n);
            LWDataSourceChoice.this.fireItemEvent(LWDataSourceChoice.this.getItem(n), 1);
            LWDataSourceChoice.this.repaint();
            LWDataSourceChoice.this.setDropDownVisible(false);
        }
    }

    private class ButtonListen
    extends MouseAdapter
    implements MouseMotionListener {
        private ButtonListen() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            LWDataSourceChoice.this.processMouseDrag(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!LWDataSourceChoice.this.isEnabled() || !InputEventUtils.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0 || n > dimension.width || n2 < 0 || n2 > dimension.height) {
                return;
            }
            mouseEvent.consume();
            LWDataSourceChoice.this.toggleDropDown();
            LWDataSourceChoice.this.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            LWDataSourceChoice.this.processMouseReleased(mouseEvent);
        }
    }
}

