/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;

class OracleThumbPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _ORIENTATION_GRIPPY_GAP = 1;
    private static final int _PERPENDICULAR_GRIPPY_GAP = 2;
    private static final int _GRIPPY_STRIDE = 4;
    private static final int _MINIMUM_ORIENTATION_GRIPPY_SIZE = 7;
    private static final int _MINIMUM_PERPENDICULAR_GRIPPY_SIZE = 8;
    private static final int _MINIMUM_THUMB_PERPENDICULAR_SIZE = 14;
    private static final int _MINIMUM_THUMB_ORIENTATION_SIZE = 11;
    private boolean _isHorizontal;

    public OracleThumbPainter(boolean bl) {
        this._isHorizontal = bl;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._isHorizontal) {
            return new Dimension(11, 14);
        }
        return new Dimension(14, 11);
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = paintContext.getPaintState();
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL));
        if (this._isHorizontal) {
            ++n2;
            n4 -= 2;
        } else {
            ++n;
            n3 -= 2;
        }
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        graphics.fillRect(n, n2, n3, n4);
        if ((n5 & 4) == 0) {
            boolean bl = (n5 & 1) != 0;
            Color color2 = uIDefaults.getColor(OracleColorScheme.THUMB_HIGHLIGHT);
            if (!bl) {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW));
                graphics.drawLine(n6, n7, n6, n7);
                if (this._isHorizontal) {
                    graphics.drawLine(n6, n2 + 1, n6, n7 - 1);
                } else {
                    graphics.drawLine(n + 1, n7, n6 - 1, n7);
                }
                Color color3 = uIDefaults.getColor(OracleColorScheme.THUMB_SHADOW);
                boolean bl2 = (n5 & 2) != 0;
                int n8 = this._isHorizontal ? 1 : 2;
                int n9 = (this._isHorizontal ? n3 : n4) / (3 * (3 + n8));
                if ((n9 |= 1) < 2) {
                    n9 = 2;
                }
                int n10 = n9 * 3 + (n9 - 1) * n8;
                if (this._isHorizontal) {
                    int n11 = n + (n3 - n10) / 2;
                    int n12 = n2 + (n4 - 8) / 2;
                    int n13 = n12 + 3 + 2;
                    while (n9 > 0) {
                        OracleThumbPainter.__drawGrippy(graphics, n11, n13, color2, color3, bl2);
                        n11 += 4;
                        if (--n9 <= 0) continue;
                        OracleThumbPainter.__drawGrippy(graphics, n11, n12, color2, color3, bl2);
                        --n9;
                        n11 += 4;
                    }
                } else {
                    int n14 = n2 + (n4 - n10) / 2;
                    int n15 = n + (n3 - 8) / 2;
                    int n16 = n15 + 3 + 2;
                    while (n9 > 0) {
                        OracleThumbPainter.__drawGrippy(graphics, n16, n14, color2, color3, bl2);
                        n14 += 4;
                        if (--n9 <= 0) continue;
                        OracleThumbPainter.__drawGrippy(graphics, n15, n14, color2, color3, bl2);
                        --n9;
                        n14 += 4;
                    }
                }
            }
            graphics.setColor(color2);
            graphics.drawLine(n, n2, n6 - 1, n2);
            graphics.drawLine(n, n2, n, n7 - 1);
        }
        graphics.setColor(color);
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 7;
    }

    static void __drawGrippy(Graphics graphics, int n, int n2, Color color, Color color2, boolean bl) {
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2 + 2, n + 2, n2 + 1);
        if (bl) {
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
            n -= 2;
            n2 -= 2;
        } else {
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        }
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2 + 3, n + 3, n2 + 2);
    }
}

