/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.Grid;
import oracle.ewt.laf.basic.BasicGridSeparator;
import oracle.ewt.laf.basic.GridDisablingPainter;
import oracle.ewt.laf.basic.GridFocusPainter;
import oracle.ewt.laf.basic.GridImageSetPainter;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.OracleGridBorderPainter;
import oracle.ewt.laf.oracle.OracleUIUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.plaf.GridUI;
import oracle.ewt.util.ImmInsets;

public class OracleGridUI
extends OracleComponentUI
implements GridUI {
    private static final BorderPainter[] _sBorderPainters = new BorderPainter[16];
    private static Painter _sDefaultPainter;
    private static final ImmInsets _sDefaultInsets;

    public OracleGridUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public void installUI(LWComponent lWComponent) {
        Grid grid = (Grid)lWComponent;
        grid.setOverlayBorderVisible(false);
        int n = grid.isUpperLeft() | grid.isLowerLeft() ? 2 : 1;
        int n2 = grid.isUpperLeft() | grid.isUpperRight() ? 2 : 1;
        int n3 = grid.isLowerLeft() | grid.isLowerRight() ? 2 : 1;
        int n4 = grid.isUpperRight() | grid.isLowerRight() ? 2 : 1;
        grid.setHScrollInsets(n, n4);
        grid.setVScrollInsets(n2, n3);
        grid.setVerticalSeparatorPainter(BasicGridSeparator.getVerticalSeparator());
        grid.setHorizontalSeparatorPainter(BasicGridSeparator.getHorizontalSeparator());
    }

    @Override
    public Painter getDefaultPainter(LWComponent lWComponent) {
        return OracleGridUI._getDefaultPainter();
    }

    @Override
    public BorderPainter getFocusCellPainter(LWComponent lWComponent) {
        return GridFocusPainter.getBorderPainter();
    }

    @Override
    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        return OracleUIUtils.getWideInsetBorderPainter();
    }

    @Override
    public BorderPainter getOverlayBorderPainter(LWComponent lWComponent) {
        Grid grid = (Grid)lWComponent;
        return OracleGridUI._getBorderPainter(grid.isUpperLeft(), grid.isUpperRight(), grid.isLowerLeft(), grid.isLowerRight());
    }

    @Override
    public int getDefaultRowHeight(LWComponent lWComponent) {
        Font font = lWComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = lWComponent.getFontMetrics(font);
            n = fontMetrics.getHeight() + 3 + 3;
        }
        return n;
    }

    @Override
    public int getDefaultColumnWidth(LWComponent lWComponent) {
        Font font = lWComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = lWComponent.getFontMetrics(font);
            n = fontMetrics.stringWidth("12345678");
        }
        return n;
    }

    @Override
    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        Appearance appearance = new Appearance();
        appearance.setForeground(uIDefaults.getColor(LookAndFeel.TEXT_TEXT));
        appearance.setBackground(uIDefaults.getColor(OracleColorScheme.GRID));
        appearance.setSelectForeground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        appearance.setSelectBackground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        appearance.setInsets(_sDefaultInsets);
        return appearance;
    }

    @Override
    public Color getSelectionBackgroundColor(LWComponent lWComponent, Color color) {
        if (!lWComponent.isActive() || !lWComponent.isEnabled()) {
            return this.getUIDefaults(lWComponent).getColor(LookAndFeel.TEXT_INACTIVE_HIGHLIGHT);
        }
        return color;
    }

    @Override
    public Color getDisabledBackgroundColor(LWComponent lWComponent) {
        if (!lWComponent.isEnabled()) {
            return this.getUIDefaults(lWComponent).getColor(LookAndFeel.CONTROL);
        }
        return lWComponent.getBackground();
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("DefaultCellPainter".equals(object)) {
            return OracleGridUI._getDefaultPainter();
        }
        if ("Grid.checkPainter".equals(object)) {
            return new GridImageSetPainter("checkboxSet");
        }
        if ("Grid.radioPainter".equals(object)) {
            return new GridImageSetPainter("radioButtonSet");
        }
        return null;
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new GridDisablingPainter(new TruncatingTextPainter(PaintContext.LABEL_KEY, false));
        }
        return _sDefaultPainter;
    }

    private static BorderPainter _getBorderPainter(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        if (!bl) {
            n += 8;
        }
        if (!bl2) {
            n += 4;
        }
        if (!bl3) {
            n += 2;
        }
        if (!bl4) {
            ++n;
        }
        if (_sBorderPainters[n] == null) {
            OracleGridUI._sBorderPainters[n] = new OracleGridBorderPainter(bl, bl2, bl3, bl4, bl3 && bl4, bl2 && bl4);
        }
        return _sBorderPainters[n];
    }

    static {
        _sDefaultInsets = new ImmInsets(3, 3, 3, 1);
    }
}

