/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeButtonDecoration;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeLineDecoration;
import oracle.ewt.dTree.DTreeStackingDecoration;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.basic.TreeDropHighlightPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.LinePainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.plaf.TreeUI;
import oracle.ewt.util.ImmInsets;

public abstract class BasicTreeUI
extends BasicComponentUI
implements TreeUI {
    private Painter _itemPainter;
    private Painter _afterItemPainter;
    private Painter _beforeItemPainter;
    private Painter _textPainter;
    private ImmInsets _selectionInsets = new ImmInsets(1, 1, 1, 1);
    private ImmInsets _focusInsets = new ImmInsets(2, 2, 2, 2);
    private static final int _ICON_OFFSET = 1;
    private static final int _EXPAND_TOP_OFFSET = 2;

    public BasicTreeUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public Rectangle getEditBounds(LWComponent lWComponent, PaintContext paintContext, DTreeItem dTreeItem) {
        Painter painter = this.getTextPainter();
        Dimension dimension = painter.getMinimumSize(paintContext);
        Dimension dimension2 = dTreeItem.getSize();
        ImmInsets immInsets = this.getSelectionInsets();
        ImmInsets immInsets2 = this.getFocusInsets();
        dimension.height += immInsets.top + immInsets.bottom + immInsets2.top + immInsets2.bottom;
        dimension.width += immInsets.left + immInsets.right + immInsets2.left + immInsets2.right;
        return new Rectangle(immInsets.left + immInsets2.left + dimension2.width - dimension.width, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    @Override
    public Painter getItemPainter(LWComponent lWComponent, DTreeItem dTreeItem) {
        Painter painter = this._getItemPainter();
        DTree dTree = (DTree)lWComponent;
        DTreeItem dTreeItem2 = dTree.getDropHighlightItem();
        if (dTreeItem2 == dTreeItem) {
            int n = dTree.getDropHighlightStyle();
            if (n == 2) {
                if (this._beforeItemPainter == null) {
                    this._beforeItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), true);
                }
                painter = this._beforeItemPainter;
            } else if (n == 3) {
                if (this._afterItemPainter == null) {
                    this._afterItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), false);
                }
                painter = this._afterItemPainter;
            }
        }
        return painter;
    }

    @Override
    public int getDeferredChildHeight(LWComponent lWComponent, PaintContext paintContext, DTreeDeferringParent dTreeDeferringParent, int n) {
        Font font = paintContext.getPaintFont();
        FontMetrics fontMetrics = null;
        if (font == null || (fontMetrics = paintContext.getFontMetrics(font)) == null) {
            return 0;
        }
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        ImmInsets immInsets = this.getSelectionInsets();
        ImmInsets immInsets2 = this.getFocusInsets();
        return Math.max(n, n2 += immInsets.top + immInsets.bottom + immInsets2.top + immInsets2.bottom);
    }

    @Override
    public Image getMultiItemDragImage(LWComponent lWComponent) {
        return (Image)((DTree)lWComponent).getUIDefaults().get("Tree.multiItemDrag");
    }

    @Override
    public void installUI(LWComponent lWComponent) {
        DTree dTree = (DTree)lWComponent;
        DTreeButtonDecoration dTreeButtonDecoration = new DTreeButtonDecoration();
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        DTreeLineDecoration dTreeLineDecoration = new DTreeLineDecoration(new LinePainter(true, this.isLineDotted()), new LinePainter(false, this.isLineDotted()), uIDefaults.getColor(LookAndFeel.DARK_INTENSITY));
        dTree.setDecoration(new DTreeStackingDecoration(dTreeLineDecoration, dTreeButtonDecoration));
    }

    public Painter getTextPainter() {
        if (this._textPainter == null) {
            this._textPainter = this.createTextPainter();
        }
        return this._textPainter;
    }

    protected abstract Painter createItemPainter();

    protected ImmInsets getSelectionInsets() {
        return this._selectionInsets;
    }

    protected ImmInsets getFocusInsets() {
        return this._focusInsets;
    }

    protected boolean isLineDotted() {
        return false;
    }

    protected Painter createTextPainter() {
        return new TextPainter();
    }

    private Painter _getItemPainter() {
        if (this._itemPainter == null) {
            this._itemPainter = this.createItemPainter();
        }
        return this._itemPainter;
    }
}

