/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.header;

import oracle.ewt.header.Header;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

class AutoScroller
implements Task {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static AutoScroller _sAutoScroller;
    private Header _scrollee;
    private boolean _decrease;
    private boolean _cancel;
    private int _newIndex;

    public static AutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new AutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(Header header, boolean bl) {
        this._scrollee = header;
        this._decrease = bl;
        this._cancel = false;
        TaskScheduler.getDefaultTaskScheduler().schedule(this, 200);
    }

    @Override
    public void runTask(TaskEvent taskEvent) {
        if (this._cancel) {
            return;
        }
        if (this._decrease) {
            this._newIndex = this._scrollee.isHorizontal() ? this._scrollee.getItemAt(this._scrollee.getInnerOrigin().x, 0) : this._scrollee.getItemAt(0, this._scrollee.getInnerOrigin().y);
            this._newIndex = this._scrollee.getPreviousVisibleItem(this._newIndex);
            if (this._newIndex == -1) {
                return;
            }
        } else {
            int n = this._scrollee.getItemCount() - 1;
            if (this._scrollee.isHorizontal()) {
                int n2 = this._scrollee.getInnerOrigin().x + this._scrollee.getInnerSize().width;
                this._newIndex = this._scrollee.getItemAt(n2, 0);
            } else {
                int n3 = this._scrollee.getInnerOrigin().y + this._scrollee.getInnerSize().height;
                this._newIndex = this._scrollee.getItemAt(0, n3);
            }
            if (this._newIndex != -1) {
                this._newIndex = this._scrollee.getNextVisibleItem(this._newIndex);
            }
            if (this._newIndex == -1) {
                return;
            }
        }
        this._scrollee.scrollItemIntoView(this._newIndex);
        TaskScheduler.getDefaultTaskScheduler().schedule(this, 100);
    }

    public void cancel() {
        this._cancel = true;
        TaskScheduler.getDefaultTaskScheduler().cancel(this);
    }

    public void cancel(Header header) {
        if (this._scrollee == header) {
            this.cancel();
        }
    }

    public Header getScrollee() {
        return this._scrollee;
    }

    protected AutoScroller() {
    }

    protected int getNewIndex() {
        return this._newIndex;
    }

    protected boolean isCancelled() {
        return this._cancel;
    }
}

