/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarCheck;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.util.LocaleUtils;

public class FontBar
extends LWComponent {
    public static final String PROPERTY_SELECTED_FONT = "_selectedFont";
    private Font _font;
    private LWLabel _faceLabel = new LWLabel();
    private LWChoice _faceChoice = new LWChoice();
    private LWLabel _sizeLabel;
    private ComboBox _sizeChoice;
    private ToolBarCheck _boldCheck;
    private ToolBarCheck _italicCheck;
    private PropertyChangeSupport _changeSupport;
    private static int[] _SIZES = new int[]{8, 9, 10, 12, 14, 18, 24, 36, 48};
    private static final String _FACE_KEY = "FACE";
    private static final String _SIZE_KEY = "SIZE";
    private static final String _BOLD_IMAGE = "images/bold.gif";
    private static final String _ITALIC_IMAGE = "images/italic.gif";

    public FontBar() {
        this(null);
    }

    public FontBar(Font font) {
        Insets insets;
        int n;
        this._faceLabel.setLabelFor(this._faceChoice);
        String[] stringArray = this.getToolkit().getFontList();
        for (n = 0; n < stringArray.length; ++n) {
            this._faceChoice.addItem(stringArray[n]);
        }
        this._sizeLabel = new LWLabel();
        this._sizeChoice = new ComboBox();
        this._sizeLabel.setLabelFor(this._sizeChoice);
        for (n = 0; n < _SIZES.length; ++n) {
            this._sizeChoice.addItem(IntegerUtils.getString((int)_SIZES[n]));
        }
        ToolBar toolBar = new ToolBar();
        toolBar.setBorderPainter(null);
        Image image = ImageUtils.getImageResource(FontBar.class, _BOLD_IMAGE);
        this._boldCheck = new ToolBarCheck(0, image);
        image = ImageUtils.getImageResource(FontBar.class, _ITALIC_IMAGE);
        this._italicCheck = new ToolBarCheck(0, image);
        toolBar.addItem(this._boldCheck);
        toolBar.addItem(this._italicCheck);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.add((Component)this._faceLabel, gridBagConstraints);
        this.add((Component)this._faceChoice, gridBagConstraints);
        Insets insets2 = gridBagConstraints.insets;
        gridBagConstraints.insets = insets = new Insets(0, 10, 0, 0);
        this.add((Component)this._sizeLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        this.add((Component)this._sizeChoice, gridBagConstraints);
        insets2 = gridBagConstraints.insets;
        gridBagConstraints.insets = insets;
        this.add((Component)toolBar, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        Listener listener = new Listener();
        this._faceChoice.addItemListener(listener);
        this._sizeChoice.addItemListener(listener);
        this._boldCheck.addToolBarActionListener(listener);
        this._italicCheck.addToolBarActionListener(listener);
        this.setSelectedFont(font);
    }

    public Font getSelectedFont() {
        return this._font;
    }

    public void setSelectedFont(Font font) {
        if (font != this._font) {
            Font font2 = this._font;
            this._font = font;
            String string = "";
            int n = 0;
            int n2 = 0;
            if (font != null) {
                string = font.getFamily();
                n = font.getStyle();
                n2 = font.getSize();
            }
            this._faceChoice.select(string);
            this._sizeChoice.select(IntegerUtils.getString((int)n2));
            this._boldCheck.setState((n & 1) != 0);
            this._italicCheck.setState((n & 2) != 0);
            this.firePropertyChange(PROPERTY_SELECTED_FONT, font2, this._font);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getSelectedFont() == null) {
            this.setSelectedFont(this.getFont());
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, object, object2);
        }
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._loadMessages(locale);
    }

    void __updateFont() {
        String string = this._faceChoice.getSelectedItem();
        int n = 0;
        try {
            n = Integer.valueOf(this._sizeChoice.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            Font font = this.getSelectedFont();
            if (font == null) {
                font = this.getFont();
            }
            n = font.getSize();
        }
        int n2 = 0;
        if (this._boldCheck.getState()) {
            n2 |= 1;
        }
        if (this._italicCheck.getState()) {
            n2 |= 2;
        }
        this.setSelectedFont(new Font(string, n2, n));
    }

    private void _loadMessages(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.font.resource.FontBundle", LocaleUtils.getTranslationLocale(locale));
        this._faceLabel.setText(resourceBundle.getString(_FACE_KEY));
        this._sizeLabel.setText(resourceBundle.getString(_SIZE_KEY));
    }

    private class Listener
    implements ItemListener,
    ToolBarActionListener {
        private Listener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            FontBar.this.__updateFont();
        }

        @Override
        public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
            FontBar.this.__updateFont();
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(FontBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.FONT_CHOOSER;
        }
    }
}

