/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.dialog.directory.DirectoryFilter;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.event.ListenerManager;

class FileDataSource
implements OneDDataSource {
    private DirectoryDialog _dialog;
    private File _directory;
    private File[] _files;
    private ListenerManager _listeners;

    public FileDataSource(DirectoryDialog directoryDialog, File file, FilenameFilter filenameFilter) {
        this._dialog = directoryDialog;
        this._directory = file;
    }

    public File createDirectory(String string) {
        File file = new File(this._directory, string);
        if (!(file.exists() || file.mkdir() && file.exists())) {
            return null;
        }
        if (this._files != null) {
            int n;
            StringComparator stringComparator = new StringComparator(Collator.getInstance(Locale.getDefault()));
            for (n = 0; n < this._files.length; ++n) {
                try {
                    int n2 = stringComparator.compare((Object)file.getCanonicalPath(), (Object)this._files[n].getCanonicalPath());
                    if (n2 == 0) {
                        return file;
                    }
                    if (n2 >= 0) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            File[] fileArray = new File[this._files.length + 1];
            System.arraycopy(this._files, 0, fileArray, 0, n);
            System.arraycopy(this._files, n, fileArray, n + 1, this._files.length - n);
            fileArray[n] = file;
            this._files = fileArray;
            this._fireItemsAdded(n, 1);
        }
        return file;
    }

    @Override
    public int getItemCount() {
        if (this._files != null) {
            return this._files.length;
        }
        return 0;
    }

    @Override
    public Object getData(int n) {
        return this._files[n];
    }

    @Override
    public void setData(int n, Object object) {
    }

    @Override
    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(oneDDataSourceListener);
    }

    @Override
    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._listeners != null) {
            this._listeners.removeListener(oneDDataSourceListener);
        }
    }

    public void itemExpanding() {
        if (this._files == null) {
            if (!this._dialog.isDirectoryBrowsable(this._directory)) {
                this._files = new File[0];
                return;
            }
            Object[] objectArray = FileUtils.list(this._directory, DirectoryFilter.getInstance());
            if (objectArray != null) {
                StringComparator stringComparator = new StringComparator(Collator.getInstance(Locale.getDefault()));
                Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)stringComparator);
                this._files = new File[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    this._files[i] = new File(this._directory, (String)objectArray[i]);
                }
            }
        }
    }

    private void _fireItemsAdded(int n, int n2) {
        Enumeration enumeration;
        if (this._listeners != null && (enumeration = this._listeners.getListeners()) != null) {
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, n2);
            while (enumeration.hasMoreElements()) {
                OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
                oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
            }
        }
    }
}

