/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.util.ArrayList;
import java.util.Vector;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ReferenceList
extends XMLElement {
    private StringBuilder validationErrorMessage = new StringBuilder();
    private StringBuilder signatureDetails = new StringBuilder();
    private ArrayList<byte[]> preDigestedData;

    protected ReferenceList(Element element) throws DOMException {
        super(element);
    }

    protected ReferenceList(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected ReferenceList(Document owner, String tagName) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", tagName);
    }

    protected ReferenceList(Document owner, String tagName, String id) throws DOMException {
        this(owner, tagName);
        if (id != null) {
            this.setId(id);
        }
    }

    public void addReference(XSReference ref) throws DOMException {
        this.appendChild(ref);
    }

    public Vector getReferences() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        Vector<XSReference> list = new Vector<XSReference>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            XSReference r = new XSReference((Element)nList.item(i));
            r.setSystemId(this.systemId);
            list.addElement(r);
        }
        return list;
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void computeRefDigests() throws ReferenceException {
        Vector refs = this.getReferences();
        this.preDigestedData = new ArrayList(refs.size());
        try {
            int n = refs.size();
            for (int i = 0; i < n; ++i) {
                XSReference ref = (XSReference)refs.elementAt(i);
                ref.computeDigest();
                this.signatureDetails.append((CharSequence)ref.getSignatureDetails());
                this.preDigestedData.add(ref.getDigestedData());
            }
        }
        catch (AlgorithmIdentifierException ex) {
            throw new ReferenceException(ex);
        }
        catch (DOMException ex) {
            throw new ReferenceException(ex);
        }
    }

    public boolean validateRefDigests(boolean validateManifests) throws ReferenceException {
        Vector refs = this.getReferences();
        this.preDigestedData = new ArrayList(refs.size());
        int n = refs.size();
        for (int i = 0; i < n; ++i) {
            XSReference ref = (XSReference)refs.elementAt(i);
            boolean result = ref.validate(validateManifests);
            this.signatureDetails.append((CharSequence)ref.getSignatureDetails());
            if (!result) {
                this.validationErrorMessage.append((CharSequence)ref.getValidationErrorMessage());
                return false;
            }
            this.preDigestedData.add(ref.getDigestedData());
        }
        return true;
    }

    public ArrayList<byte[]> getPreDigestedData() {
        return this.preDigestedData;
    }

    public StringBuilder getValidationErrorMessage() {
        return this.validationErrorMessage;
    }

    public StringBuilder getSignatureDetails() {
        return this.signatureDetails;
    }
}

