/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.InputStream;
import oracle.jdevimpl.xml.dtd.parser.XMLByteReader;

class XMLUCS4Reader
extends XMLByteReader {
    boolean surrogate = false;

    XMLUCS4Reader(InputStream inputstream, String s, String s1) {
        super(inputstream, s, s1);
    }

    @Override
    void fillBuffer() throws IOException {
        while (true) {
            try {
                while (true) {
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    this.charBuffer[this.endPos] = this.nextChar();
                    this.byteIndex += 4;
                    ++this.endPos;
                    if (this.charBuffer[this.endPos - 1] != '\r' && this.charBuffer[this.endPos - 1] != '\n') continue;
                    char c = this.charBuffer[this.endPos - 1];
                    this.setLineNumber(this.endPos - 1);
                    this.charBuffer[this.endPos - 1] = 10;
                    this.charBuffer[this.endPos] = this.nextChar();
                    this.byteIndex += 4;
                    if (c != '\r' || this.charBuffer[this.endPos] == '\n') continue;
                    ++this.endPos;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    char nextChar() throws IOException {
        int i = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 24 | (this.byteBuffer[this.byteIndex + this.second] & 0xFF) << 16 | (this.byteBuffer[this.byteIndex + this.third] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.fourth] & 0xFF;
        if (i >= 55296 && i < 57344 || i > 0x10FFFF) {
            String s = this.err.getMessage1(171, Integer.toHexString(i));
            throw new IOException(s);
        }
        if (i >= 65536) {
            if (!this.surrogate) {
                i = (i - 65536 >> 10) + 55296;
                this.surrogate = true;
                this.byteIndex -= 4;
            } else {
                i = (i - 65536 & 0x3FF) + 56320;
                this.surrogate = false;
            }
        }
        if (i == 65535 || i == 65534) {
            String s1 = this.err.getMessage1(171, Integer.toHexString(i));
            throw new IOException(s1);
        }
        return (char)i;
    }

    @Override
    void reset() {
        this.surrogate = false;
        super.reset();
    }

    @Override
    void setByteOrder(int i) {
        if (i == 1) {
            this.first = 3;
            this.second = 2;
            this.third = 1;
            this.fourth = 0;
        } else if (i == 3) {
            this.first = 1;
            this.second = 0;
            this.third = 3;
            this.fourth = 2;
        } else if (i == 4) {
            this.first = 2;
            this.second = 3;
            this.third = 0;
            this.fourth = 1;
        }
    }
}

