/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.functions;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.functions.GetTranslatedStringFunction;

public class GetTranslatedStringOrNullFunction
implements MetadataFunction {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata.MetadataEvaluator");

    @Override
    public Object evaluate(Map implicitObjects, Object[] args) {
        String resourceKey = (String)args[0];
        ResourceBundle bundle = GetTranslatedStringFunction.__getBundle(implicitObjects);
        try {
            return GetTranslatedStringFunction.__getFromBundle(resourceKey, bundle);
        }
        catch (Exception e) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                XmlKey key = (XmlKey)implicitObjects.get("key");
                LogRecord lr = new LogRecord(Level.FINER, "Could not find bundle key {0}; XmlKey whose metadata was requested={1}");
                lr.setParameters(new Object[]{args[0], key});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
            return null;
        }
    }

    @Override
    public Class[] getArgumentTypes() {
        return new Class[]{String.class};
    }

    @Override
    public Class getReturnType() {
        return String.class;
    }

    @Override
    public boolean isMacro() {
        return true;
    }
}

