/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.functions;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.functions.GetTranslatedStringFunction;

public class GetTranslatedStringByConventionFunction
implements MetadataFunction {
    private final GetTranslatedStringFunction _function = new GetTranslatedStringFunction();
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata.MetadataEvaluator");

    @Override
    public Object evaluate(Map implicitObjects, Object[] args) {
        String second;
        String front;
        if (args.length != 1) {
            throw new IllegalArgumentException("requires one argument, the key 'middle'");
        }
        ResourceBundle bundle = GetTranslatedStringFunction.__getBundle(implicitObjects);
        if (bundle == null) {
            return null;
        }
        String middle = String.valueOf(args[0]);
        XmlKey key = (XmlKey)implicitObjects.get("key");
        String ownerName = null;
        switch (key.getNodeType()) {
            case 1: {
                front = "ELEM";
                break;
            }
            case 2: {
                front = "ATTR";
                QualifiedName elementQName = key.getElementQName();
                if (elementQName == null) break;
                ownerName = elementQName.getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be attr or element; was: " + key);
            }
        }
        String localName = key.getLocalName();
        String first = this._attempt(bundle, front, middle, ownerName, localName);
        if (first != null) {
            return first;
        }
        if (ownerName != null && (second = this._attempt(bundle, front, middle, null, localName)) != null) {
            return second;
        }
        return null;
    }

    @Override
    public Class[] getArgumentTypes() {
        return this._function.getArgumentTypes();
    }

    @Override
    public Class getReturnType() {
        return this._function.getReturnType();
    }

    @Override
    public boolean isMacro() {
        return this._function.isMacro();
    }

    private String _attempt(ResourceBundle bundle, String front, String middle, String ownerName, String localName) {
        int len = front.length() + 1 + middle.length() + 1 + localName.length();
        if (ownerName != null) {
            len += 1 + ownerName.length();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(front);
        sb.append('_');
        sb.append(middle);
        sb.append('_');
        if (ownerName != null) {
            sb.append(ownerName);
            sb.append('_');
        }
        sb.append(localName);
        String key = sb.toString();
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "Failed to find resource by convention. Key={0} Bundle={1}", new Object[]{key, bundle});
            }
            return null;
        }
    }
}

