/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTOperand;

final class ASTConstant
extends ASTOperand {
    public static final ASTConstant NULL = new ASTConstant(null);
    public static final ASTConstant TRUE = new ASTConstant(Boolean.TRUE);
    public static final ASTConstant FALSE = new ASTConstant(Boolean.FALSE);
    private final Object _value;

    public ASTConstant(Object value) {
        this._value = value;
    }

    @Override
    public Object getValue(VariableResolver vResolver) {
        return this._value;
    }

    public Object getValue() {
        return this._value;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Class getType(VariableResolver resolver) {
        return this._value != null ? this._value.getClass() : Object.class;
    }

    @Override
    protected void toString(StringBuffer buffer) {
        if (this._value == null) {
            buffer.append("null");
        } else if (String.class.equals(this._value.getClass())) {
            buffer.append('\'');
            buffer.append(this._value);
            buffer.append('\'');
        } else {
            buffer.append(this._value);
        }
    }
}

