/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;
import oracle.bali.xml.share.WeakListenerManager;

public abstract class GrammarProvider {
    private final Manager _listenerManager = new Manager();

    public abstract Map getGrammarMap();

    public Grammar getGrammarForNamespace(String targetNamespace) {
        return (Grammar)this.getGrammarMap().get(targetNamespace);
    }

    public Collection getGrammars() {
        ArrayList grammars = new ArrayList(this.getGrammarMap().values());
        return Collections.unmodifiableCollection(grammars);
    }

    public final void addGrammarProviderListener(GrammarProviderListener l) {
        this._listenerManager.addListener(l);
    }

    public final void removeGrammarProviderListener(GrammarProviderListener l) {
        this._listenerManager.removeListener(l);
    }

    protected GrammarProviderEvent createEvent() {
        return new GrammarProviderEvent(this);
    }

    protected void fireEvent(GrammarProviderEvent event) {
        if (this._listenerManager.areListenersAttached() && event != null && !event.isEmpty()) {
            event.prepareForDelivery();
            this._listenerManager.notifyListeners(event);
        }
    }

    protected void fireEvent(Set grammarsAdded, Set grammarsRemoved, Set grammarsChanged) {
        GrammarProviderEvent event = new GrammarProviderEvent(this, grammarsAdded, grammarsRemoved, grammarsChanged);
        this.fireEvent(event);
    }

    protected void fireGrammarAddedEvent(Grammar grammar) {
        GrammarProviderEvent event = new GrammarProviderEvent(this);
        event.notifyGrammarAdded(grammar);
        this.fireEvent(event);
    }

    protected void fireGrammarRemovedEvent(Grammar grammar) {
        GrammarProviderEvent event = new GrammarProviderEvent(this);
        event.notifyGrammarRemoved(grammar);
        this.fireEvent(event);
    }

    protected void fireGrammarChangedEvent(Grammar grammar) {
        GrammarProviderEvent event = new GrammarProviderEvent(this);
        event.notifyGrammarChanged(grammar);
        this.fireEvent(event);
    }

    protected void firstListenerAttached() {
    }

    protected void lastListenerDetached() {
    }

    private class Manager
    extends WeakListenerManager {
        public Manager() {
            super(GrammarProvider.this.toString());
        }

        @Override
        protected void notifyListenerImpl(Object listener, Object event, Object deliveryHint) {
            ((GrammarProviderListener)listener).grammarProviderChanged((GrammarProviderEvent)event);
        }

        @Override
        protected void areListenersAttachedChanged() {
            if (this.areListenersAttached()) {
                GrammarProvider.this.firstListenerAttached();
            } else {
                GrammarProvider.this.lastListenerDetached();
            }
        }
    }
}

