/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.ide.quickdiff.QuickDiffController;
import oracle.ide.quickdiff.QuickDiffManager;
import oracle.ide.quickdiff.QuickDiffMargin;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.QuickDiffReferenceRegistry;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.editor.BasicEditorPane;

class QuickDiffContextMenuListener
implements ContextMenuListener {
    private static final float SECTION_QUICKDIFF = 4.5f;

    QuickDiffContextMenuListener() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        boolean enabled;
        Context context = contextMenu.getContext();
        if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
            return;
        }
        BasicEditorPane editorPane = QuickDiffController.getEditorPane(context);
        if (editorPane == null) {
            return;
        }
        URL url = context.getNode().getURL();
        if (url == null) {
            return;
        }
        if (FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)url)) != ContentType.TEXT) {
            return;
        }
        QuickDiffMargin margin = this.getQuickDiffMargin(editorPane);
        if (margin.isTurnedOff()) {
            IdeAction turnOffQuickDiffAction = IdeAction.find((int)QuickDiffManager.TURNOFF_QUICKDIFF_CMD_ID);
            contextMenu.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)turnOffQuickDiffAction), 4.5f, false);
            return;
        }
        boolean bl = enabled = margin != null && margin.isVisible();
        if (!enabled) {
            IdeAction enableQuickDiffAction = IdeAction.find((int)QuickDiffManager.ENABLE_QUICKDIFF_CMD_ID);
            contextMenu.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)enableQuickDiffAction), 4.5f, false);
            return;
        }
        IdeAction disableQuickDiffAction = IdeAction.find((int)QuickDiffManager.DISABLE_QUICKDIFF_CMD_ID);
        contextMenu.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)disableQuickDiffAction), 4.5f, false);
        JMenu referenceSubMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)QuickDiffArb.getString(6)), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)QuickDiffArb.getString(6))));
        QuickDiffReferenceProvider currentProvider = QuickDiffManager.getInstance().getProviderObservable().getProvider();
        ArrayList<QuickDiffReferenceProvider> providers = new ArrayList<QuickDiffReferenceProvider>();
        for (String id : QuickDiffReferenceRegistry.keySet()) {
            providers.add(QuickDiffReferenceRegistry.lookup(id));
        }
        Collections.sort(providers, new Comparator<QuickDiffReferenceProvider>(){

            @Override
            public int compare(QuickDiffReferenceProvider p1, QuickDiffReferenceProvider p2) {
                return StringUtils.stripMnemonic((String)p1.getName()).compareTo(StringUtils.stripMnemonic((String)p2.getName()));
            }
        });
        for (QuickDiffReferenceProvider provider : providers) {
            if (!provider.isAvailable(url) && currentProvider != provider) continue;
            JCheckBoxMenuItem referenceMenuItem = new JCheckBoxMenuItem(new SelectReferenceAction(provider));
            referenceMenuItem.setSelected(currentProvider == provider);
            referenceMenuItem.setEnabled(provider.isAvailable(url));
            Ide.getMenubar().add((Component)referenceMenuItem, referenceSubMenu, provider.getMenuSection());
        }
        new MnemonicSolver(referenceSubMenu).solve();
        contextMenu.add((Component)referenceSubMenu, 4.5f, false);
        EventObject eo = context.getEvent();
        if (!(eo instanceof MouseEvent)) {
            return;
        }
        if (eo.getSource() != margin) {
            return;
        }
        Action[] editActions = margin.getEditActions((MouseEvent)eo);
        if (editActions == null) {
            return;
        }
        for (Action editAction : editActions) {
            editAction.setEnabled(!URLFileSystem.isReadOnly((URL)url) || VCSManager.getVCSManager().canCheckOut(url));
        }
        for (Action editAction : editActions) {
            contextMenu.add((Component)(editAction instanceof ToggleAction ? Ide.getMenubar().createMenuItem((ToggleAction)editAction) : new JMenuItem(editAction)), 0.0f, false);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private QuickDiffMargin getQuickDiffMargin(BasicEditorPane editorPane) {
        return (QuickDiffMargin)editorPane.getClientProperty((Object)"quickdiff-margin");
    }

    private static class SelectReferenceAction
    extends AbstractAction {
        private final QuickDiffReferenceProvider _provider;

        SelectReferenceAction(QuickDiffReferenceProvider provider) {
            super(StringUtils.stripMnemonic((String)provider.getName()));
            this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)provider.getName()));
            this._provider = provider;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            QuickDiffManager.getInstance().getProviderObservable().setProvider(this._provider);
        }
    }
}

