/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.locale;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.locale.LocalePreferences;
import oracle.dbtools.common.resources.Resource;
import oracle.dbtools.common.resources.Resources;
import oracle.dbtools.common.resources.ResourcesContainer;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.i18n.Translatable;

public enum Localization {
    DE("de"),
    EN("en"),
    ES("es"),
    FR("fr"),
    IT("it"),
    JA("ja"),
    KO("ko"),
    PT_BR("pt", "BR"),
    ZH_CN("zh", "CN"),
    ZH_TW("zh", "TW");

    private final Locale locale;

    private Localization(String language) {
        this.locale = new Locale(language);
    }

    private Localization(String language, String country) {
        this.locale = new Locale(language, country);
    }

    public Locale locale() {
        return this.locale;
    }

    public Resources resources(Resources resources) {
        Localization defaultL8n = Localization.defaultLocalization();
        ResourcesContainer fallback = ResourcesContainer.builder(resources).base(defaultL8n.base()).build();
        ResourcesContainer specific = ResourcesContainer.builder(resources).base(this.base()).build();
        return new LocalizedResources(fallback, specific);
    }

    private String base() {
        StringBuilder b = new StringBuilder();
        b.append(this.locale.getLanguage().toLowerCase());
        String country = this.locale.getCountry();
        if (!NullOrEmpty.nullOrEmpty(country)) {
            b.append('_');
            b.append(country.toUpperCase());
        }
        b.append('/');
        return b.toString();
    }

    public static Localization defaultLocalization() {
        return EN;
    }

    public static Localization choose(HttpServletRequest request) {
        return Localization.choose((Iterable<Locale>)((Object)LocalePreferences.INSTANCE.preference(request)));
    }

    public static Localization choose(Iterable<Locale> locales) {
        Localization chosen = Localization.defaultLocalization();
        for (Locale locale : locales) {
            for (Localization localization : Localization.values()) {
                if (!Localization.matches(localization, locale)) continue;
                chosen = localization;
                return chosen;
            }
        }
        return chosen;
    }

    public String localize(Translatable text) {
        if (text == null) {
            return null;
        }
        return text.toString(Iterables.iterable(this.locale));
    }

    private static boolean matches(String expected, String actual) {
        return !NullOrEmpty.nullOrEmpty(expected) && expected.equals(actual);
    }

    private static boolean matches(Localization localization, Locale locale) {
        boolean matches = false;
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String localizationCountry = localization.locale.getCountry();
        String localizationLanguage = localization.locale.getLanguage();
        matches = Localization.matches(country, localizationCountry);
        if (!matches) {
            matches = Localization.matches(language, localizationLanguage);
        }
        return matches;
    }

    private static final class LocalizedResources
    implements Resources {
        private final Resources fallback;
        private final Resources specific;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LocalizedResources [specific=");
            builder.append(this.specific);
            builder.append(", fallback=");
            builder.append(this.fallback);
            builder.append("]");
            return builder.toString();
        }

        private LocalizedResources(Resources fallback, Resources specific) {
            this.fallback = fallback;
            this.specific = specific;
        }

        @Override
        public Resource get(Object key) {
            return this.get(key.toString());
        }

        @Override
        public Resource get(String path) {
            Resource resource = this.specific.get(path);
            if (resource == null) {
                resource = this.fallback.get(path);
            }
            return resource;
        }
    }
}

