/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Collection;
import java.util.List;
import oracle.dbtools.common.immutables.ImmutableIterator;
import oracle.dbtools.common.immutables.ImmutableList;
import oracle.dbtools.common.immutables.ImmutableListIterator;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.ListBuilder;
import oracle.dbtools.common.immutables.impl.ListIteratorImpl;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Unsupported;

class ListImpl<V>
implements ImmutableList<V> {
    private final List<V> target;
    static final ImmutableList<?> EMPTY = new ListImpl(CollectionFactory.list(0));

    private ListImpl(List<V> target) {
        this.target = target;
    }

    @Override
    public void add(int index, V element) {
        Unsupported.unsupported();
    }

    @Override
    public boolean add(V e) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        Unsupported.unsupported();
    }

    @Override
    public boolean contains(Object o) {
        return this.target.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.target.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Iterable)) {
            return false;
        }
        Iterable other = (Iterable)obj;
        return Iterables.equals(this, other);
    }

    @Override
    public V get(int index) {
        return this.target.get(index);
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.target.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public ImmutableIterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.target.lastIndexOf(o);
    }

    @Override
    public ImmutableListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ImmutableListIterator<V> listIterator(int index) {
        return ListIteratorImpl.newInstance(this.target, index);
    }

    @Override
    public ImmutableList.Builder<V> modify() {
        return ListBuilder.newInstance(this);
    }

    @Override
    public V remove(int index) {
        Unsupported.unsupported();
        return null;
    }

    @Override
    public boolean remove(Object o) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Unsupported.unsupported();
        return false;
    }

    @Override
    public V set(int index, V element) {
        Unsupported.unsupported();
        return null;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        List<V> subList = this.target.subList(fromIndex, toIndex);
        return ListImpl.newInstance(subList);
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.target.toArray(a);
    }

    public String toString() {
        return this.target.toString();
    }

    static <V> ImmutableList<V> newInstance(Iterable<V> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (NullOrEmpty.nullOrEmpty(elements)) {
            ImmutableList<?> empty = EMPTY;
            return empty;
        }
        if (elements instanceof ImmutableList) {
            ImmutableList immutable = (ImmutableList)elements;
            return immutable;
        }
        return new ListImpl<V>(CollectionFactory.asList(elements));
    }
}

