/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;

@ProxyFor(value={OracleConnection.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractTrueCacheConnection
implements Diagnosable {
    private static final String CLASS_NAME = AbstractTrueCacheConnection.class.getName();
    private static final short DB_VERSION_23ai = 23000;
    private static final String AUTH_TRUE_CACHE_SERVICE_NAME = "AUTH_TRUE_CACHE_SERVICE_NAME";
    private final ReentrantLock connectionLock = new ReentrantLock();
    private final Monitor.CloseableLock connectionClosableLock = Monitor.CloseableLock.wrap(this.connectionLock);
    OracleDriverExtension driverExtension;
    private String applicationURL;
    private Properties applicationProps;
    private String tcServiceName;
    private OracleConnection primaryConnection;
    private OracleConnection tcConnection;
    private boolean readOnly;
    int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    static final int BLOCKED = 16;
    LogicalConnection logicalConnectionAttached = null;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract OracleConnection getDelegate();

    @SetDelegate
    protected abstract void setDelegate(OracleConnection var1);

    void initialize(String url, @Blind(value=PropertiesBlinder.class) Properties info, OracleDriverExtension ext, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        this.applicationURL = url;
        this.driverExtension = ext;
        this.applicationProps = new Properties();
        if (info != null) {
            this.applicationProps.putAll((Map<?, ?>)info);
            this.applicationProps.remove("oracle.jdbc.useTrueCacheDriverConnection");
        }
        this.applicationProps.setProperty("InternalTrueCacheDriverMode", "true");
        PropertiesBlinder propertiesBlinder = new PropertiesBlinder();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "initialize", "url={0},connection props={1}", (String)null, (Throwable)null, (Object)url, (Object)propertiesBlinder.blind(info));
        this.primaryConnection = this.createPrimaryConnection();
        if (this.primaryConnection.getVersionNumber() < 23000) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1719).fillInStackTrace();
        }
        String tcServiceName = this.primaryConnection.getServerSessionInfo().getProperty(AUTH_TRUE_CACHE_SERVICE_NAME, "");
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "initialize", "True Cache service name={0}", (String)null, (Throwable)null, (Object)tcServiceName);
        if (tcServiceName == null || "".equals(tcServiceName)) {
            this.primaryConnection.close();
            this.primaryConnection = null;
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1720).fillInStackTrace();
        }
        this.tcServiceName = tcServiceName;
        try {
            this.tcConnection = this.createTrueCacheConnection();
        }
        catch (SQLException ex) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initialize", "unable to create physical connection to True Cache, continue with primary connection. exception={0}", (String)null, ex, (Object)ex.getMessage());
        }
        this.setDelegate(this.primaryConnection);
        this.lifecycle = 1;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "initialize", "created True Cache logical connection={0},primary connection={1},tc connection={2}", (String)null, (Throwable)null, (Object)this, (Object)this.getNetConnectionId(this.primaryConnection), (Object)this.getNetConnectionId(this.tcConnection));
    }

    private OracleConnection createPrimaryConnection() throws SQLException {
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(this.applicationURL);
        ods.setConnectionProperties(this.applicationProps);
        return (OracleConnection)ods.getConnection();
    }

    private OracleConnection createTrueCacheConnection() throws SQLException {
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(this.applicationURL);
        ods.setConnectionProperty("oracle.jdbc.targetServiceName", this.tcServiceName);
        ods.setConnectionProperties(this.applicationProps);
        return (OracleConnection)ods.getConnection();
    }

    OracleConnection getPrimaryConnection() {
        return this.primaryConnection;
    }

    OracleConnection getTrueCacheConnection() {
        return this.tcConnection;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.readOnly = readOnly;
            if (readOnly && this.isTrueCacheConnectionAvailable()) {
                this.setDelegate(this.tcConnection);
            } else {
                this.setDelegate(this.primaryConnection);
            }
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.requireOpenConnection();
        return this.readOnly;
    }

    public void setStmtCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.setStatementCacheSize(size);
        }
    }

    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.setStatementCacheSize(size);
        }
    }

    public void setStatementCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.setStatementCacheSize(size);
            if (this.isTrueCacheConnectionAvailable()) {
                this.tcConnection.setStatementCacheSize(size);
            }
        }
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.setImplicitCachingEnabled(cache);
            if (this.isTrueCacheConnectionAvailable()) {
                this.tcConnection.setImplicitCachingEnabled(cache);
            }
        }
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.setExplicitCachingEnabled(cache);
            if (this.isTrueCacheConnectionAvailable()) {
                this.tcConnection.setExplicitCachingEnabled(cache);
            }
        }
    }

    public void purgeImplicitCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.purgeImplicitCache();
            if (this.isTrueCacheConnectionAvailable()) {
                this.tcConnection.purgeImplicitCache();
            }
        }
    }

    public void purgeExplicitCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.purgeExplicitCache();
            if (this.isTrueCacheConnectionAvailable()) {
                this.tcConnection.purgeExplicitCache();
            }
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.setAutoCommit(autoCommit);
        }
    }

    public void commit() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.commit();
        }
    }

    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.commit(options);
        }
    }

    public void rollback() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            this.primaryConnection.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            try {
                if (this.isTrueCacheConnectionAvailable()) {
                    this.tcConnection.close();
                }
            }
            catch (SQLException ex) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "close", "failed to close True Cache physical connection={0},logical connection={1}", (String)null, ex, (Object)this, (Object)this.getNetConnectionId(this.tcConnection), (Object)this);
            }
            try {
                this.primaryConnection.close();
            }
            catch (SQLException ex) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "close", "error closing primary connection={0},logical connection={1}", (String)null, ex, (Object)this.getNetConnectionId(this.primaryConnection), (Object)this);
                throw ex;
            }
        }
        finally {
            this.primaryConnection = null;
            this.tcConnection = null;
            this.lifecycle = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int opt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            try {
                if (this.isTrueCacheConnectionAvailable()) {
                    this.tcConnection.close(opt);
                }
            }
            catch (SQLException ex) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "close", "failed to close True Cache physical connection={0},logical connection={1}", (String)null, ex, (Object)this, (Object)this.getNetConnectionId(this.tcConnection), (Object)this);
            }
            try {
                this.primaryConnection.close(opt);
            }
            catch (SQLException ex) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "close", "error closing primary connection={0},logical connection={1}", (String)null, ex, (Object)this.getNetConnectionId(this.primaryConnection), (Object)this);
                throw ex;
            }
        }
        finally {
            this.primaryConnection = null;
            this.tcConnection = null;
            this.lifecycle = 4;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            DatabaseMetaData databaseMetaData = this.primaryConnection.getMetaData();
            return databaseMetaData;
        }
    }

    public boolean isClosed() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            boolean bl = this.lifecycle != 1;
            return bl;
        }
    }

    public boolean isLifecycleOpen() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            boolean bl = this.lifecycle == 1;
            return bl;
        }
    }

    public void beginRequest() throws SQLException {
        this.primaryConnection.beginRequest();
        if (this.isTrueCacheConnectionAvailable()) {
            this.tcConnection.beginRequest();
        }
    }

    public void endRequest() throws SQLException {
        this.primaryConnection.endRequest();
        if (this.isTrueCacheConnectionAvailable()) {
            this.tcConnection.endRequest();
        }
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        boolean isTrueCacheConnectionValid;
        boolean isValid = this.primaryConnection.isValid(effort, timeout);
        if (this.isTrueCacheConnectionAvailable() && !(isTrueCacheConnectionValid = this.tcConnection.isValid(effort, timeout))) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "isValid", "invalid True Cache physical connection={0}, logical={1}. ", (String)null, (Throwable)null, (Object)this.getNetConnectionId(this.tcConnection), (Object)this);
            try {
                this.tcConnection.close();
            }
            catch (SQLException sqlEx) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "isValid", "error in closing True Cache physical connection={0}. ", (String)null, sqlEx, (Object)this.getNetConnectionId(this.tcConnection));
            }
            this.makeTrueCacheConnectionUnavailable();
        }
        return isValid;
    }

    public boolean isValid(int timeout) throws SQLException {
        boolean isTrueCacheConnectionValid;
        boolean isValid = this.primaryConnection.isValid(timeout);
        if (this.isTrueCacheConnectionAvailable() && !(isTrueCacheConnectionValid = this.tcConnection.isValid(timeout))) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "isValid", "invalid True Cache connection={0}, logical={1}. ", (String)null, (Throwable)null, (Object)this.getNetConnectionId(this.tcConnection), (Object)this);
            try {
                this.tcConnection.close();
            }
            catch (SQLException sqlEx) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "isValid", "error in closing True Cache connection={0}. ", (String)null, sqlEx, (Object)this.getNetConnectionId(this.tcConnection));
            }
            this.makeTrueCacheConnectionUnavailable();
        }
        return isValid;
    }

    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        LogicalConnection logicalConn;
        if (this.logicalConnectionAttached != null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143).fillInStackTrace();
        }
        this.logicalConnectionAttached = logicalConn = new LogicalConnection(pc, (OracleConnection)((Object)this), autoCommit);
        return logicalConn;
    }

    public void closeLogicalConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if (this.lifecycle == 1 || this.lifecycle == 16 || this.lifecycle == 2) {
                this.logicalConnectionAttached = null;
                this.lifecycle = 1;
            }
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(-1, -1);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OracleStatement oracleStatement = this.driverExtension.allocateStatement((OracleConnection)((Object)this), resultSetTypeEnum);
            return oracleStatement;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, -1, -1);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, autoGeneratedKeys);
            OraclePreparedStatement oraclePreparedStatement = this.driverExtension.allocatePreparedStatement((OracleConnection)((Object)this), sql, autoKeyInfo);
            return oraclePreparedStatement;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnIndexes);
            OraclePreparedStatement oraclePreparedStatement = this.driverExtension.allocatePreparedStatement((OracleConnection)((Object)this), sql, autoKeyInfo);
            return oraclePreparedStatement;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnNames);
            OraclePreparedStatement oraclePreparedStatement = this.driverExtension.allocatePreparedStatement((OracleConnection)((Object)this), sql, autoKeyInfo);
            return oraclePreparedStatement;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OraclePreparedStatement oraclePreparedStatement = this.driverExtension.allocatePreparedStatement((OracleConnection)((Object)this), sql, resultSetTypeEnum);
            return oraclePreparedStatement;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, -1, -1);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.requireOpenConnection();
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OracleCallableStatement oracleCallableStatement = this.driverExtension.allocateCallableStatement((OracleConnection)((Object)this), sql, resultSetTypeEnum);
            return oracleCallableStatement;
        }
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m, SQLException e) throws SQLException {
        this.checkAndReleaseConnectionLock();
        throw e;
    }

    Monitor.CloseableLock acquireConnectionCloseableLock() {
        this.acquireConnectionLock();
        return this.connectionClosableLock;
    }

    void acquireConnectionLock() {
        this.connectionLock.lock();
    }

    void releaseConnectionLock() {
        this.connectionLock.unlock();
    }

    void checkAndReleaseConnectionLock() {
        if (this.connectionLock.isHeldByCurrentThread()) {
            this.connectionLock.unlock();
        }
    }

    void requireOpenConnection() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
    }

    OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)((Object)this);
    }

    boolean isTrueCacheConnectionAvailable() {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            boolean bl = this.tcConnection != null;
            return bl;
        }
    }

    void makeTrueCacheConnectionUnavailable() {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.tcConnection = null;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private String getNetConnectionId(OracleConnection conn) {
        try {
            return conn == null ? "NA" : conn.getNetConnectionId();
        }
        catch (SQLException e) {
            return e.getMessage();
        }
    }
}

