/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.ImmutableDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public final class ModelSolutionDefinition
extends ImmutableDefinition {
    private Model m_Model = null;
    private SourceDefinition m_DefaultValues = null;

    ModelSolutionDefinition(Model model, SourceDefinition sourceDefinition, Transaction transaction) {
        super(sourceDefinition.getDataProvider()._getSourceIDProvider().createModelSolutionID(), sourceDefinition.getDataProvider(), transaction);
        this.m_Model = model;
        this.m_DefaultValues = sourceDefinition;
    }

    @Override
    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitModelSolutionDefinition(this, object);
    }

    @Override
    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        set.addAll(this.getModel().getInputs());
        this.getDefaultValuesDefinition().accumulateInputs(set, transaction, bl, bl2);
    }

    @Override
    final void accumulateOutputs(List list, Transaction transaction) {
        list.addAll(this.getModel().getOutputs());
    }

    @Override
    protected SourceDefinition getType() {
        return this.getModel().getType().getDefinition();
    }

    @Override
    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        CustomModel customModel = this.getDataProvider().createModel(source, this.getModel().getType());
        for (Assignment assignment : this.getModel().getAssignments()) {
            Model model = assignment.getAssignedSource().getDefinition().findOrCreateExtractModel(source, transaction);
            for (Assignment assignment2 : model.getAssignments()) {
                assignment2.assign(customModel, assignment.getAssignedSource(), source);
            }
        }
        return customModel;
    }

    @Override
    public final Model getModel() {
        return this.m_Model;
    }

    public final SourceDefinition getDefaultValuesDefinition() {
        return this.m_DefaultValues;
    }
}

