/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import java.util.HashMap;
import java.util.Map;
import oracle.express.aw.AWExpressionGenerator;
import oracle.express.aw.AWExpressionInfo;
import oracle.express.aw.AWHelper;
import oracle.express.aw.AWHelper10;
import oracle.express.aw.AWHelperCF;
import oracle.express.aw.AWMetadataLookup;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceExpressionFactory;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmCustomExpression;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;

public final class AWSourceExpressionFactory
extends SourceExpressionFactory {
    private AWExpressionGenerator m_ExpressionGenerator = new AWExpressionGenerator();
    private AWMetadataLookup m_AWMetadataLookup = null;
    private MdmMetadataProvider m_MdmMetadataProvider = null;
    private Map m_ExpressionMap = new HashMap();
    private AWHelper m_AWHelper = null;

    public AWSourceExpressionFactory(DataProvider dataProvider, MdmMetadataProvider mdmMetadataProvider) {
        super(dataProvider);
        this.m_AWMetadataLookup = AWSourceExpressionFactory.createAWLookup(dataProvider);
        this.m_AWHelper = AWSourceExpressionFactory.createAWHelper(this.m_AWMetadataLookup);
        this.m_MdmMetadataProvider = mdmMetadataProvider;
    }

    public boolean isEnabled() {
        return this.m_AWHelper != null && this.m_AWMetadataLookup != null;
    }

    public static AWMetadataLookup createAWLookup(DataProvider dataProvider) {
        return new AWMetadataLookup(dataProvider);
    }

    public static AWHelper createAWHelper(AWMetadataLookup aWMetadataLookup) {
        AWHelper aWHelper = null;
        aWHelper = new AWHelper10(aWMetadataLookup);
        if (aWHelper.initialize()) {
            return aWHelper;
        }
        aWHelper = new AWHelperCF(aWMetadataLookup);
        if (aWHelper.initialize()) {
            return aWHelper;
        }
        return null;
    }

    private AWExpressionInfo getExpressionInfo(Source source) throws Exception {
        return this.getExpressionInfo(new Source[]{source});
    }

    private AWExpressionInfo getExpressionInfo(Source source, Source source2) throws Exception {
        return this.getExpressionInfo(new Source[]{source, source2});
    }

    private AWExpressionInfo getExpressionInfo(Source source, Source source2, Source source3) throws Exception {
        return this.getExpressionInfo(new Source[]{source, source2, source3});
    }

    private AWExpressionInfo getExpressionInfo(Source[] sourceArray) throws Exception {
        if (!this.isEnabled()) {
            throw new Exception("AW Generation is not available.");
        }
        AWExpressionInfo aWExpressionInfo = new AWExpressionInfo(sourceArray.length, this);
        for (int i = 0; i < sourceArray.length; ++i) {
            aWExpressionInfo.addExpressionForSource(sourceArray[i]);
        }
        return aWExpressionInfo;
    }

    private MtmCustomExpression createMtmCustomExpression(String string, AWExpressionInfo aWExpressionInfo, String string2) {
        String string3 = aWExpressionInfo.getRowToCellColumnName();
        StringBuffer stringBuffer = new StringBuffer(160);
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(string3);
        stringBuffer.append(',');
        this.appendQuotedLine(stringBuffer, string2);
        stringBuffer.append(')');
        MtmCustomExpression mtmCustomExpression = this.getMdmCustomObjectFactory().createCustomExpression(stringBuffer.toString());
        return mtmCustomExpression;
    }

    private void appendQuotedLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append("'");
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(39, ++n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("''");
            n = n2;
        }
        stringBuffer.append(string.substring(n));
        stringBuffer.append("'");
    }

    private NumberSource createNumericExpressionSource(String string, AWExpressionInfo aWExpressionInfo) {
        MtmCustomExpression mtmCustomExpression = this.createMtmCustomExpression("OLAP_EXPRESSION", aWExpressionInfo, string);
        MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)aWExpressionInfo.getMtmObject();
        MdmMeasure mdmMeasure = this.getMdmCustomObjectFactory().createNumericMeasure("AWMeasure" + this.m_MdmMetadataProvider.getUniqueNumberString(), mtmPartitionedCube, mtmCustomExpression);
        return (NumberSource)mdmMeasure.getSource();
    }

    private StringSource createStringExpressionSource(String string, AWExpressionInfo aWExpressionInfo) {
        MtmCustomExpression mtmCustomExpression = this.createMtmCustomExpression("OLAP_EXPRESSION_TEXT", aWExpressionInfo, string);
        MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)aWExpressionInfo.getMtmObject();
        MdmMeasure mdmMeasure = this.getMdmCustomObjectFactory().createStringMeasure("AWMeasure" + this.m_MdmMetadataProvider.getUniqueNumberString(), mtmPartitionedCube, mtmCustomExpression);
        return (StringSource)mdmMeasure.getSource();
    }

    private BooleanSource createBooleanExpressionSource(String string, AWExpressionInfo aWExpressionInfo) {
        MtmCustomExpression mtmCustomExpression = this.createMtmCustomExpression("OLAP_EXPRESSION_BOOL", aWExpressionInfo, string);
        MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)aWExpressionInfo.getMtmObject();
        MdmMeasure mdmMeasure = this.getMdmCustomObjectFactory().createBooleanMeasure("AWMeasure" + this.m_MdmMetadataProvider.getUniqueNumberString(), mtmPartitionedCube, mtmCustomExpression);
        return (BooleanSource)mdmMeasure.getSource();
    }

    private DateSource createDateExpressionSource(String string, AWExpressionInfo aWExpressionInfo) {
        MtmCustomExpression mtmCustomExpression = this.createMtmCustomExpression("OLAP_EXPRESSION_DATE", aWExpressionInfo, string);
        MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)aWExpressionInfo.getMtmObject();
        MdmMeasure mdmMeasure = this.getMdmCustomObjectFactory().createDateMeasure("AWMeasure" + this.m_MdmMetadataProvider.getUniqueNumberString(), mtmPartitionedCube, mtmCustomExpression);
        return (DateSource)mdmMeasure.getSource();
    }

    AWExpressionGenerator getExpressionGenerator() {
        return this.m_ExpressionGenerator;
    }

    private Map getExpressionMap() {
        return this.m_ExpressionMap;
    }

    AWMetadataLookup getAWMetadataLookup() {
        return this.m_AWMetadataLookup;
    }

    private MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MdmMetadataProvider;
    }

    private MdmCustomObjectFactory getMdmCustomObjectFactory() {
        return this.getMdmMetadataProvider().getMdmCustomObjectFactory();
    }

    @Override
    public final NumberSource abs(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().abs(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.abs(numberSource);
    }

    @Override
    public final BooleanSource and(BooleanSource booleanSource, BooleanSource booleanSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource, booleanSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().and(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.and(booleanSource, booleanSource2);
    }

    @Override
    public final NumberSource arccos(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().arccos(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.arccos(numberSource);
    }

    @Override
    public final NumberSource arcsin(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().arcsin(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.arcsin(numberSource);
    }

    @Override
    public final NumberSource arctan(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().arctan(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.arctan(numberSource);
    }

    @Override
    public final NumberSource cos(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().cos(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.cos(numberSource);
    }

    @Override
    public final NumberSource cosh(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().cosh(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.cosh(numberSource);
    }

    @Override
    public final NumberSource div(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().div(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.div(numberSource, numberSource2);
    }

    @Override
    public final BooleanSource eq(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().eq(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.eq(source, source2);
    }

    @Override
    public final BooleanSource ge(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().ge(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.ge(source, source2);
    }

    @Override
    public final BooleanSource gt(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().gt(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.gt(source, source2);
    }

    @Override
    public final BooleanSource hasValue(Source source) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().hasValue(aWExpressionInfo.getExpression(0));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.hasValue(source);
    }

    @Override
    public final DateSource implies(BooleanSource booleanSource, DateSource dateSource, DateSource dateSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource, dateSource, dateSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().implies(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createDateExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.implies(booleanSource, dateSource, dateSource2);
    }

    @Override
    public final NumberSource implies(BooleanSource booleanSource, NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource, numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().implies(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.implies(booleanSource, numberSource, numberSource2);
    }

    @Override
    public final StringSource implies(BooleanSource booleanSource, StringSource stringSource, StringSource stringSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource, stringSource, stringSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().implies(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.implies(booleanSource, stringSource, stringSource2);
    }

    @Override
    public final NumberSource indexOf(StringSource stringSource, StringSource stringSource2, NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, stringSource2, numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().indexOf(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.indexOf(stringSource, stringSource2, numberSource);
    }

    @Override
    public final NumberSource intpart(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().intpart(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.intpart(numberSource);
    }

    @Override
    public final BooleanSource le(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().le(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.le(source, source2);
    }

    @Override
    public final NumberSource length(StringSource stringSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().length(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.length(stringSource);
    }

    @Override
    public final BooleanSource like(StringSource stringSource, StringSource stringSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, stringSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().like(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.like(stringSource, stringSource2);
    }

    @Override
    public final NumberSource log(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().log(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.log(numberSource);
    }

    @Override
    public final BooleanSource lt(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().lt(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.lt(source, source2);
    }

    @Override
    public final NumberSource minus(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().minus(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.minus(numberSource, numberSource2);
    }

    @Override
    public final BooleanSource ne(Source source, Source source2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(source, source2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().ne(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.ne(source, source2);
    }

    @Override
    public final NumberSource negate(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().negate(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.negate(numberSource);
    }

    @Override
    public final BooleanSource not(BooleanSource booleanSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().not(aWExpressionInfo.getExpression(0));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.not(booleanSource);
    }

    @Override
    public final BooleanSource or(BooleanSource booleanSource, BooleanSource booleanSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(booleanSource, booleanSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().or(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createBooleanExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.or(booleanSource, booleanSource2);
    }

    @Override
    public final NumberSource plus(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().plus(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.plus(numberSource, numberSource2);
    }

    @Override
    public final DateSource plusDays(DateSource dateSource, NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(dateSource, numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().plusDays(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createDateExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.plusDays(dateSource, numberSource);
    }

    @Override
    public final DateSource plusMonths(DateSource dateSource, NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(dateSource, numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().plusMonths(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createDateExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.plusMonths(dateSource, numberSource);
    }

    @Override
    public final NumberSource pow(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().pow(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.pow(numberSource, numberSource2);
    }

    @Override
    public final NumberSource rem(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().rem(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.rem(numberSource, numberSource2);
    }

    @Override
    public final StringSource remove(StringSource stringSource, NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().remove(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.remove(stringSource, numberSource, numberSource2);
    }

    @Override
    public final StringSource replace(StringSource stringSource, StringSource stringSource2, StringSource stringSource3) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, stringSource2, stringSource3);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().replace(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.replace(stringSource, stringSource2, stringSource3);
    }

    @Override
    public final NumberSource round(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().round(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.round(numberSource, numberSource2);
    }

    @Override
    public final NumberSource sin(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().sin(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.sin(numberSource);
    }

    @Override
    public final NumberSource sinh(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().sinh(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.sinh(numberSource);
    }

    @Override
    public final NumberSource sqrt(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().sqrt(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.sqrt(numberSource);
    }

    @Override
    public final StringSource substring(StringSource stringSource, NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().substring(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1), aWExpressionInfo.getExpression(2));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.substring(stringSource, numberSource, numberSource2);
    }

    @Override
    public final NumberSource tan(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().tan(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.tan(numberSource);
    }

    @Override
    public final NumberSource tanh(NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().tanh(aWExpressionInfo.getExpression(0));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.tanh(numberSource);
    }

    @Override
    public final StringSource textFill(StringSource stringSource, NumberSource numberSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource, numberSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().textFill(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.textFill(stringSource, numberSource);
    }

    @Override
    public final NumberSource times(NumberSource numberSource, NumberSource numberSource2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource, numberSource2);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().times(aWExpressionInfo.getExpression(0), aWExpressionInfo.getExpression(1));
                return this.createNumericExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.times(numberSource, numberSource2);
    }

    @Override
    public final StringSource toLowercase(StringSource stringSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().toLowercase(aWExpressionInfo.getExpression(0));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.toLowercase(stringSource);
    }

    @Override
    public final StringSource trim(StringSource stringSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().trim(aWExpressionInfo.getExpression(0));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.trim(stringSource);
    }

    @Override
    public final StringSource trimLeading(StringSource stringSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().trimLeading(aWExpressionInfo.getExpression(0));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.trimLeading(stringSource);
    }

    @Override
    public final StringSource trimTrailing(StringSource stringSource) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(stringSource);
            if (aWExpressionInfo.isValid()) {
                String string = this.getExpressionGenerator().trimTrailing(aWExpressionInfo.getExpression(0));
                return this.createStringExpressionSource(string, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.trimTrailing(stringSource);
    }

    @Override
    public NumberSource lag(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            String string = null;
            if (this.isEnabled()) {
                string = this.m_AWHelper.getAWName(mdmLevelHierarchy);
            }
            if (string != null && aWExpressionInfo.isValid()) {
                String string2 = this.getExpressionGenerator().generateLagFunction(aWExpressionInfo.getExpression(0), n, string, this.m_AWHelper.getLevelRelation(mdmLevelHierarchy));
                return this.createNumericExpressionSource(string2, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.lag(numberSource, mdmLevelHierarchy, n);
    }

    @Override
    public NumberSource lagDays(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            String string = null;
            if (this.isEnabled()) {
                string = this.m_AWHelper.getAWName(mdmLevelHierarchy);
            }
            if (string != null && aWExpressionInfo.isValid()) {
                String string2 = this.getExpressionGenerator().generateLagDaysFunction(aWExpressionInfo.getExpression(0), n, string, this.m_AWHelper.getEnddate(mdmLevelHierarchy), this.m_AWHelper.getTimeSpan(mdmLevelHierarchy), this.m_AWHelper.getHierarchyDimension(mdmLevelHierarchy), this.m_AWHelper.getHierarchyName(mdmLevelHierarchy), this.m_AWHelper.getLevelRelation(mdmLevelHierarchy));
                return this.createNumericExpressionSource(string2, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.lagDays(numberSource, mdmLevelHierarchy, n);
    }

    @Override
    public NumberSource lagMonths(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            String string = null;
            if (this.isEnabled()) {
                string = this.m_AWHelper.getAWName(mdmLevelHierarchy);
            }
            if (string != null && aWExpressionInfo.isValid()) {
                String string2 = this.getExpressionGenerator().generateLagMonthsFunction(aWExpressionInfo.getExpression(0), n, string, this.m_AWHelper.getEnddate(mdmLevelHierarchy), this.m_AWHelper.getTimeSpan(mdmLevelHierarchy), this.m_AWHelper.getHierarchyDimension(mdmLevelHierarchy), this.m_AWHelper.getHierarchyName(mdmLevelHierarchy), this.m_AWHelper.getLevelRelation(mdmLevelHierarchy));
                return this.createNumericExpressionSource(string2, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.lagMonths(numberSource, mdmLevelHierarchy, n);
    }

    @Override
    public NumberSource movingAverage(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            String string = null;
            if (this.isEnabled()) {
                string = this.m_AWHelper.getAWName(mdmLevelHierarchy);
            }
            if (string != null && aWExpressionInfo.isValid()) {
                String string2 = this.getExpressionGenerator().generateMovingAverageFunction(aWExpressionInfo.getExpression(0), string, this.m_AWHelper.getLevelRelation(mdmLevelHierarchy), n, n2);
                return this.createNumericExpressionSource(string2, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.movingAverage(numberSource, mdmLevelHierarchy, n, n2);
    }

    @Override
    public NumberSource cumulativeTotal(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        try {
            AWExpressionInfo aWExpressionInfo = this.getExpressionInfo(numberSource);
            String string = this.m_AWHelper.getAWName(mdmLevelHierarchy);
            if (string != null && aWExpressionInfo.isValid()) {
                String string2 = this.getExpressionGenerator().generateCumulativeTotalFunction(aWExpressionInfo.getExpression(0), string, this.m_AWHelper.getHierarchyDimension(mdmLevelHierarchy), this.m_AWHelper.getHierarchyName(mdmLevelHierarchy), this.m_AWHelper.getLevelName(mdmLevel), this.m_AWHelper.getLevelDimension(mdmLevelHierarchy), this.m_AWHelper.getLevelRelation(mdmLevelHierarchy), this.m_AWHelper.getParentRelation(mdmLevelHierarchy), this.m_AWHelper.getFamilyRelation(mdmLevelHierarchy), n);
                return this.createNumericExpressionSource(string2, aWExpressionInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.cumulativeTotal(numberSource, mdmLevelHierarchy, n, mdmLevel);
    }
}

